<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwMail.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwMail.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwMail
{
    var $_pw_host = '127.0.0.1';
    var $_pw_port = '25';

    //1:Pearライブラリ使用（SMTP設定が使用できるときに使う）
    //2:php標準メール関数使用
    var $_pw_type = 1;

    var $_pw_sender;
    var $_pw_recipients = array();
    var $_pw_to         = array();
    var $_pw_cc         = array();
    var $_pw_bcc        = array();

    var $_pw_subject;
    var $_pw_body;
    var $_pw_file  = array();
    var $_pw_fname = array();

    /**
     * Creates new instance.
     * @access public
     */
    function xbpwMail($host, $port, $type)
    {
        if (isset($host) || !is_null($host) || $host!='') {
            $this->_pw_host = $host;
        }
        if (isset($port) || !is_null($port) || $port!='') {
            $this->_pw_port = $port;
        }
        if (isset($type) || !is_null($type) || $type!='') {
            $this->_pw_type = $type;
        }
    }

    /**
     * Setting mail sender
     *       ex1) demo@mail.com
     *       ex2) Mr.Demo <demo@mail.com>
     * @access public
     */
    function setSender($sender)
    {
        if (is_array($sender)) {
            $name = base64_encode(mb_convert_encoding($sender['name'], 'ISO-2022-JP', PW_ENCODE));
            $this->_pw_sender = "=?ISO-2022-JP?B?" . $name . "?=<" . $sender['mail'] . ">";
        }
        else {
            $this->_pw_sender = mb_convert_encoding($sender, 'ISO-2022-JP', PW_ENCODE);
        }
    }

    /**
     * Adding to
     *       ex1) demo@mail.com
     *       ex2) Mr.Demo <demo@mail.com>
     * @access public
     */
    function addTo($to)
    {
        if (is_array($to)) {
            $name = base64_encode(mb_convert_encoding($to['name'], 'ISO-2022-JP', PW_ENCODE));
            $this->_pw_to[] = "=?ISO-2022-JP?B?" . $name . "?=<" . $to['mail'] . ">";
        }
        else {
            $this->_pw_to[] = mb_convert_encoding($to, 'ISO-2022-JP', PW_ENCODE);
        }
    }

    /**
     * Adding cc
     *       ex1) demo@mail.com
     *       ex2) Mr.Demo <demo@mail.com>
     * @access public
     */
    function addCC($cc)
    {
        if (is_array($cc)) {
            $name = base64_encode(mb_convert_encoding($cc['name'], 'ISO-2022-JP', PW_ENCODE));
            $this->_pw_cc[] = "=?ISO-2022-JP?B?" . $name . "?=<" . $cc['mail'] . ">";
        }
        else {
            $this->_pw_cc[] = mb_convert_encoding($cc, 'ISO-2022-JP', PW_ENCODE);
        }
    }

    /**
     * Adding bcc
     *       ex1) demo@mail.com
     *       ex2) Mr.Demo <demo@mail.com>
     * @access public
     */
    function addBCC($bcc)
    {
        if (is_array($bcc)) {
            $name = base64_encode(mb_convert_encoding($bcc['name'], 'ISO-2022-JP', PW_ENCODE));
            $this->_pw_bcc[] = "=?ISO-2022-JP?B?" . $name . "?=<" . $bcc['mail'] . ">";
        }
        else {
            $this->_pw_bcc[] = mb_convert_encoding($bcc, 'ISO-2022-JP', PW_ENCODE);
        }
    }

    /**
     * Setting subject
     * @access public
     */
    function setSubject($subject)
    {
        $this->_pw_subject = mb_convert_encoding($subject, 'ISO-2022-JP', PW_ENCODE);
    }

    /**
     * Setting body
     * @access public
     */
    function setBody($body)
    {
        $this->_pw_body = mb_convert_encoding($body, 'ISO-2022-JP', PW_ENCODE);
    }

    /**
     * Adding file
     * @param file: file full path
     * @param filenm: display file name
     * @access public
     */
    function addFile($file, $filenm)
    {
        $this->_pw_file[]  = mb_convert_encoding($file, 'ISO-2022-JP', PW_ENCODE);
        $this->_pw_fname[] = mb_convert_encoding($filenm, 'ISO-2022-JP', PW_ENCODE);
    }

    /**
     * mail sending
     * @access public
     */
    function send()
    {
        if($this->_pw_type == 1){
            return $this->pearSendMail();
        }
        else{
            return $this->phpSendMail();
        }
    }

    /**
     * pear send mail
     * @access public
     */
    function pearSendMail()
    {
        require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Mail' . DS . 'mimePart.php');
        require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Mail' . DS . 'mime.php');
        require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Mail.php');

        $host = array();
        $host['host'] = $this->_pw_host;
        $host['port'] = $this->_pw_port;
        $host['localhost'] = $this->_pw_host;

        //create instance
        $mime = & new Mail_mime();

        //setting sender
        $mime->setFrom($this->_pw_sender);

        //setting subject
        $mime->setSubject($this->_pw_subject);

        //setting body
        $mime->setTXTBody($this->_pw_body);

        //adding to
        for ($i=0; $i<count($this->_pw_to); $i++) {
            $mime->_headers['To'] .= ($i == 0)?$this->_pw_to[$i]:", ".$this->_pw_to[$i];
            $this->_pw_recipients[] = $this->_pw_to[$i];
        }

        //adding cc
        for ($i=0; $i<count($this->_pw_cc); $i++) {
            $mime->addCc($this->_pw_cc[$i]);
            $this->_pw_recipients[] = $this->_pw_cc[$i];
        }

        //adding bcc
        for($i=0; $i<count($this->_pw_bcc); $i++) {
            $mime->addBcc($this->_pw_bcc[$i]);
            $this->_pw_recipients[] = $this->_pw_bcc[$i];
        }

        //adding tempfile
        for ($i=0; $i<count($this->_pw_file); $i++) {
            $mime->addAttachment($this->_pw_file[$i], 'application/octet-stream', $this->_pw_fname[$i]);
        }

        //setting encodde
        $build_param = array();
        $build_param['text_charset'] = "ISO-2022-JP";
        $build_param['head_charset'] = "ISO-2022-JP";

        $body = $mime->get($build_param);
        $hdrs = $mime->headers();
        debugLog('Mail Header:' . print_r($hdrs, 1));

        $mail =& Mail::factory('smtp', $host);
        $result = $mail->send($this->_pw_recipients, $hdrs, $body);
        debugLog('Mail Result:' . print_r($result, 1));

        if(is_object($result)) {
            $result_info = array();
            $result_info['r_message'] = $result->getMessage();
        }
        else {
            $result_info = true;
        }

        return $result_info;
    }

    /**
     * php send mail
     * @access public
     */
    function phpSendMail()
    {
        $headers = array();

        //setting sender
        $headers[] = "From:" . $this->_pw_sender . "\nReply-To:" . $this->_pw_sender;

        //setting subject
        $subject = $this->_pw_subject;

        //setting body
        $body = $this->_pw_body;

        //adding cc
        if(count($this->_pw_cc)>0){
            $headers[] = "Cc:" . implode( ",", $this->_pw_cc);
        }

        //adding bcc
        if(count($this->_pw_bcc)>0){
            $headers[] = "Bcc:" . implode( ",", $this->_pw_bcc);
        }

        //adding tempfile
        $tempbody = '';
        $fCount = count($this->_pw_file);
        for ($i=0; $i<$fCount; $i++) {
            //物理ファイル取得
            $fp = @fopen($this->_pw_file[$i], 'r');
            $contents = @fread($fp, filesize($this->_pw_file[$i]));
            @fclose($fp);

            //添付ファイル用メッセージ追加
            $tempbody .= "\n--boundary_str\n";
            $tempbody .= "Content-Type: application/octet-stream\n";
            $tempbody .= "Content-Transfer-Encoding: base64\n";
            $tempbody .= "Content-Disposition: attachment; filename=\"".$this->_pw_fname[$i]."\"\n\n";
            $tempbody .= base64_encode($contents)."\n";
            $tempbody .= "--boundary_str\n";
        }
        if ($fCount==0) {
            $headers[] = "MIME-Version:1.0\nContent-Type:text/plain; charset=ISO-2022-JP\nContent-Transfer-Encoding: 7bit";
        }
        else {
            $headers[] = "MIME-Version:1.0\nContent-Type:multipart/mixed; boundary=\"boundary_str\"; charset=ISO-2022-JP\nContent-Transfer-Encoding: 7bit";
        }
        mb_send_mail(implode( ",", $this->_pw_to), $subject, $body . $tempbody, implode( "\n", $headers)."\n");
        return true;
    }
}
