/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.plaf.persistence.xml.Base64;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.command.Option;
import org.weasis.core.api.command.Options;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.explorer.model.Tree;
import org.weasis.core.api.explorer.model.TreeModel;
import org.weasis.core.api.explorer.model.TreeModelNode;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.service.BundleTools;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.DicomEncapDocElement;
import org.weasis.dicom.codec.DicomEncapDocSeries;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.DicomVideoElement;
import org.weasis.dicom.codec.DicomVideoSeries;
import org.weasis.dicom.codec.SortSeriesStack;
import org.weasis.dicom.codec.display.Modality;
import org.weasis.dicom.explorer.LoadLocalDicom;
import org.weasis.dicom.explorer.internal.Activator;
import org.weasis.dicom.explorer.wado.LoadRemoteDicom;

public class DicomModel
implements TreeModel,
DataExplorerModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DicomModel.class);
    public static final String[] functions = new String[]{"get", "close"};
    public static final String NAME = "DICOM";
    public static final String PREFERENCE_NODE = "dicom.model";
    public static final TreeModelNode patient = new TreeModelNode(1, 0, TagW.PatientPseudoUID);
    public static final TreeModelNode study = new TreeModelNode(2, 0, TagW.StudyInstanceUID);
    public static final TreeModelNode series = new TreeModelNode(3, 0, TagW.SubseriesInstanceUID);
    public static final ArrayList<TreeModelNode> modelStrucure = new ArrayList(5);
    public static final Executor loadingExecutor;
    private final Tree<MediaSeriesGroup> model;
    private PropertyChangeSupport propertyChange = null;
    private final TagW[] multiframeSplittingRules = new TagW[]{TagW.ImageType, TagW.SOPInstanceUID, TagW.FrameType, TagW.FrameAcquisitionNumber, TagW.StackID};
    private final HashMap<Modality, TagW[]> splittingRules = new HashMap();

    public DicomModel() {
        this.model = new Tree((Object)rootNode);
        Preferences prefs = Activator.PREFERENCES.getDefaultPreferences();
        if (prefs != null) {
            Preferences preferences = prefs.node(PREFERENCE_NODE);
        }
        this.splittingRules.put(Modality.Default, new TagW[]{TagW.ImageType, TagW.ContrastBolusAgent, TagW.SOPClassUID});
        this.splittingRules.put(Modality.CT, new TagW[]{TagW.ImageType, TagW.ContrastBolusAgent, TagW.SOPClassUID, TagW.ImageOrientationPlane, TagW.GantryDetectorTilt, TagW.ConvolutionKernel});
        this.splittingRules.put(Modality.PT, this.splittingRules.get(Modality.CT));
        this.splittingRules.put(Modality.MR, new TagW[]{TagW.ImageType, TagW.ContrastBolusAgent, TagW.SOPClassUID, TagW.ImageOrientationPlane, TagW.ScanningSequence, TagW.SequenceVariant, TagW.ScanOptions, TagW.RepetitionTime, TagW.EchoTime, TagW.InversionTime, TagW.FlipAngle});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Codec> getCodecPlugins() {
        ArrayList<Codec> codecPlugins = new ArrayList<Codec>(1);
        List list = BundleTools.CODEC_PLUGINS;
        synchronized (list) {
            for (Codec codec : BundleTools.CODEC_PLUGINS) {
                if (codec == null || !codec.isMimeTypeSupported("application/dicom") || codecPlugins.contains(codec)) continue;
                codecPlugins.add(codec);
            }
        }
        return codecPlugins;
    }

    public Collection<MediaSeriesGroup> getChildren(MediaSeriesGroup node) {
        return this.model.getSuccessors((Object)node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaSeriesGroup getHierarchyNode(MediaSeriesGroup parent, Object value) {
        if (parent != null || value != null) {
            Tree<MediaSeriesGroup> tree = this.model;
            synchronized (tree) {
                for (MediaSeriesGroup node : this.model.getSuccessors((Object)parent)) {
                    if (!node.equals(value)) continue;
                    return node;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHierarchyNode(MediaSeriesGroup root, MediaSeriesGroup leaf) {
        Tree<MediaSeriesGroup> tree = this.model;
        synchronized (tree) {
            this.model.addLeaf((Object)root, (Object)leaf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchyNode(MediaSeriesGroup root, MediaSeriesGroup leaf) {
        Tree<MediaSeriesGroup> tree = this.model;
        synchronized (tree) {
            Tree tree2 = this.model.getTree((Object)root);
            if (tree2 != null) {
                tree2.removeLeaf((Object)leaf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaSeriesGroup getParent(MediaSeriesGroup node, TreeModelNode modelNode) {
        if (null != node && modelNode != null) {
            Tree<MediaSeriesGroup> tree = this.model;
            synchronized (tree) {
                Tree tree2 = this.model.getTree((Object)node);
                if (tree2 != null) {
                    Tree parent = null;
                    while ((parent = tree2.getParent()) != null) {
                        if (((MediaSeriesGroup)parent.getHead()).getTagID().equals((Object)modelNode.getTagElement())) {
                            return (MediaSeriesGroup)parent.getHead();
                        }
                        tree2 = parent;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Tree<MediaSeriesGroup> tree = this.model;
        synchronized (tree) {
            for (MediaSeriesGroup pt : this.getChildren(TreeModel.rootNode)) {
                Collection<MediaSeriesGroup> studies = this.getChildren(pt);
                for (MediaSeriesGroup study : studies) {
                    Collection<MediaSeriesGroup> seriesList = this.getChildren(study);
                    for (MediaSeriesGroup item : seriesList) {
                        if (!(item instanceof Series)) continue;
                        ((Series)item).dispose();
                    }
                }
            }
        }
    }

    public String toString() {
        return NAME;
    }

    public List<TreeModelNode> getModelStructure() {
        return modelStrucure;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        this.propertyChange.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.propertyChange != null) {
            this.propertyChange.removePropertyChangeListener(propertychangelistener);
        }
    }

    public void firePropertyChange(final ObservableEvent event) {
        if (this.propertyChange != null) {
            if (event == null) {
                throw new NullPointerException();
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.propertyChange.firePropertyChange((PropertyChangeEvent)event);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DicomModel.this.propertyChange.firePropertyChange((PropertyChangeEvent)event);
                    }
                });
            }
        }
    }

    public void mergeSeries(Series[] seriesList) {
        if (seriesList != null && seriesList.length > 1) {
            String uid = (String)seriesList[0].getTagValue(TagW.SeriesInstanceUID);
            boolean sameOrigin = true;
            if (uid != null) {
                for (int i = 1; i < seriesList.length; ++i) {
                    if (uid.equals(seriesList[i].getTagValue(TagW.SeriesInstanceUID))) continue;
                    sameOrigin = false;
                    break;
                }
            }
            if (sameOrigin) {
                int min = Integer.MAX_VALUE;
                Series base = seriesList[0];
                for (Series series : seriesList) {
                    Integer splitNb = (Integer)series.getTagValue(TagW.SplitSeriesNumber);
                    if (splitNb == null || min <= splitNb) continue;
                    min = splitNb;
                    base = series;
                }
                for (Series series : seriesList) {
                    if (series == base) continue;
                    base.addAll((Collection)series.getMedias());
                    this.removeSeries((MediaSeriesGroup)series);
                }
                base.sort(SortSeriesStack.instanceNumber);
                this.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Replace, (Object)this, (Object)base, (Object)base));
            }
        }
    }

    public void removeSeries(MediaSeriesGroup dicomSeries) {
        if (dicomSeries != null) {
            if (LoadRemoteDicom.currentTasks.size() > 0 && dicomSeries instanceof DicomSeries) {
                LoadRemoteDicom.stopDownloading((DicomSeries)dicomSeries);
            }
            this.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Remove, (Object)this, null, (Object)dicomSeries));
            MediaSeriesGroup studyGroup = this.getParent(dicomSeries, study);
            this.removeHierarchyNode(studyGroup, dicomSeries);
            LOGGER.info("Remove Series: {}", (Object)dicomSeries);
            dicomSeries.dispose();
        }
    }

    public void removeStudy(MediaSeriesGroup studyGroup) {
        if (studyGroup != null) {
            if (LoadRemoteDicom.currentTasks.size() > 0) {
                Collection<MediaSeriesGroup> seriesList = this.getChildren(studyGroup);
                for (MediaSeriesGroup group : seriesList) {
                    if (!(group instanceof DicomSeries)) continue;
                    LoadRemoteDicom.stopDownloading((DicomSeries)group);
                }
            }
            this.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Remove, (Object)this, null, (Object)studyGroup));
            MediaSeriesGroup patientGroup = this.getParent(studyGroup, patient);
            this.removeHierarchyNode(patientGroup, studyGroup);
            LOGGER.info("Remove Study: {}", (Object)studyGroup);
        }
    }

    public void removePatient(MediaSeriesGroup patientGroup) {
        if (patientGroup != null) {
            if (LoadRemoteDicom.currentTasks.size() > 0) {
                Collection<MediaSeriesGroup> studyList = this.getChildren(patientGroup);
                for (MediaSeriesGroup studyGroup : studyList) {
                    Collection<MediaSeriesGroup> seriesList = this.getChildren(studyGroup);
                    for (MediaSeriesGroup group : seriesList) {
                        if (!(group instanceof DicomSeries)) continue;
                        LoadRemoteDicom.stopDownloading((DicomSeries)group);
                    }
                }
            }
            this.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Remove, (Object)this, null, (Object)patientGroup));
            this.removeHierarchyNode(rootNode, patientGroup);
            LOGGER.info("Remove Patient: {}", (Object)patientGroup);
        }
    }

    public static boolean isSpecialModality(Series series) {
        String modality = series == null ? null : (String)series.getTagValue(TagW.Modality);
        return modality != null && ("PR".equals(modality) || "KO".equals(modality) || "SR".equals(modality));
    }

    private void splitSeries(DicomMediaIO dicomReader, Series original, MediaElement media) {
        String uid;
        MediaSeriesGroup group;
        MediaSeriesGroup study = this.getParent((MediaSeriesGroup)original, DicomModel.study);
        String seriesUID = (String)original.getTagValue(TagW.SeriesInstanceUID);
        int k = 1;
        while ((group = this.getHierarchyNode(study, uid = "#" + k + "." + seriesUID)) != null) {
            ++k;
        }
        uid = "#" + k + "." + seriesUID;
        Series s = dicomReader.buildSeries(uid);
        dicomReader.writeMetaData((MediaSeriesGroup)s);
        Object val = original.getTagValue(TagW.SplitSeriesNumber);
        if (val == null) {
            original.setTag(TagW.SplitSeriesNumber, (Object)1);
        }
        s.setTag(TagW.SplitSeriesNumber, (Object)(k + 1));
        s.setTag(TagW.ExplorerModel, (Object)this);
        this.addHierarchyNode(study, (MediaSeriesGroup)s);
        s.addMedia(media);
        LOGGER.info("Series splitting: {}", (Object)s);
    }

    private void replaceSeries(DicomMediaIO dicomReader, Series original, MediaElement media) {
        String uid;
        MediaSeriesGroup group;
        MediaSeriesGroup study = this.getParent((MediaSeriesGroup)original, DicomModel.study);
        String seriesUID = (String)original.getTagValue(TagW.SeriesInstanceUID);
        int k = 1;
        while ((group = this.getHierarchyNode(study, uid = "#" + k + "." + seriesUID)) != null) {
            ++k;
        }
        uid = "#" + k + "." + seriesUID;
        Series s = dicomReader.buildSeries(uid);
        dicomReader.writeMetaData((MediaSeriesGroup)s);
        Object val = original.getTagValue(TagW.SplitSeriesNumber);
        if (val == null) {
            original.setTag(TagW.SplitSeriesNumber, (Object)-1);
        }
        s.setTag(TagW.SplitSeriesNumber, (Object)k);
        s.setTag(TagW.ExplorerModel, (Object)this);
        this.addHierarchyNode(study, (MediaSeriesGroup)s);
        s.addMedia(media);
        LOGGER.info("Replace Series: {}", (Object)s);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean applySplittingRules(Series original, MediaElement media) {
        TagW[] rules;
        DicomSeries initialSeries;
        if (media == null) return false;
        if (!(media.getMediaReader() instanceof DicomMediaIO)) return false;
        DicomMediaIO dicomReader = (DicomMediaIO)media.getMediaReader();
        if (original instanceof DicomSeries) {
            if (media instanceof DicomVideoElement || media instanceof DicomEncapDocElement) {
                this.replaceSeries(dicomReader, original, media);
                return true;
            }
            initialSeries = (DicomSeries)original;
            int frames = dicomReader.getMediaElementNumber();
            if (frames < 1) {
                initialSeries.addMedia(media);
                return false;
            }
            Modality modality = Modality.getModality((String)((String)initialSeries.getTagValue(TagW.Modality)));
            TagW[] tagWArray = rules = frames > 1 ? this.multiframeSplittingRules : this.splittingRules.get(modality);
            if (rules == null) {
                rules = this.splittingRules.get(Modality.Default);
            }
            if (this.isSimilar(rules, initialSeries, media)) {
                initialSeries.addMedia(media);
                return false;
            }
        } else {
            if (!(original instanceof DicomVideoSeries)) {
                if (!(original instanceof DicomEncapDocSeries)) return false;
            }
            if (original.getMedias().size() > 0) {
                this.splitSeries(dicomReader, original, media);
                return true;
            }
            original.addMedia(media);
            return false;
        }
        MediaSeriesGroup study = this.getParent((MediaSeriesGroup)original, DicomModel.study);
        String seriesUID = (String)original.getTagValue(TagW.SeriesInstanceUID);
        int k = 1;
        while (true) {
            String uid;
            MediaSeriesGroup group;
            if (!((group = this.getHierarchyNode(study, uid = "#" + k + "." + seriesUID)) instanceof DicomSeries)) {
                this.splitSeries(dicomReader, (Series)initialSeries, media);
                return true;
            }
            if (this.isSimilar(rules, (DicomSeries)group, media)) {
                ((DicomSeries)group).addMedia(media);
                return false;
            }
            ++k;
        }
    }

    private boolean isSimilar(TagW[] rules, DicomSeries series, MediaElement media) {
        DicomImageElement firstMedia = (DicomImageElement)series.getMedia(0);
        if (firstMedia == null) {
            return true;
        }
        for (TagW tagElement : rules) {
            Object tag = media.getTagValue(tagElement);
            Object tag2 = firstMedia.getTagValue(tagElement);
            if (tag == null && tag2 == null || tag == null || tag.equals(tag2)) continue;
            return false;
        }
        return true;
    }

    public void get(String[] argv) throws IOException {
        String[] usage = new String[]{"Load DICOM files remotely or locally", "Usage: dicom:get [Options] SOURCE", "  -l --local\t\tOpen DICOMs from local disk", "  -p --portable       Open DICOMs from default directories at the same level of the executable", "  -i --iwado        Open DICOMs from an XML (GZIP, Base64) file containing UIDs", "  -w --wado\t\tOpen DICOMs from an XML (URL) file containing UIDs", "  -? --help\t\tshow help"};
        final Option opt = Options.compile((String[])usage).parse((Object[])argv);
        final List args = opt.args();
        if (opt.isSet("help") || args.isEmpty() && !opt.isSet("portable")) {
            opt.usage();
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                DicomModel.this.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Select, (Object)DicomModel.this, null, (Object)DicomModel.this));
                if (opt.isSet("local")) {
                    File[] files = new File[args.size()];
                    for (int i = 0; i < files.length; ++i) {
                        files[i] = new File((String)args.get(i));
                    }
                    loadingExecutor.execute(new LoadLocalDicom(files, true, DicomModel.this, false));
                } else if (opt.isSet("wado")) {
                    loadingExecutor.execute(new LoadRemoteDicom(args.toArray(new String[args.size()]), (DataExplorerModel)DicomModel.this));
                } else if (opt.isSet("iwado")) {
                    String[] xmlRef = args.toArray(new String[args.size()]);
                    File[] xmlFiles = new File[args.size()];
                    for (int i = 0; i < xmlFiles.length; ++i) {
                        try {
                            File tempFile = File.createTempFile("wado_", ".xml", AbstractProperties.APP_TEMP_DIR);
                            FileUtil.writeFile((InputStream)new ByteArrayInputStream(Base64.decode((String)xmlRef[i])), (OutputStream)new FileOutputStream(tempFile));
                            xmlFiles[i] = tempFile;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    loadingExecutor.execute(new LoadRemoteDicom(xmlFiles, (DataExplorerModel)DicomModel.this));
                } else if (opt.isSet("portable")) {
                    String prop = System.getProperty("weasis.portable.dicom.directory");
                    String baseDir = System.getProperty("weasis.portable.dir");
                    if (prop != null && baseDir != null) {
                        String[] dirs = prop.split(",");
                        File[] files = new File[dirs.length];
                        for (int i = 0; i < files.length; ++i) {
                            files[i] = new File(baseDir, dirs[i].trim().replaceAll("/", File.separator));
                        }
                        loadingExecutor.execute(new LoadLocalDicom(files, true, DicomModel.this, true));
                    }
                }
            }
        });
    }

    public void close(String[] argv) throws IOException {
        String[] usage = new String[]{"Remove DICOM files in Dicom Explorer", "Usage: dicom:close [patient | study | series] [ARGS]", "  -p --patient <args>\tClose patient, [arg] is patientUID (PatientID + Patient Birth Date, by default)", "  -y --study <args>\tClose study, [arg] is Study Instance UID", "  -s --series <args>\tClose series, [arg] is Series Instance UID", "  -? --help\t\tshow help"};
        final Option opt = Options.compile((String[])usage).parse((Object[])argv);
        final List args = opt.args();
        if (opt.isSet("help") || args.isEmpty()) {
            opt.usage();
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    block9: {
                        block7: {
                            DicomModel.this.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Select, (Object)DicomModel.this, null, (Object)DicomModel.this));
                            if (!opt.isSet("patient")) break block7;
                            for (String patientUID : args) {
                                MediaSeriesGroup patientGroup = null;
                                patientGroup = DicomModel.this.getHierarchyNode(TreeModel.rootNode, patientUID);
                                if (patientGroup == null) {
                                    System.out.println("Cannot find patient: " + patientUID);
                                    continue;
                                }
                                DicomModel.this.removePatient(patientGroup);
                            }
                            break block8;
                        }
                        if (!opt.isSet("study")) break block9;
                        block1: for (String studyUID : args) {
                            for (MediaSeriesGroup ptGroup : DicomModel.this.model.getSuccessors((Object)TreeModel.rootNode)) {
                                MediaSeriesGroup stGroup = DicomModel.this.getHierarchyNode(ptGroup, studyUID);
                                if (stGroup == null) continue;
                                DicomModel.this.removeStudy(stGroup);
                                continue block1;
                            }
                        }
                        break block8;
                    }
                    if (!opt.isSet("series")) break block8;
                    block3: for (String seriesUID : args) {
                        for (MediaSeriesGroup ptGroup : DicomModel.this.model.getSuccessors((Object)TreeModel.rootNode)) {
                            for (MediaSeriesGroup stGroup : DicomModel.this.model.getSuccessors((Object)ptGroup)) {
                                MediaSeriesGroup series = DicomModel.this.getHierarchyNode(stGroup, seriesUID);
                                if (!(series instanceof Series)) continue;
                                DicomModel.this.removeSeries(series);
                                continue block3;
                            }
                        }
                    }
                }
            }
        });
    }

    public TreeModelNode getTreeModelNodeForNewPlugin() {
        return patient;
    }

    static {
        modelStrucure.add(root);
        modelStrucure.add(patient);
        modelStrucure.add(study);
        modelStrucure.add(series);
        loadingExecutor = Executors.newSingleThreadExecutor();
    }
}

