/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.internal.mime.InvalidMagicMimeEntryException;
import org.weasis.core.api.internal.mime.MagicMimeEntry;
import org.weasis.core.api.util.FileUtil;

public class MimeInspector {
    public static final String UNKNOWN_MIME_TYPE = "application/x-unknown-mime-type";
    public static final Icon unknownIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/unknown.png"));
    public static final Icon textIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/text-x-generic.png"));
    public static final Icon htmlIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/text-html.png"));
    public static final Icon imageIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/image-x-generic.png"));
    public static final Icon audioIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/audio-x-generic.png"));
    public static final Icon videoIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/video-x-generic.png"));
    public static final Icon dicomIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/dicom.png"));
    public static final Icon dicomVideo = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/dicom-video.png"));
    public static final Icon pdfIcon = new ImageIcon(MimeInspector.class.getResource("/icon/22x22/pdf.png"));
    private static Properties mimeTypes;
    private static ArrayList<MagicMimeEntry> mMagicMimeEntries;

    public static String getMimeType(File file) throws IOException {
        if (file == null || !file.canRead()) {
            return null;
        }
        String fileName = file.getName();
        int lastPos = fileName.lastIndexOf(".");
        String extension = lastPos > 0 ? fileName.substring(lastPos + 1) : null;
        String mimeType = null;
        if (extension != null && extension.trim().length() > 0) {
            mimeType = mimeTypes.getProperty(extension.toLowerCase());
        }
        if (mimeType == null) {
            mimeType = MimeInspector.getMagicMimeType(file);
        }
        return mimeType;
    }

    private static void parse(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        ArrayList<String> sequence = new ArrayList<String>();
        String line = br.readLine();
        block0: while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = br.readLine();
                continue;
            }
            sequence.add(line);
            while (true) {
                if ((line = br.readLine()) == null) {
                    MimeInspector.addEntry(sequence);
                    sequence.clear();
                    continue block0;
                }
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) != '>') {
                    MimeInspector.addEntry(sequence);
                    sequence.clear();
                    continue block0;
                }
                sequence.add(line);
            }
        }
        if (!sequence.isEmpty()) {
            MimeInspector.addEntry(sequence);
        }
    }

    private static void addEntry(ArrayList<String> aStringArray) {
        try {
            MagicMimeEntry magicEntry = new MagicMimeEntry(aStringArray);
            mMagicMimeEntries.add(magicEntry);
        }
        catch (InvalidMagicMimeEntryException e) {
            e.printStackTrace();
        }
    }

    private static String getMagicMimeType(File f) throws IOException {
        if (f.isDirectory()) {
            return "application/directory";
        }
        int len = mMagicMimeEntries.size();
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        for (int i = 0; i < len; ++i) {
            MagicMimeEntry me = mMagicMimeEntries.get(i);
            String mtype = me.getMatch(raf);
            if (mtype == null) continue;
            return mtype;
        }
        return null;
    }

    public static String getMajorComponent(String mimeType) {
        if (mimeType == null) {
            return "";
        }
        int offset = mimeType.indexOf("/");
        if (offset == -1) {
            return mimeType;
        }
        return mimeType.substring(0, offset);
    }

    public static String getMinorComponent(String mimeType) {
        if (mimeType == null) {
            return "";
        }
        int offset = mimeType.indexOf("/");
        if (offset == -1) {
            return mimeType;
        }
        return mimeType.substring(offset + 1);
    }

    public static String getFileExtension(String fileName) {
        int lastPos;
        if (fileName == null || (lastPos = fileName.lastIndexOf(".")) < 0) {
            return null;
        }
        String extension = fileName.substring(lastPos + 1);
        if (extension.contains(File.separator)) {
            return null;
        }
        return extension;
    }

    public static String[] getExtensions(String mime) {
        ArrayList<String> list = new ArrayList<String>();
        if (mime != null) {
            String[] mimes = mime.split(",");
            Set<Map.Entry<Object, Object>> entries = mimeTypes.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (val == null) continue;
                for (String m : mimes) {
                    if (!val.equals(m) || list.contains(key)) continue;
                    list.add(key);
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        mMagicMimeEntries = new ArrayList();
        mimeTypes = new Properties();
        InputStream fileStream = null;
        try {
            fileStream = MimeInspector.class.getResourceAsStream("/mime-types.properties");
            mimeTypes.load(fileStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.safeClose(fileStream);
        }
        InputStream is = MimeInspector.class.getResourceAsStream("/magic.mime");
        if (is != null) {
            try {
                MimeInspector.parse(new InputStreamReader(is, "UTF8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                FileUtil.safeClose(is);
            }
        }
    }
}

