/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.service;

import java.io.File;
import java.util.Arrays;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.util.tracker.ServiceTracker;
import org.weasis.core.api.gui.util.AbstractProperties;

public class BundlePreferences {
    private ServiceTracker tracker;
    private File dataFolder;

    public synchronized void init(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.dataFolder = new File(AbstractProperties.WEASIS_PATH + File.separator + "data", context.getBundle().getSymbolicName());
        this.tracker = new ServiceTracker(context, PreferencesService.class.getName(), null);
        this.tracker.open();
    }

    public final synchronized void close() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public PreferencesService getPreferencesService() {
        return this.tracker == null ? null : (PreferencesService)this.tracker.getService();
    }

    public Preferences getDefaultPreferences() {
        String user = System.getProperty("weasis.user", null);
        if (user == null) {
            return this.getSystemPreferences();
        }
        return this.getUserPreferences(user);
    }

    public Preferences getSystemPreferences() {
        PreferencesService service = this.getPreferencesService();
        return service == null ? null : service.getSystemPreferences();
    }

    public Preferences getUserPreferences(String name) {
        PreferencesService service = this.getPreferencesService();
        return service == null ? null : service.getUserPreferences(name);
    }

    public File getDataFolder() {
        this.dataFolder.mkdirs();
        return this.dataFolder;
    }

    public static Preferences getDefaultPreferences(BundleContext context) {
        String user = System.getProperty("weasis.user", null);
        if (user == null) {
            return BundlePreferences.getSystemPreferences(context);
        }
        return BundlePreferences.getUserPreferences(context, user);
    }

    public static Preferences getSystemPreferences(BundleContext context) {
        ServiceTracker track = new ServiceTracker(context, PreferencesService.class.getName(), null);
        track.open();
        PreferencesService service = (PreferencesService)track.getService();
        Preferences pref = service == null ? null : service.getSystemPreferences();
        track.close();
        return pref;
    }

    public static Preferences getUserPreferences(BundleContext context, String name) {
        ServiceTracker track = new ServiceTracker(context, PreferencesService.class.getName(), null);
        track.open();
        PreferencesService service = (PreferencesService)track.getService();
        Preferences pref = service == null ? null : service.getUserPreferences(name);
        track.close();
        return pref;
    }

    public static void putStringPreferences(Preferences pref, String key, String value) {
        String val2;
        if (!(pref == null || key == null || value == null || (val2 = pref.get(key, null)) != null && value.equals(val2))) {
            pref.put(key, value);
        }
    }

    public static void putBooleanPreferences(Preferences pref, String key, boolean value) {
        if (pref != null && key != null) {
            Boolean result = null;
            String s = pref.get(key, null);
            if (s != null) {
                result = Boolean.valueOf(s);
            }
            if (result == null || result != value) {
                pref.putBoolean(key, value);
            }
        }
    }

    public static void putByteArrayPreferences(Preferences pref, String key, byte[] value) {
        byte[] val2;
        if (!(pref == null || key == null || value == null || (val2 = pref.getByteArray(key, null)) != null && Arrays.equals(value, val2))) {
            pref.putByteArray(key, value);
        }
    }

    public static void putDoublePreferences(Preferences pref, String key, double value) {
        if (pref != null && key != null) {
            Double result = null;
            String s = pref.get(key, null);
            if (s != null) {
                try {
                    result = Double.parseDouble(s);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (result == null || result != value) {
                pref.putDouble(key, value);
            }
        }
    }

    public static void putFloatPreferences(Preferences pref, String key, float value) {
        if (pref != null && key != null) {
            Float result = null;
            String s = pref.get(key, null);
            if (s != null) {
                try {
                    result = Float.valueOf(Float.parseFloat(s));
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (result == null || result.floatValue() != value) {
                pref.putFloat(key, value);
            }
        }
    }

    public static void putIntPreferences(Preferences pref, String key, int value) {
        if (pref != null && key != null) {
            Integer result = null;
            String s = pref.get(key, null);
            if (s != null) {
                try {
                    result = Integer.parseInt(s);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (result == null || result != value) {
                pref.putInt(key, value);
            }
        }
    }

    public static void putLongPreferences(Preferences pref, String key, long value) {
        if (pref != null && key != null) {
            Long result = null;
            String s = pref.get(key, null);
            if (s != null) {
                try {
                    result = Long.parseLong(s);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (result == null || result != value) {
                pref.putLong(key, value);
            }
        }
    }
}

