/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.image.GridBagLayoutModel;
import org.weasis.core.api.image.LayoutConstraints;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.SeriesViewerEvent;
import org.weasis.core.ui.editor.SeriesViewerListener;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.MouseActions;
import org.weasis.core.ui.editor.image.SynchView;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.model.AbstractLayerModel;

public abstract class ImageViewerPlugin<E extends ImageElement>
extends ViewerPlugin<E> {
    private static final Class view2dClass = DefaultView2d.class;
    public static final GridBagLayoutModel VIEWS_1x1 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.1"), "1x1"), 1, 1, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout1x1.png")));
    public static final GridBagLayoutModel VIEWS_2x1 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "2x1"), 2, 1, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout2x1.png")));
    public static final GridBagLayoutModel VIEWS_1x2 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "1x2"), 1, 2, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout1x2.png")));
    public static final GridBagLayoutModel VIEWS_2x2_f2 = new GridBagLayoutModel(ImageViewerPlugin.class.getResourceAsStream("/config/layoutModel2x2_f2.xml"), Messages.getString("ImageViewerPlugin.layout_c2x1"), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout2x2_f2.png")));
    public static final GridBagLayoutModel VIEWS_2_f1x2 = new GridBagLayoutModel(ImageViewerPlugin.class.getResourceAsStream("/config/layoutModel2_f1x2.xml"), Messages.getString("ImageViewerPlugin.layout_c1x2"), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout2_f1x2.png")));
    public static final GridBagLayoutModel VIEWS_2x2 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "2x2"), 2, 2, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout2x2.png")));
    public static final GridBagLayoutModel VIEWS_3x2 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "3x2"), 3, 2, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout3x2.png")));
    public static final GridBagLayoutModel VIEWS_3x3 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "3x3"), 3, 3, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout3x3.png")));
    public static final GridBagLayoutModel VIEWS_4x3 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "4x3"), 4, 3, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout4x3.png")));
    public static final GridBagLayoutModel VIEWS_4x4 = new GridBagLayoutModel(String.format(Messages.getString("ImageViewerPlugin.2"), "4x4"), 4, 4, view2dClass.getName(), (Icon)new ImageIcon(ImageViewerPlugin.class.getResource("/icon/22x22/layout4x4.png")));
    protected DefaultView2d<E> selectedImagePane = null;
    protected final ArrayList<DefaultView2d<E>> view2ds;
    protected final ArrayList<JComponent> components;
    protected SynchView synchView = SynchView.NONE;
    protected final ImageViewerEventManager<E> eventManager;
    protected final JPanel grid;
    protected GridBagLayoutModel layoutModel;

    public ImageViewerPlugin(ImageViewerEventManager<E> eventManager, String PluginName) {
        this(eventManager, VIEWS_1x1, PluginName, null, null);
    }

    public ImageViewerPlugin(ImageViewerEventManager<E> eventManager, GridBagLayoutModel layoutModel, String pluginName, Icon icon, String tooltips) {
        super(pluginName, icon, tooltips);
        if (eventManager == null) {
            throw new IllegalArgumentException("EventManager cannot be null");
        }
        this.eventManager = eventManager;
        this.view2ds = new ArrayList();
        this.components = new ArrayList();
        this.grid = new JPanel();
        this.grid.setUI(new PanelUI(){});
        this.grid.setBackground(Color.BLACK);
        this.grid.setFocusCycleRoot(true);
        this.grid.setLayout(new GridBagLayout());
        this.add((Component)this.grid, "Center");
        this.setLayoutModel(layoutModel);
    }

    public abstract boolean isViewType(Class var1, String var2);

    public abstract int getViewTypeNumber(Class var1);

    public abstract DefaultView2d<E> createDefaultView(String var1);

    public abstract JComponent createUIcomponent(String var1);

    public DefaultView2d<E> getSelectedImagePane() {
        return this.selectedImagePane;
    }

    public GridBagLayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    @Override
    public void addSeries(MediaSeries<E> sequence) {
        if (sequence != null) {
            if (SynchView.Mode.Tile.equals((Object)this.synchView.getMode())) {
                this.selectedImagePane.setSeries(sequence, -1);
                this.updateSynchView();
                return;
            }
            DefaultView2d<E> viewPane = this.getSelectedImagePane();
            if (viewPane != null) {
                viewPane.setSeries(sequence);
                viewPane.repaint();
                this.setSelectedImagePane(this.getNextSelectedImagePane());
            }
        }
    }

    @Override
    public void removeSeries(MediaSeries<E> series) {
        if (series != null) {
            for (int i = 0; i < this.view2ds.size(); ++i) {
                DefaultView2d v = this.view2ds.get(i);
                if (v.getSeries() != series) continue;
                v.setSeries(null, -1);
            }
        }
    }

    @Override
    public List<MediaSeries<E>> getOpenSeries() {
        ArrayList<MediaSeries<MediaSeries<E>>> list = new ArrayList<MediaSeries<MediaSeries<E>>>();
        for (DefaultView2d<E> v : this.view2ds) {
            MediaSeries<E> s = v.getSeries();
            if (s == null) continue;
            list.add(s);
        }
        return list;
    }

    public void changeLayoutModel(GridBagLayoutModel layoutModel) {
        ActionState layout = this.eventManager.getAction(ActionW.LAYOUT);
        if (layout instanceof ComboItemListener) {
            ((ComboItemListener)layout).setSelectedItem((Object)layoutModel);
        }
    }

    protected void setLayoutModel(GridBagLayoutModel layoutModel) {
        this.layoutModel = layoutModel == null ? VIEWS_1x1 : layoutModel;
        this.grid.removeAll();
        ArrayList<DefaultView2d<E>> oldViews = new ArrayList<DefaultView2d<E>>();
        for (DefaultView2d<E> v : this.view2ds) {
            if (v.getSeries() != null && v.getImage() != null) {
                oldViews.add(v);
                continue;
            }
            v.dispose();
        }
        this.view2ds.clear();
        int nbview = this.getViewTypeNumber(view2dClass);
        if (oldViews.size() > nbview) {
            for (int i = oldViews.size() - 1; i >= nbview; --i) {
                ((DefaultView2d)oldViews.remove(i)).dispose();
            }
        }
        for (JComponent c : this.components) {
            if (!(c instanceof SeriesViewerListener)) continue;
            this.eventManager.removeSeriesViewerListener((SeriesViewerListener)((Object)c));
        }
        this.components.clear();
        LinkedHashMap elements = this.layoutModel.getConstraints();
        for (LayoutConstraints e : elements.keySet()) {
            boolean typeView2d = this.isViewType(view2dClass, e.getType());
            if (typeView2d) {
                DefaultView2d<E> oldView;
                if (oldViews.size() > 0) {
                    oldView = (DefaultView2d<E>)oldViews.remove(0);
                } else {
                    oldView = this.createDefaultView(e.getType());
                    oldView.registerDefaultListeners();
                }
                this.view2ds.add(oldView);
                elements.put(e, oldView);
                this.grid.add(oldView, e);
                if (oldView.getSeries() == null) continue;
                oldView.getSeries().setOpen(true);
                continue;
            }
            JComponent component = this.createUIcomponent(e.getType());
            if (component == null) continue;
            component.setOpaque(true);
            this.components.add(component);
            elements.put(e, component);
            this.grid.add((Component)component, e);
        }
        this.grid.revalidate();
        this.selectedImagePane = this.view2ds.get(0);
        MouseActions mouseActions = this.eventManager.getMouseActions();
        for (int i = 0; i < this.view2ds.size(); ++i) {
            DefaultView2d<E> v = this.view2ds.get(i);
            if (SynchView.Mode.Tile.equals(this.synchView)) {
                v.setTileOffset(i);
                v.setSeries(this.selectedImagePane.getSeries(), -1);
            }
            v.enableMouseAndKeyListener(mouseActions);
        }
        Graphic graphic = null;
        ActionState action = this.eventManager.getAction(ActionW.DRAW_MEASURE);
        if (action instanceof ComboItemListener) {
            graphic = (Graphic)((ComboItemListener)action).getSelectedItem();
        }
        this.setDrawActions(graphic);
        this.selectedImagePane.setSelected(true);
        this.eventManager.updateComponentsListener(this.selectedImagePane);
        if (this.selectedImagePane.getSeries() instanceof Series) {
            Series series = (Series)this.selectedImagePane.getSeries();
            this.eventManager.fireSeriesViewerListeners(new SeriesViewerEvent(this, series, series.getMedia(this.selectedImagePane.getFrameIndex()), SeriesViewerEvent.EVENT.LAYOUT));
        }
    }

    public void setSelectedImagePaneFromFocus(DefaultView2d<E> defaultView2d) {
        this.setSelectedImagePane(defaultView2d);
    }

    public void setSelectedImagePane(DefaultView2d<E> defaultView2d) {
        if (this.selectedImagePane.getSeries() != null) {
            this.selectedImagePane.getSeries().setSelected(false, 0);
        }
        if (defaultView2d != null && defaultView2d.getSeries() != null) {
            defaultView2d.getSeries().setSelected(true, defaultView2d.getFrameIndex());
        }
        if (this.selectedImagePane != defaultView2d && defaultView2d != null) {
            this.selectedImagePane.setSelected(false);
            defaultView2d.setSelected(true);
            this.selectedImagePane = defaultView2d;
            this.eventManager.updateComponentsListener(defaultView2d);
        }
        if (defaultView2d != null && defaultView2d.getSeries() instanceof Series) {
            Series series = (Series)this.selectedImagePane.getSeries();
            this.eventManager.fireSeriesViewerListeners(new SeriesViewerEvent(this, series, series.getMedia(defaultView2d.getFrameIndex()), SeriesViewerEvent.EVENT.SELECT));
        }
    }

    public void maximizedSelectedImagePane(DefaultView2d<E> defaultView2d) {
        LinkedHashMap elements = this.layoutModel.getConstraints();
        if (elements.size() > 1) {
            for (DefaultView2d<E> v : this.view2ds) {
                v.removeFocusListener(v);
            }
            int nb = this.grid.getComponentCount();
            this.grid.removeAll();
            if (nb > 1) {
                for (Map.Entry entry : elements.entrySet()) {
                    if (!((JComponent)entry.getValue()).equals(defaultView2d)) continue;
                    GridBagConstraints c = (GridBagConstraints)((LayoutConstraints)entry.getKey()).clone();
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    this.grid.add(defaultView2d, c);
                    defaultView2d.addFocusListener(defaultView2d);
                    break;
                }
            } else {
                for (Map.Entry entry : elements.entrySet()) {
                    this.grid.add((Component)entry.getValue(), entry.getKey());
                }
                for (DefaultView2d<E> v : this.view2ds) {
                    v.addFocusListener(v);
                }
            }
            this.grid.revalidate();
            this.grid.repaint();
            defaultView2d.requestFocusInWindow();
        }
    }

    public synchronized void setDrawActions(Graphic graphic) {
        for (DefaultView2d<E> v : this.getImagePanels()) {
            AbstractLayerModel model = v.getLayerModel();
            if (model == null) continue;
            model.setCreateGraphic(graphic);
        }
    }

    public E getImage(int i) {
        if (i >= 0 && i < this.view2ds.size()) {
            return this.view2ds.get(i).getImage();
        }
        return null;
    }

    public ArrayList<DefaultView2d<E>> getImagePanels() {
        return new ArrayList<DefaultView2d<E>>(this.view2ds);
    }

    public DefaultView2d<E> getNextSelectedImagePane() {
        for (int i = 0; i < this.view2ds.size() - 1; ++i) {
            if (this.view2ds.get(i) != this.selectedImagePane) continue;
            return this.view2ds.get(i + 1);
        }
        return this.selectedImagePane;
    }

    public boolean isContainingView(DefaultView2d<E> view2DPane) {
        for (DefaultView2d<E> v : this.view2ds) {
            if (v != view2DPane) continue;
            return true;
        }
        return false;
    }

    public SynchView getSynchView() {
        return this.synchView;
    }

    public void setSynchView(SynchView synchView) {
        this.synchView = synchView;
        this.updateSynchView();
        this.eventManager.updateAllListeners(this, synchView);
    }

    protected void updateSynchView() {
        block7: {
            block6: {
                if (!SynchView.Mode.Tile.equals((Object)this.synchView.getMode())) break block6;
                MediaSeries<E> series = null;
                if (this.selectedImagePane.getSeries() != null) {
                    series = this.selectedImagePane.getSeries();
                } else {
                    for (DefaultView2d<E> v : this.view2ds) {
                        if (v.getSeries() == null) continue;
                        series = v.getSeries();
                        break;
                    }
                }
                if (series == null) break block7;
                int limit = series.getMedias().size();
                for (int i = 0; i < this.view2ds.size(); ++i) {
                    DefaultView2d v = this.view2ds.get(i);
                    if (i < limit) {
                        v.setTileOffset(i);
                        v.setSeries(series, -1);
                        continue;
                    }
                    v.setSeries(null, -1);
                }
                break block7;
            }
            for (DefaultView2d<E> v : this.view2ds) {
                v.setTileOffset(0);
            }
        }
    }

    public synchronized void setMouseActions(MouseActions mouseActions) {
        if (mouseActions == null) {
            for (DefaultView2d<E> v : this.view2ds) {
                v.disableMouseAndKeyListener();
                v.iniDefaultMouseListener();
            }
        } else {
            for (DefaultView2d<E> v : this.view2ds) {
                v.enableMouseAndKeyListener(mouseActions);
            }
        }
    }

    public GridBagLayoutModel getBestDefaultViewLayout(int size) {
        if (size <= 1) {
            return VIEWS_1x1;
        }
        ActionState layout = this.eventManager.getAction(ActionW.LAYOUT);
        if (layout instanceof ComboItemListener) {
            Object[] list;
            for (Object m : list = ((ComboItemListener)layout).getAllItem()) {
                if (!(m instanceof GridBagLayoutModel) || this.getViewTypeNumber(view2dClass) < size) continue;
                return (GridBagLayoutModel)m;
            }
        }
        return VIEWS_4x4;
    }
}

