/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import javax.swing.UIManager;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.MouseActionAdapter;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.image.ImageOperationAction;
import org.weasis.core.api.image.OperationsManager;
import org.weasis.core.api.image.RotationOperation;
import org.weasis.core.api.image.ZoomOperation;
import org.weasis.core.api.image.util.ImageLayer;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.PopUpMenuOnZoom;
import org.weasis.core.ui.graphic.ImageLayerChangeListener;
import org.weasis.core.ui.graphic.RenderedImageLayer;
import org.weasis.core.ui.graphic.model.GraphicsPane;
import org.weasis.core.ui.graphic.model.MainLayerModel;
import org.weasis.core.ui.util.ZoomSetting;

public class ZoomWin<E extends ImageElement>
extends GraphicsPane
implements ImageOperation,
ImageLayerChangeListener {
    private final DefaultView2d<E> view2d;
    private RectangularShape shape;
    private int borderOffset = 2;
    private Color lineColor;
    private Color backgroundColor;
    private Stroke stroke;
    public static final String SYNCH_CMD = "synchronize";
    public static final String FREEZE_CMD = "freeze";
    private PopUpMenuOnZoom popup = null;
    private final RenderedImageLayer<E> imageLayer;
    private final MouseHandler mouseHandler;
    private OperationsManager freezeOperations;
    private SYNCH_TYPE type = SYNCH_TYPE.None;
    private final HashMap<String, Object> freezeActionsInView = new HashMap();

    public ZoomWin(DefaultView2d<E> view2d) {
        super(view2d.getLayerModel(), null);
        this.view2d = view2d;
        this.setOpaque(false);
        ImageViewerEventManager<E> manager = view2d.getEventManager();
        this.imageLayer = new RenderedImageLayer(new OperationsManager((ImageOperation)this), false);
        OperationsManager operations = this.imageLayer.getOperationsManager();
        operations.addImageOperationAction((ImageOperationAction)new ZoomOperation());
        operations.addImageOperationAction((ImageOperationAction)new RotationOperation());
        ActionState zoomAction = manager.getAction(ActionW.LENSZOOM);
        if (zoomAction instanceof SliderChangeListener) {
            this.actionsInView.put(ActionW.ZOOM.cmd(), manager.sliderValueToViewScale(((SliderChangeListener)zoomAction).getValue()));
        }
        this.popup = new PopUpMenuOnZoom(this);
        this.popup.setInvoker(this);
        this.setCursor(MainLayerModel.MOVE_CURSOR);
        ZoomSetting z = manager.getZoomSetting();
        this.actionsInView.put(ActionW.ROTATION.cmd(), view2d.getActionValue(ActionW.ROTATION.cmd()));
        this.actionsInView.put(SYNCH_CMD, z.isLensSynchronize());
        this.actionsInView.put(ActionW.DRAW.cmd(), z.isLensShowDrawings());
        this.actionsInView.put(FREEZE_CMD, null);
        this.actionsInView.put("zoomInterpolation", z.getInterpolation());
        Color bckColor = UIManager.getColor("Panel.background");
        this.setLensDecoration(z.getLensLineWidth(), z.getLensLineColor(), bckColor, z.isLensRound());
        this.setSize(z.getLensWidth(), z.getLensHeight());
        this.setLocation(-1, -1);
        this.imageLayer.addLayerChangeListener(this);
        this.mouseHandler = new MouseHandler();
    }

    public void setActionInView(String action, Object value) {
        if (action != null) {
            this.actionsInView.put(action, value);
        }
    }

    private void refreshZoomWin() {
        this.imageLayer.setImage(this.view2d.getImage());
        this.getViewModel().setModelArea(this.view2d.getViewModel().getModelArea());
        Point loc = this.getLocation();
        if (loc.x == -1 && loc.y == -1) {
            this.centerZoomWin();
            return;
        }
        Rectangle rect = this.view2d.getBounds();
        rect.x = 0;
        rect.y = 0;
        Rectangle2D r = rect.createIntersection(this.getBounds());
        if (r.getWidth() < 25.0 || r.getHeight() < 25.0) {
            this.centerZoomWin();
        }
    }

    public void showLens(boolean val) {
        if (val) {
            this.refreshZoomWin();
            this.enableMouseListener();
            this.setVisible(true);
        } else {
            this.setVisible(false);
            this.disableMouseAndKeyListener();
        }
    }

    public void centerZoomWin() {
        int magPosx = this.view2d.getWidth() / 2 - this.getWidth() / 2;
        int magPosy = this.view2d.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(magPosx, magPosy);
    }

    public void hideZoom() {
        ActionState lens = this.view2d.getEventManager().getAction(ActionW.LENS);
        if (lens instanceof ToggleButtonListener) {
            ((ToggleButtonListener)lens).setSelected(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            this.draw((Graphics2D)g);
        }
    }

    protected void draw(Graphics2D g2d) {
        Stroke oldStroke = g2d.getStroke();
        Paint oldColor = g2d.getPaint();
        Shape oldClip = g2d.getClip();
        g2d.clip(this.shape);
        g2d.setBackground(this.backgroundColor);
        this.drawBackground(g2d);
        double viewScale = this.getViewModel().getViewScale();
        double offsetX = this.getViewModel().getModelOffsetX() * viewScale;
        double offsetY = this.getViewModel().getModelOffsetY() * viewScale;
        g2d.translate(-offsetX, -offsetY);
        g2d.setFont(this.getFont());
        this.imageLayer.drawImage(g2d);
        this.drawLayers(g2d, this.affineTransform, this.inverseTransform);
        g2d.translate(offsetX, offsetY);
        g2d.setClip(oldClip);
        g2d.setStroke(this.stroke);
        g2d.setPaint(this.lineColor);
        Rectangle bound = this.getBounds();
        g2d.drawRect(bound.width - 12 - this.borderOffset, bound.height - 12 - this.borderOffset, 12, 12);
        g2d.draw(this.shape);
        g2d.setPaint(oldColor);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void drawLayers(Graphics2D g2d, AffineTransform transform, AffineTransform inverseTransform) {
        if (((Boolean)this.actionsInView.get(ActionW.DRAW.cmd())).booleanValue()) {
            this.getLayerModel().draw(g2d, transform, inverseTransform);
        }
    }

    private void drawBackground(Graphics2D g2d) {
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void updateAffineTransform() {
        double viewScale = this.getViewModel().getViewScale();
        Boolean flip = (Boolean)this.view2d.getActionValue(ActionW.FLIP.cmd());
        if (flip != null && flip.booleanValue()) {
            this.affineTransform.setToScale(-viewScale, viewScale);
            this.affineTransform.translate(-this.getViewModel().getModelArea().getWidth(), 0.0);
        } else {
            this.affineTransform.setToScale(viewScale, viewScale);
        }
        Integer rotationAngle = (Integer)this.view2d.getActionValue(ActionW.ROTATION.cmd());
        if (rotationAngle != null && rotationAngle > 0) {
            if (flip != null && flip.booleanValue()) {
                rotationAngle = 360 - rotationAngle;
            }
            Rectangle2D imageCanvas = this.getViewModel().getModelArea();
            this.affineTransform.rotate((double)rotationAngle.intValue() * Math.PI / 180.0, imageCanvas.getWidth() / 2.0, imageCanvas.getHeight() / 2.0);
        }
        try {
            this.inverseTransform.setTransform(this.affineTransform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    public void setLensDecoration(int lineWidth, Color lineColor, Color backgroundColor, boolean roundShape) {
        this.borderOffset = lineWidth / 2 + 1;
        this.stroke = new BasicStroke(lineWidth);
        this.lineColor = lineColor;
        this.backgroundColor = backgroundColor;
        this.setBackground(backgroundColor);
        this.upateShape(roundShape);
    }

    @Override
    public void setSize(int width, int height) {
        this.shape.setFrame(this.borderOffset, this.borderOffset, width - this.borderOffset, height - this.borderOffset);
        super.setSize(width + this.borderOffset, height + this.borderOffset);
    }

    private void upateShape(boolean round) {
        this.shape = round ? new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()) : new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public double getCenterX() {
        return this.view2d.viewToModelX((double)this.getX() + (double)(this.getWidth() - 1) * 0.5);
    }

    public double getCenterY() {
        return this.view2d.viewToModelY((double)this.getY() + (double)(this.getHeight() - 1) * 0.5);
    }

    @Override
    public void zoom(double viewScale) {
        this.actionsInView.put(ActionW.ZOOM.cmd(), viewScale);
        super.zoom(this.getCenterX(), this.getCenterY(), Math.abs(viewScale));
        this.imageLayer.updateImageOperation(ZoomOperation.name);
        this.updateAffineTransform();
    }

    public void updateZoom() {
        double zoomFactor = (Boolean)this.actionsInView.get(SYNCH_CMD) != false ? this.view2d.getViewModel().getViewScale() : ((Double)this.actionsInView.get(ActionW.ZOOM.cmd())).doubleValue();
        this.zoom(zoomFactor);
    }

    public E getImage() {
        return this.imageLayer.getSourceImage();
    }

    public RenderedImage getSourceImage() {
        RenderedImage img = (RenderedImage)this.actionsInView.get(FREEZE_CMD);
        if (img == null) {
            return this.view2d.getImageLayer().getOperationsManager().getSourceImage(ZoomOperation.name);
        }
        return img;
    }

    public void setFreezeImage(RenderedImage image, SYNCH_TYPE type) {
        this.type = type;
        this.actionsInView.put(FREEZE_CMD, image);
        if (image == null) {
            this.freezeActionsInView.clear();
            this.freezeOperations = null;
            type = SYNCH_TYPE.None;
        }
        this.imageLayer.updateAllImageOperations();
    }

    RenderedImage freezeParentImage() {
        OperationsManager pManager = this.view2d.getImageLayer().getOperationsManager();
        this.freezeActionsInView.clear();
        this.view2d.copyActionWState(this.freezeActionsInView);
        E image = this.view2d.getImage();
        this.freezeOperations = new OperationsManager(new ImageOperation((ImageElement)image){
            final /* synthetic */ ImageElement val$image;
            {
                this.val$image = imageElement;
            }

            public RenderedImage getSourceImage() {
                ImageElement image = this.getImage();
                if (image == null) {
                    return null;
                }
                return image.getImage();
            }

            public ImageElement getImage() {
                return this.val$image;
            }

            public Object getActionValue(String action) {
                if (action == null) {
                    return null;
                }
                return ZoomWin.this.freezeActionsInView.get(action);
            }
        });
        for (ImageOperationAction op : pManager.getOperations()) {
            try {
                if (ZoomOperation.name.equals(op.getOperationName())) continue;
                ImageOperationAction operation = (ImageOperationAction)op.clone();
                this.freezeOperations.addImageOperationAction(operation);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return this.freezeOperations.updateAllOperations();
    }

    RenderedImage freezeParentParameters() {
        OperationsManager pManager = this.view2d.getImageLayer().getOperationsManager();
        this.freezeActionsInView.clear();
        this.view2d.copyActionWState(this.freezeActionsInView);
        this.freezeOperations = new OperationsManager(new ImageOperation(){

            public RenderedImage getSourceImage() {
                Object image = ZoomWin.this.view2d.getImage();
                if (image == null) {
                    return null;
                }
                return image.getImage();
            }

            public ImageElement getImage() {
                return ZoomWin.this.view2d.getImage();
            }

            public Object getActionValue(String action) {
                if (action == null) {
                    return null;
                }
                return ZoomWin.this.freezeActionsInView.get(action);
            }
        });
        for (ImageOperationAction op : pManager.getOperations()) {
            try {
                if (ZoomOperation.name.equals(op.getOperationName())) continue;
                ImageOperationAction operation = (ImageOperationAction)op.clone();
                this.freezeOperations.addImageOperationAction(operation);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return this.freezeOperations.updateAllOperations();
    }

    public void disableMouseAndKeyListener() {
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseHandler);
        this.removeMouseWheelListener((MouseWheelListener)((MouseActionAdapter)this.view2d.getEventManager().getAction(ActionW.LENSZOOM)));
    }

    public void enableMouseListener() {
        this.disableMouseAndKeyListener();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.addMouseWheelListener((MouseWheelListener)((MouseActionAdapter)this.view2d.getEventManager().getAction(ActionW.LENSZOOM)));
    }

    public DefaultView2d<E> getView2d() {
        return this.view2d;
    }

    public void handleLayerChanged(ImageLayer layer) {
        this.repaint();
    }

    public void setCommandFromParentView(String command, Object value) {
        if (ActionW.SCROLL_SERIES.cmd().equals(command)) {
            if (this.freezeOperations == null) {
                this.refreshZoomWin();
            } else if (SYNCH_TYPE.ParentParameters.equals((Object)this.type)) {
                this.refreshZoomWin();
                this.setFreezeImage(this.freezeOperations.updateAllOperations(), this.type);
            }
        } else if (this.freezeOperations != null && (ActionW.ROTATION.cmd().equals(command) || ActionW.FLIP.cmd().equals(command))) {
            this.freezeActionsInView.put(command, value);
            this.setFreezeImage(this.freezeOperations.updateAllOperations(), this.type);
        } else if (command.equals(ActionW.ROTATION.cmd())) {
            this.actionsInView.put(ActionW.ROTATION.cmd(), this.view2d.getActionValue(ActionW.ROTATION.cmd()));
            this.refreshZoomWin();
        } else if (command.equals(ActionW.PROGRESSION.cmd())) {
            this.refreshZoomWin();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private Point pickPoint = null;
        private int pickWidth;
        private int pickHeight;
        private int cursor;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ImageViewerPlugin pane = ZoomWin.this.view2d.getEventManager().getSelectedView2dContainer();
            if (pane == null) {
                return;
            }
            if (pane.isContainingView(ZoomWin.this.view2d)) {
                pane.setSelectedImagePane(ZoomWin.this.view2d);
            }
            if (e.isPopupTrigger()) {
                ZoomWin.this.popup.enableMenuItem();
                ZoomWin.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            this.pickPoint = e.getPoint();
            this.pickWidth = ZoomWin.this.getWidth();
            this.pickHeight = ZoomWin.this.getHeight();
            this.cursor = this.getCursor(e);
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            ImageViewerEventManager manager;
            ActionState zoomAction;
            this.pickPoint = null;
            if (mouseevent.isPopupTrigger()) {
                ZoomWin.this.popup.enableMenuItem();
                ZoomWin.this.popup.show(mouseevent.getComponent(), mouseevent.getX(), mouseevent.getY());
            } else if (mouseevent.getClickCount() == 2 && (zoomAction = (manager = ZoomWin.this.view2d.getEventManager()).getAction(ActionW.LENSZOOM)) instanceof SliderChangeListener) {
                ((SliderChangeListener)zoomAction).setValue(manager.viewScaleToSliderValue(ZoomWin.this.view2d.getViewModel().getViewScale()));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int mods = e.getModifiers();
            if (this.pickPoint != null && (mods & 0x10) != 0) {
                Point p = e.getPoint();
                int dx = p.x - this.pickPoint.x;
                int dy = p.y - this.pickPoint.y;
                switch (this.cursor) {
                    case 5: {
                        int nw = this.pickWidth + dx;
                        int nh = this.pickHeight + dy;
                        int n = nw < 50 ? 50 : (nw = nw > 500 ? 500 : nw);
                        nh = nh < 50 ? 50 : (nh > 500 ? 500 : nh);
                        ZoomWin.this.setSize(nw, nh);
                        ZoomWin.this.zoom(ZoomWin.this.getCenterX(), ZoomWin.this.getCenterY(), ZoomWin.this.getViewModel().getViewScale());
                        break;
                    }
                    default: {
                        ZoomWin.this.setLocation(ZoomWin.this.getX() + dx, ZoomWin.this.getY() + dy);
                        ZoomWin.this.zoom(ZoomWin.this.getCenterX(), ZoomWin.this.getCenterY(), ZoomWin.this.getViewModel().getViewScale());
                    }
                }
                ZoomWin.this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            ZoomWin.this.setCursor(Cursor.getPredefinedCursor(this.getCursor(me)));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ZoomWin.this.setCursor(Cursor.getDefaultCursor());
        }

        public int getCursor(MouseEvent me) {
            Component c = me.getComponent();
            int w = c.getWidth();
            int h = c.getHeight();
            Rectangle rect = new Rectangle(w - 12 - ZoomWin.this.borderOffset, h - 12 - ZoomWin.this.borderOffset, 12, 12);
            if (rect.contains(me.getPoint())) {
                return 5;
            }
            return 13;
        }
    }

    public static enum SYNCH_TYPE {
        None,
        ParentImage,
        ParentParameters;

    }
}

