/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.util.MouseEventDouble;

public class PolygonGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(PolygonGraphic.class.getResource("/icon/22x22/draw-polyline.png"));

    public PolygonGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(-1, paintColor, lineThickness, labelVisible);
    }

    public PolygonGraphic(List<Point2D> handlePointList, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        super(handlePointList, -1, paintColor, lineThickness, labelVisible, filled);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("PolygonGraphic.title");
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void paintHandles(Graphics2D g2d, AffineTransform transform) {
        if (this.resizingOrMoving) {
            this.resizingOrMoving = false;
            super.paintHandles(g2d, transform);
            this.resizingOrMoving = true;
        } else {
            super.paintHandles(g2d, transform);
        }
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        GeneralPath newShape = null;
        if (this.handlePointList.size() > 1) {
            GeneralPath generalpath = new GeneralPath();
            Point2D p = (Point2D)this.handlePointList.get(0);
            generalpath.moveTo(p.getX(), p.getY());
            for (int i = 1; i < this.handlePointList.size(); ++i) {
                p = (Point2D)this.handlePointList.get(i);
                generalpath.lineTo(p.getX(), p.getY());
            }
            generalpath.closePath();
            newShape = generalpath;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        return null;
    }
}

