/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.weasis.core.api.util.FontTools;
import org.weasis.core.ui.graphic.DragLayer;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.graphic.model.Tools;

public class TempLayer
extends DragLayer {
    private static final long serialVersionUID = 3600434231972858782L;
    private transient Color color = null;
    private transient Font font = FontTools.getFont10();
    private transient ArrayList<Point> points = null;

    public TempLayer(LayerModel canvas1) {
        super(canvas1, Tools.TEMPDRAGLAYER.getId());
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public void setPoints(ArrayList<Point> points) {
        this.points = points;
    }

    @Override
    public void paint(Graphics2D g2, AffineTransform transform, AffineTransform inverseTransform, Rectangle2D bound) {
        int i;
        if (this.graphics != null) {
            for (i = 0; i < this.graphics.size(); ++i) {
                Graphic graphic = (Graphic)this.graphics.get(i);
                if (bound != null && !bound.intersects(graphic.getRepaintBounds(transform))) continue;
                graphic.paint(g2, transform);
            }
        }
        if (this.points != null) {
            g2.setPaint(Color.blue);
            for (i = 0; i < this.points.size(); ++i) {
                Point p = this.points.get(i);
                g2.drawRect(p.x - 1, p.y - 1, 3, 3);
            }
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

