/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class ThreePointsCircleGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(ThreePointsCircleGraphic.class.getResource("/icon/22x22/draw-circle.png"));
    public static final Measurement CenterX = new Measurement("Center X", true, true, false);
    public static final Measurement CenterY = new Measurement("Center Y", true, true, false);
    public static final Measurement Radius = new Measurement("Radius", true, true, false);
    public static final Measurement Diameter = new Measurement("Diameter", true, true, true);
    public static final Measurement Area = new Measurement("Area", true, true, true);
    public static final Measurement Perimeter = new Measurement("Perimeter", true, true, false);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true, true, false);

    public ThreePointsCircleGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(3, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Three Points Circle";
    }

    @Override
    public void paintHandles(Graphics2D g2d, AffineTransform transform) {
        if (this.resizingOrMoving) {
            this.resizingOrMoving = false;
            super.paintHandles(g2d, transform);
            this.resizingOrMoving = true;
        } else {
            super.paintHandles(g2d, transform);
        }
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        double radius;
        Point2D centerPt;
        Ellipse2D.Double newShape = null;
        if (this.handlePointList.size() > 1 && (centerPt = GeomUtil.getCircleCenter((List)this.handlePointList)) != null && (radius = centerPt.distance((Point2D)this.handlePointList.get(0))) < 5000.0) {
            Rectangle2D.Double rectangle = new Rectangle2D.Double();
            rectangle.setFrameFromCenter(centerPt.getX(), centerPt.getY(), centerPt.getX() - radius, centerPt.getY() - radius);
            newShape = new Ellipse2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() > 1 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Point2D centerPt = GeomUtil.getCircleCenter((List)this.handlePointList);
            if (centerPt == null) {
                return null;
            }
            double radius = centerPt.distance((Point2D)this.handlePointList.get(0));
            double ratio = adapter.getCalibRatio();
            if (CenterX.isComputed() && (!drawOnLabel || CenterX.isGraphicLabel())) {
                val = releaseEvent || CenterX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(centerPt.getX())) : null;
                measVal.add(new MeasureItem(CenterX, val, adapter.getUnit()));
            }
            if (CenterY.isComputed() && (!drawOnLabel || CenterY.isGraphicLabel())) {
                val = releaseEvent || CenterY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(centerPt.getY())) : null;
                measVal.add(new MeasureItem(CenterY, val, adapter.getUnit()));
            }
            if (Radius.isComputed() && (!drawOnLabel || Radius.isGraphicLabel())) {
                val = releaseEvent || Radius.isQuickComputing() ? Double.valueOf(ratio * radius) : null;
                measVal.add(new MeasureItem(Radius, val, adapter.getUnit()));
            }
            if (Diameter.isComputed() && (!drawOnLabel || Diameter.isGraphicLabel())) {
                val = releaseEvent || Diameter.isQuickComputing() ? Double.valueOf(ratio * radius * 2.0) : null;
                measVal.add(new MeasureItem(Diameter, val, adapter.getUnit()));
            }
            if (Area.isComputed() && (!drawOnLabel || Area.isGraphicLabel())) {
                val = releaseEvent || Area.isQuickComputing() ? Double.valueOf(Math.PI * radius * radius * ratio * ratio) : null;
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(Area, val, unit));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }
}

