/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.Messages;

public enum ResetTools {
    All(Messages.getString("ResetTools.all")),
    WindowLevel(Messages.getString("ResetTools.wl")),
    Zoom(Messages.getString("ViewerPrefView.zoom")),
    Rotation(Messages.getString("ResetTools.rotation")),
    Pan(Messages.getString("ResetTools.pan"));

    private final String name;

    private ResetTools(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static JMenu createUnregisteredJMenu() {
        ButtonGroup group = new ButtonGroup();
        JMenu menu = new JMenu(Messages.getString("ResetTools.reset"));
        for (final ResetTools action : ResetTools.values()) {
            JMenuItem item = new JMenuItem(action.toString());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventManager.getInstance().reset(action);
                }
            });
            menu.add(item);
            group.add(item);
        }
        return menu;
    }
}

