/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d.dockable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.editor.SeriesViewerEvent;
import org.weasis.core.ui.editor.SeriesViewerListener;
import org.weasis.core.ui.editor.image.AnnotationsLayer;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.Tools;
import org.weasis.core.ui.util.CheckNode;
import org.weasis.core.ui.util.TreeLayer;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.Messages;
import org.weasis.dicom.viewer2d.View2dContainer;

public class DisplayTool
extends PluginTool
implements SeriesViewerListener {
    public static final String IMAGE = Messages.getString("DisplayTool.image");
    public static final String DICOM_IMAGE_OVERLAY = Messages.getString("DisplayTool.dicom_overlay");
    public static final String DICOM_ANNOTATIONS = Messages.getString("DisplayTool.dicom_ano");
    public static final String BUTTON_NAME = Messages.getString("DisplayTool.display");
    private final JCheckBox applyAllViews = new JCheckBox(Messages.getString("DisplayTool.btn_apply_all"), true);
    private final TreeLayer tree = new TreeLayer();
    private CheckNode image;
    private CheckNode dicomInfo;
    private CheckNode drawings;

    public DisplayTool(String pluginName, Icon icon) {
        super(BUTTON_NAME, pluginName, ToolWindowAnchor.RIGHT);
        this.setDockableWidth(210);
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout(0, 0));
        this.iniTree();
    }

    public void iniTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        this.image = new CheckNode((Object)IMAGE, true);
        root.add((MutableTreeNode)this.image);
        this.image.add((MutableTreeNode)new CheckNode((Object)DICOM_IMAGE_OVERLAY, true));
        this.dicomInfo = new CheckNode((Object)DICOM_ANNOTATIONS, true);
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.ANNOTATIONS, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.SCALE, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.LUT, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.IMAGE_ORIENTATION, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.WINDOW_LEVEL, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.ZOOM, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.ROTATION, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.FRAME, true));
        this.dicomInfo.add((MutableTreeNode)new CheckNode((Object)AnnotationsLayer.PIXEL, true));
        root.add((MutableTreeNode)this.dicomInfo);
        this.drawings = new CheckNode((Object)ActionW.DRAW, true);
        this.drawings.add((MutableTreeNode)new CheckNode((Object)Tools.MEASURE, true));
        this.drawings.add((MutableTreeNode)new CheckNode((Object)Tools.CROSSLINES, true));
        root.add((MutableTreeNode)this.drawings);
        DefaultTreeModel model = new DefaultTreeModel(root, false);
        this.tree.constructTree(model);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Object node;
                TreeLayer layer = (TreeLayer)e.getSource();
                TreePath path = layer.getPathForLocation(e.getX(), e.getY());
                if (path != null && (node = path.getLastPathComponent()) instanceof CheckNode) {
                    CheckNode checkNode;
                    checkNode.setSelected(!(checkNode = (CheckNode)node).isSelected());
                    if (checkNode.isUpdateChildren() && checkNode.getChildCount() > 0) {
                        TreeLayer.fireToChildren((Enumeration)checkNode.children(), (boolean)checkNode.isSelected());
                    } else if (checkNode.isUpdateParent()) {
                        TreeLayer.fireParentChecked((CheckNode)checkNode);
                    }
                    DisplayTool.this.tree.upadateNode(checkNode);
                    DisplayTool.this.changeLayerSelection(checkNode);
                }
            }
        });
        JPanel panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        this.add(panel, "North");
        panel.add(this.applyAllViews);
        DisplayTool.expandTree((JTree)this.tree, root);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree);
        this.add(scrollPane, "Center");
    }

    public void changeLayerSelection(CheckNode userObject) {
        block16: {
            ArrayList<DefaultView2d> views;
            boolean selected;
            String selection;
            block17: {
                block15: {
                    selection = userObject.toString();
                    selected = userObject.isSelected();
                    boolean allViews = this.applyAllViews.isSelected();
                    ImageViewerPlugin container = EventManager.getInstance().getSelectedView2dContainer();
                    views = null;
                    if (container != null) {
                        if (this.applyAllViews.isSelected()) {
                            views = container.getImagePanels();
                        } else {
                            views = new ArrayList<DefaultView2d>(1);
                            views.add(container.getSelectedImagePane());
                        }
                    }
                    if (!IMAGE.equals(selection) || views == null) break block15;
                    for (DefaultView2d v : views) {
                        if (selected == v.getImageLayer().isVisible()) continue;
                        v.getImageLayer().setVisible(selected);
                        v.repaint();
                    }
                    break block16;
                }
                if (!DICOM_IMAGE_OVERLAY.equals(selection)) break block17;
                ActionState overlay = EventManager.getInstance().getAction(ActionW.IMAGE_OVERLAY);
                if (!(overlay instanceof ToggleButtonListener)) break block16;
                ((ToggleButtonListener)overlay).setSelected(userObject.isSelected());
                break block16;
            }
            if (DICOM_ANNOTATIONS.equals(selection) && views != null) {
                for (DefaultView2d v : views) {
                    if (selected == v.getInfoLayer().isVisible()) continue;
                    v.getInfoLayer().setVisible(selected);
                    v.repaint();
                }
            } else if (this.dicomInfo.equals(userObject.getParent()) && views != null) {
                for (DefaultView2d v : views) {
                    AnnotationsLayer layer = v.getInfoLayer();
                    if (layer == null || !layer.setDisplayPreferencesValue(selection, selected)) continue;
                    v.repaint();
                }
            } else if (ActionW.DRAW.toString().equals(selection) && views != null) {
                for (DefaultView2d v : views) {
                    v.setDrawingsVisibility(selected);
                }
            } else if (this.drawings.equals(userObject.getParent()) && views != null && userObject.getUserObject() instanceof Tools) {
                Tools tool = (Tools)userObject.getUserObject();
                for (DefaultView2d v : views) {
                    AbstractLayer layer = v.getLayerModel().getLayer(tool);
                    if (layer == null || layer.isVisible() == selected) continue;
                    layer.setVisible(selected);
                    v.repaint();
                }
            }
        }
    }

    public void iniTreeValues(DefaultView2d view) {
        if (view != null) {
            Boolean draw;
            this.image.setSelected(view.getImageLayer().isVisible());
            TreeNode treeNode = this.image.getChildAt(0);
            if (treeNode instanceof CheckNode) {
                CheckNode dicom_overlay = (CheckNode)treeNode;
                ActionState overlay = EventManager.getInstance().getAction(ActionW.IMAGE_OVERLAY);
                if (overlay instanceof ToggleButtonListener) {
                    dicom_overlay.setSelected(((ToggleButtonListener)overlay).isSelected());
                }
            }
            this.tree.upadateNode(this.image);
            AnnotationsLayer layer = view.getInfoLayer();
            if (layer != null) {
                this.dicomInfo.setSelected(layer.isVisible());
                Enumeration en = this.dicomInfo.children();
                while (en.hasMoreElements()) {
                    Object node = en.nextElement();
                    if (!(node instanceof CheckNode)) continue;
                    CheckNode checkNode = (CheckNode)node;
                    checkNode.setSelected(layer.getDisplayPreferences(node.toString()));
                }
                this.tree.upadateNode(this.dicomInfo);
            }
            this.drawings.setSelected((draw = (Boolean)view.getActionValue(ActionW.DRAW.cmd())) == null ? true : draw);
            Enumeration en = this.drawings.children();
            while (en.hasMoreElements()) {
                Object node = en.nextElement();
                if (!(node instanceof CheckNode) || !(((CheckNode)node).getUserObject() instanceof Tools)) continue;
                CheckNode checkNode = (CheckNode)node;
                AbstractLayer l = view.getLayerModel().getLayer((Tools)((CheckNode)node).getUserObject());
                if (layer == null) continue;
                checkNode.setSelected(l.isVisible());
            }
        }
    }

    public Component getToolComponent() {
        return this;
    }

    public void expandAllTree() {
        this.tree.expandRow(4);
    }

    protected void changeToolWindowAnchor(ToolWindowAnchor anchor) {
    }

    public void changingViewContentEvent(SeriesViewerEvent event) {
        if (event.getEventType().equals((Object)SeriesViewerEvent.EVENT.SELECT) && event.getSeriesViewer() instanceof View2dContainer) {
            this.iniTreeValues(((View2dContainer)event.getSeriesViewer()).getSelectedImagePane());
        }
    }

    private static void expandTree(JTree tree, DefaultMutableTreeNode start) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            tree.expandPath(tp);
            DisplayTool.expandTree(tree, dtm);
        }
    }
}

