/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.HostedRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.ResourceNotFoundException;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.CompoundEnumeration;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleImpl
implements Module {
    private final Logger m_logger;
    private final Map m_configMap;
    private final Felix.StatefulResolver m_resolver;
    private final String m_id;
    private final Content m_content;
    private final Map m_headerMap;
    private final URLStreamHandler m_streamHandler;
    private final String m_manifestVersion;
    private final boolean m_isExtension;
    private final String m_symbolicName;
    private final Version m_version;
    private final List<Capability> m_capabilities;
    private List<Capability> m_cachedCapabilities = null;
    private final List<Requirement> m_requirements;
    private List<Requirement> m_cachedRequirements = null;
    private final List<Requirement> m_dynamicRequirements;
    private List<Requirement> m_cachedDynamicRequirements = null;
    private final List<R4Library> m_nativeLibraries;
    private final int m_declaredActivationPolicy;
    private final List<String> m_activationIncludes;
    private final List<String> m_activationExcludes;
    private final Bundle m_bundle;
    private List<Module> m_fragments = null;
    private List<Wire> m_wires = null;
    private List<Module> m_dependentImporters = new ArrayList<Module>(0);
    private List<Module> m_dependentRequirers = new ArrayList<Module>(0);
    private volatile boolean m_isResolved = false;
    private Content[] m_contentPath;
    private Content[] m_fragmentContents = null;
    private ModuleClassLoader m_classLoader;
    private boolean m_isActivationTriggered = false;
    private ProtectionDomain m_protectionDomain = null;
    private static final SecureAction m_secureAction = new SecureAction();
    private final ClassLoader m_bootClassLoader;
    private static final ClassLoader m_defBootClassLoader;
    private final String[] m_bootPkgs;
    private final boolean[] m_bootPkgWildcards;
    private final boolean m_implicitBootDelegation;
    private final boolean m_useLocalURLs;
    private static SecurityManagerEx m_sm;
    private final ThreadLocal m_cycleCheck = new ThreadLocal();
    private static final ThreadLocal m_deferredActivation;
    private static volatile boolean m_isPreJava5;
    private static final Constructor m_dexFileClassConstructor;
    private static final Method m_dexFileClassLoadDex;
    private static final Method m_dexFileClassLoadClass;
    static /* synthetic */ Class class$java$security$SecureClassLoader;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader;
    static /* synthetic */ Class class$org$apache$felix$framework$ModuleImpl$ModuleClassLoaderJava5;
    static /* synthetic */ Class class$org$apache$felix$framework$ModuleImpl;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$felix$framework$BundleImpl;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    public ModuleImpl(Logger logger, Map configMap, Bundle bundle, String id, String[] bootPkgs, boolean[] bootPkgWildcards) {
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_resolver = null;
        this.m_bundle = bundle;
        this.m_id = id;
        this.m_headerMap = null;
        this.m_content = null;
        this.m_streamHandler = null;
        this.m_bootPkgs = bootPkgs;
        this.m_bootPkgWildcards = bootPkgWildcards;
        this.m_manifestVersion = null;
        this.m_symbolicName = null;
        this.m_isExtension = false;
        this.m_version = null;
        this.m_capabilities = null;
        this.m_requirements = null;
        this.m_dynamicRequirements = null;
        this.m_nativeLibraries = null;
        this.m_declaredActivationPolicy = 0;
        this.m_activationExcludes = null;
        this.m_activationIncludes = null;
        this.m_implicitBootDelegation = false;
        this.m_useLocalURLs = this.m_configMap.get("felix.jarurls") != null;
        this.m_bootClassLoader = m_defBootClassLoader;
    }

    ModuleImpl(Logger logger, Map configMap, Felix.StatefulResolver resolver, Bundle bundle, String id, Map headerMap, Content content, URLStreamHandler streamHandler, String[] bootPkgs, boolean[] bootPkgWildcards) throws BundleException {
        Object l;
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_resolver = resolver;
        this.m_bundle = bundle;
        this.m_id = id;
        this.m_headerMap = headerMap;
        this.m_content = content;
        this.m_streamHandler = streamHandler;
        this.m_bootPkgs = bootPkgs;
        this.m_bootPkgWildcards = bootPkgWildcards;
        this.m_implicitBootDelegation = this.m_configMap.get("felix.bootdelegation.implicit") == null || Boolean.valueOf((String)this.m_configMap.get("felix.bootdelegation.implicit")) != false;
        this.m_useLocalURLs = this.m_configMap.get("felix.jarurls") != null;
        ClassLoader bootLoader = m_defBootClassLoader;
        Object map = this.m_configMap.get("felix.bootdelegation.classloaders");
        if (map instanceof Map && (l = ((Map)map).get(bundle)) instanceof ClassLoader) {
            bootLoader = (ClassLoader)l;
        }
        this.m_bootClassLoader = bootLoader;
        ManifestParser mp = new ManifestParser(this.m_logger, this.m_configMap, this, this.m_headerMap);
        this.m_manifestVersion = mp.getManifestVersion();
        this.m_version = mp.getBundleVersion();
        this.m_capabilities = mp.isExtension() ? null : mp.getCapabilities();
        this.m_requirements = mp.getRequirements();
        this.m_dynamicRequirements = mp.getDynamicRequirements();
        this.m_nativeLibraries = mp.getLibraries();
        this.m_declaredActivationPolicy = mp.getActivationPolicy();
        this.m_activationExcludes = mp.getActivationExcludeDirective() == null ? null : ManifestParser.parseDelimitedString(mp.getActivationExcludeDirective(), ",");
        this.m_activationIncludes = mp.getActivationIncludeDirective() == null ? null : ManifestParser.parseDelimitedString(mp.getActivationIncludeDirective(), ",");
        this.m_symbolicName = mp.getSymbolicName();
        this.m_isExtension = mp.isExtension();
    }

    @Override
    public Map getHeaders() {
        return this.m_headerMap;
    }

    @Override
    public boolean isExtension() {
        return this.m_isExtension;
    }

    @Override
    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public String getManifestVersion() {
        return this.m_manifestVersion;
    }

    @Override
    public Version getVersion() {
        return this.m_version;
    }

    @Override
    public synchronized List<Capability> getCapabilities() {
        if (this.m_cachedCapabilities == null) {
            ArrayList<HostedCapability> capList = this.m_capabilities == null ? new ArrayList<HostedCapability>() : new ArrayList<Capability>(this.m_capabilities);
            for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
                List<Capability> caps = this.m_fragments.get(fragIdx).getCapabilities();
                for (int capIdx = 0; caps != null && capIdx < caps.size(); ++capIdx) {
                    if (!caps.get(capIdx).getNamespace().equals("package")) continue;
                    capList.add(new HostedCapability(this, caps.get(capIdx)));
                }
            }
            this.m_cachedCapabilities = Collections.unmodifiableList(capList);
        }
        return this.m_cachedCapabilities;
    }

    @Override
    public synchronized List<Requirement> getRequirements() {
        if (this.m_cachedRequirements == null) {
            ArrayList<HostedRequirement> reqList = this.m_requirements == null ? new ArrayList<HostedRequirement>() : new ArrayList<Requirement>(this.m_requirements);
            for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
                List<Requirement> reqs = this.m_fragments.get(fragIdx).getRequirements();
                for (int reqIdx = 0; reqs != null && reqIdx < reqs.size(); ++reqIdx) {
                    if (!reqs.get(reqIdx).getNamespace().equals("package") && !reqs.get(reqIdx).getNamespace().equals("module")) continue;
                    reqList.add(new HostedRequirement(this, reqs.get(reqIdx)));
                }
            }
            this.m_cachedRequirements = Collections.unmodifiableList(reqList);
        }
        return this.m_cachedRequirements;
    }

    @Override
    public synchronized List<Requirement> getDynamicRequirements() {
        if (this.m_cachedDynamicRequirements == null) {
            ArrayList<Requirement> reqList = this.m_dynamicRequirements == null ? new ArrayList<Requirement>() : new ArrayList<Requirement>(this.m_dynamicRequirements);
            for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
                List<Requirement> reqs = this.m_fragments.get(fragIdx).getDynamicRequirements();
                for (int reqIdx = 0; reqs != null && reqIdx < reqs.size(); ++reqIdx) {
                    if (!reqs.get(reqIdx).getNamespace().equals("package")) continue;
                    reqList.add(reqs.get(reqIdx));
                }
            }
            this.m_cachedDynamicRequirements = Collections.unmodifiableList(reqList);
        }
        return this.m_cachedDynamicRequirements;
    }

    @Override
    public synchronized List<R4Library> getNativeLibraries() {
        List<R4Library> result = null;
        if (this.m_isResolved) {
            ArrayList<R4Library> nativeList = this.m_nativeLibraries == null ? new ArrayList<R4Library>() : new ArrayList<R4Library>(this.m_nativeLibraries);
            for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
                List<R4Library> libs = this.m_fragments.get(fragIdx).getNativeLibraries();
                for (int reqIdx = 0; libs != null && reqIdx < libs.size(); ++reqIdx) {
                    nativeList.add(libs.get(reqIdx));
                }
            }
            result = nativeList.isEmpty() ? null : Collections.unmodifiableList(nativeList);
        } else {
            result = this.m_nativeLibraries;
        }
        return result;
    }

    @Override
    public int getDeclaredActivationPolicy() {
        return this.m_declaredActivationPolicy;
    }

    synchronized boolean isActivationTriggered() {
        return this.m_isActivationTriggered;
    }

    boolean isActivationTrigger(String pkgName) {
        if (this.m_activationIncludes == null && this.m_activationExcludes == null) {
            return true;
        }
        boolean included = this.m_activationIncludes == null;
        for (int i = 0; !included && this.m_activationIncludes != null && i < this.m_activationIncludes.size(); ++i) {
            included = this.m_activationIncludes.get(i).equals(pkgName);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && this.m_activationExcludes != null && i < this.m_activationExcludes.size(); ++i) {
            excluded = this.m_activationExcludes.get(i).equals(pkgName);
        }
        return included && !excluded;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public synchronized List<Wire> getWires() {
        return this.m_wires;
    }

    public synchronized void setWires(List<Wire> wires) {
        int i;
        boolean isFragment = Util.isFragment(this);
        for (i = 0; !isFragment && this.m_wires != null && i < this.m_wires.size(); ++i) {
            if (this.m_wires.get(i).getCapability().getNamespace().equals("module")) {
                ((ModuleImpl)this.m_wires.get(i).getExporter()).removeDependentRequirer(this);
                continue;
            }
            if (!this.m_wires.get(i).getCapability().getNamespace().equals("package")) continue;
            ((ModuleImpl)this.m_wires.get(i).getExporter()).removeDependentImporter(this);
        }
        this.m_wires = wires;
        for (i = 0; !isFragment && this.m_wires != null && i < this.m_wires.size(); ++i) {
            if (this.m_wires.get(i).getCapability().getNamespace().equals("module")) {
                ((ModuleImpl)this.m_wires.get(i).getExporter()).addDependentRequirer(this);
                continue;
            }
            if (!this.m_wires.get(i).getCapability().getNamespace().equals("package")) continue;
            ((ModuleImpl)this.m_wires.get(i).getExporter()).addDependentImporter(this);
        }
    }

    @Override
    public boolean isResolved() {
        return this.m_isResolved;
    }

    public void setResolved() {
        this.m_isResolved = true;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_protectionDomain = (ProtectionDomain)securityContext;
    }

    @Override
    public synchronized Object getSecurityContext() {
        return this.m_protectionDomain;
    }

    @Override
    public boolean isRemovalPending() {
        return this.m_bundle.getState() == 1 || this != ((BundleImpl)this.m_bundle).getCurrentModule();
    }

    @Override
    public Content getContent() {
        return this.m_content;
    }

    private synchronized Content[] getContentPath() {
        if (this.m_contentPath == null) {
            try {
                this.m_contentPath = this.initializeContentPath();
            }
            catch (Exception ex) {
                this.m_logger.log(this.m_bundle, 1, "Unable to get module class path.", (Throwable)ex);
            }
        }
        return this.m_contentPath;
    }

    private Content[] initializeContentPath() throws Exception {
        ArrayList contentList = new ArrayList();
        this.calculateContentPath(this, this.m_content, contentList, true);
        for (int i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.calculateContentPath(this.m_fragments.get(i), this.m_fragmentContents[i], contentList, false);
        }
        return contentList.toArray(new Content[contentList.size()]);
    }

    private List calculateContentPath(Module module, Content content, List contentList, boolean searchFragments) throws Exception {
        ArrayList<Content> localContentList = new ArrayList<Content>();
        String classPath = (String)module.getHeaders().get("Bundle-ClassPath");
        List<String> classPathStrings = ManifestParser.parseDelimitedString(classPath, ",");
        if (classPathStrings == null) {
            classPathStrings = new ArrayList<String>(0);
        }
        for (int i = 0; i < classPathStrings.size(); ++i) {
            classPathStrings.set(i, classPathStrings.get(i).startsWith("/") ? classPathStrings.get(i).substring(1) : classPathStrings.get(i));
            if (classPathStrings.get(i).equals(".")) {
                localContentList.add(content);
                continue;
            }
            Content embeddedContent = content.getEntryAsContent(classPathStrings.get(i));
            for (int fragIdx = 0; searchFragments && embeddedContent == null && this.m_fragmentContents != null && fragIdx < this.m_fragmentContents.length; ++fragIdx) {
                embeddedContent = this.m_fragmentContents[fragIdx].getEntryAsContent(classPathStrings.get(i));
            }
            if (embeddedContent != null) {
                localContentList.add(embeddedContent);
                continue;
            }
            this.m_logger.log(this.m_bundle, 3, new StringBuffer().append("Class path entry not found: ").append(classPathStrings.get(i)).toString());
        }
        if (localContentList.isEmpty()) {
            localContentList.add(content);
        }
        contentList.addAll(localContentList);
        return contentList;
    }

    @Override
    public Class getClassByDelegation(String name) throws ClassNotFoundException {
        if (name != null && name.length() > 0 && name.charAt(0) == '[') {
            return Class.forName(name, false, this.getClassLoader());
        }
        return this.getClassLoader().loadClass(name);
    }

    @Override
    public URL getResourceByDelegation(String name) {
        try {
            return (URL)this.findClassOrResourceByDelegation(name, false);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(this.m_bundle, 4, ex.getMessage());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findClassOrResourceByDelegation(String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        Object result = null;
        HashSet<String> requestSet = (HashSet<String>)this.m_cycleCheck.get();
        if (requestSet == null) {
            requestSet = new HashSet<String>();
            this.m_cycleCheck.set(requestSet);
        }
        if (!requestSet.add(name)) return null;
        try {
            String pkgName;
            block15: {
                this.m_resolver.resolve(this);
                String string = pkgName = isClass ? Util.getClassPackage(name) : Util.getResourcePackage(name);
                if (this.shouldBootDelegate(pkgName)) {
                    try {
                        ClassLoader bdcl = this.getBootDelegationClassLoader();
                        Object object = result = isClass ? bdcl.loadClass(name) : bdcl.getResource(name);
                        if (pkgName.startsWith("java.") || result != null) {
                            Serializable serializable = result;
                            return serializable;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        if (!pkgName.startsWith("java.")) break block15;
                        throw ex;
                    }
                }
            }
            if ((result = this.searchImports(name, isClass)) == null) {
                Object object = result = isClass ? this.getClassLoader().findClass(name) : this.getResourceLocal(name);
                if (result == null) {
                    result = this.searchDynamicImports(name, pkgName, isClass);
                }
            }
        }
        catch (ResolveException ex) {
            if (isClass) {
                throw new ClassNotFoundException(new StringBuffer().append(name).append(" not found because ").append(this.getBundle()).append(" cannot resolve: ").append(ex.getRequirement()).toString());
            }
            URL url = this.getResourceLocal(name);
            if (url == null) throw new ResourceNotFoundException(new StringBuffer().append(name).append(" not found because ").append(this.getBundle()).append(" cannot resolve: ").append(ex.getRequirement()).toString());
            URL uRL = url;
            return uRL;
        }
        finally {
            requestSet.remove(name);
        }
        if (result != null) return result;
        if (!isClass) throw new ResourceNotFoundException(new StringBuffer().append(name).append(" not found by ").append(this.getBundle()).toString());
        throw new ClassNotFoundException(new StringBuffer().append(name).append(" not found by ").append(this.getBundle()).toString());
    }

    URL getResourceLocal(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.createURL(1, name);
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        Content[] contentPath = this.getContentPath();
        for (int i = 0; url == null && i < contentPath.length; ++i) {
            if (!contentPath[i].hasEntry(name)) continue;
            url = this.createURL(i + 1, name);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration getResourcesByDelegation(String name) {
        HashSet<String> requestSet = (HashSet<String>)this.m_cycleCheck.get();
        if (requestSet == null) {
            requestSet = new HashSet<String>();
            this.m_cycleCheck.set(requestSet);
        }
        if (!requestSet.contains(name)) {
            requestSet.add(name);
            try {
                Enumeration enumeration = this.findResourcesByDelegation(name);
                return enumeration;
            }
            finally {
                requestSet.remove(name);
            }
        }
        return null;
    }

    private Enumeration findResourcesByDelegation(String name) {
        int i;
        Enumeration urls = null;
        ArrayList<Enumeration> completeUrlList = new ArrayList<Enumeration>();
        try {
            this.m_resolver.resolve(this);
        }
        catch (ResolveException ex) {
            return this.getResourcesLocal(name);
        }
        String pkgName = Util.getResourcePackage(name);
        if (this.shouldBootDelegate(pkgName)) {
            try {
                ClassLoader bdcl = this.getBootDelegationClassLoader();
                urls = bdcl.getResources(name);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (pkgName.startsWith("java.")) {
                return urls;
            }
            completeUrlList.add(urls);
        }
        List<Wire> wires = this.getWires();
        for (i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).getRequirement().getNamespace().equals("package")) continue;
            try {
                urls = wires.get(i).getResources(name);
            }
            catch (ResourceNotFoundException ex) {
                urls = null;
            }
            if (urls == null) continue;
            completeUrlList.add(urls);
            return new CompoundEnumeration(completeUrlList.toArray(new Enumeration[completeUrlList.size()]));
        }
        for (i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).getRequirement().getNamespace().equals("module")) continue;
            try {
                urls = wires.get(i).getResources(name);
            }
            catch (ResourceNotFoundException ex) {
                urls = null;
            }
            if (urls == null) continue;
            completeUrlList.add(urls);
        }
        urls = this.getResourcesLocal(name);
        if (urls != null && urls.hasMoreElements()) {
            completeUrlList.add(urls);
        } else {
            Wire wire = null;
            try {
                wire = this.m_resolver.resolve(this, pkgName);
            }
            catch (ResolveException ex) {
                // empty catch block
            }
            if (wire != null) {
                try {
                    urls = wire.getResources(name);
                }
                catch (ResourceNotFoundException ex) {
                    urls = null;
                }
                if (urls != null) {
                    completeUrlList.add(urls);
                }
            }
        }
        return new CompoundEnumeration(completeUrlList.toArray(new Enumeration[completeUrlList.size()]));
    }

    private Enumeration getResourcesLocal(String name) {
        ArrayList<URL> l = new ArrayList<URL>();
        Content[] contentPath = this.getContentPath();
        if (name.equals("/")) {
            for (int i = 0; i < contentPath.length; ++i) {
                l.add(this.createURL(i + 1, name));
            }
        } else {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            for (int i = 0; i < contentPath.length; ++i) {
                if (!contentPath[i].hasEntry(name)) continue;
                l.add(this.createURL(i + 1, name));
            }
        }
        return Collections.enumeration(l);
    }

    @Override
    public URL getEntry(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.createURL(0, "/");
        }
        if (url == null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (this.getContent().hasEntry(name)) {
                url = this.createURL(0, name);
            }
        }
        return url;
    }

    @Override
    public boolean hasInputStream(int index, String urlPath) {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.hasEntry(urlPath);
        }
        return this.getContentPath()[index - 1].hasEntry(urlPath);
    }

    @Override
    public InputStream getInputStream(int index, String urlPath) throws IOException {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.getEntryAsStream(urlPath);
        }
        return this.getContentPath()[index - 1].getEntryAsStream(urlPath);
    }

    @Override
    public URL getLocalURL(int index, String urlPath) {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.getEntryAsURL(urlPath);
        }
        return this.getContentPath()[index - 1].getEntryAsURL(urlPath);
    }

    private URL createURL(int port, String path) {
        if (!path.startsWith("/")) {
            path = new StringBuffer().append("/").append(path).toString();
        }
        try {
            return m_secureAction.createURL(null, new StringBuffer().append("bundle://").append(this.m_id).append(":").append(port).append(path).toString(), this.m_streamHandler);
        }
        catch (MalformedURLException ex) {
            this.m_logger.log(this.m_bundle, 1, "Unable to create resource URL.", (Throwable)ex);
            return null;
        }
    }

    public synchronized List<Module> getFragments() {
        return this.m_fragments;
    }

    public synchronized void attachFragments(List<Module> fragments) throws Exception {
        int i;
        block0: for (i = 0; this.m_fragments != null && i < this.m_fragments.size(); ++i) {
            if (this.m_fragments.get(i).getWires() == null) continue;
            ArrayList<Wire> hostWires = new ArrayList<Wire>(this.m_fragments.get(i).getWires());
            Iterator it = hostWires.iterator();
            while (it.hasNext()) {
                Wire hostWire = (Wire)it.next();
                if (!hostWire.getExporter().equals(this)) continue;
                it.remove();
                ((ModuleImpl)this.m_fragments.get(i)).setWires(hostWires);
                continue block0;
            }
        }
        for (i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.m_fragmentContents[i].close();
        }
        this.m_fragmentContents = null;
        for (i = 0; this.m_contentPath != null && i < this.m_contentPath.length; ++i) {
            if (this.m_content == this.m_contentPath[i]) continue;
            this.m_contentPath[i].close();
        }
        this.m_contentPath = null;
        this.m_cachedCapabilities = null;
        this.m_cachedRequirements = null;
        this.m_cachedDynamicRequirements = null;
        this.m_fragments = fragments;
        if (this.m_fragments != null) {
            if (this.m_fragments.size() > 1) {
                TreeMap<String, Module> sorted = new TreeMap<String, Module>();
                for (Module f : this.m_fragments) {
                    sorted.put(f.getId(), f);
                }
                this.m_fragments = new ArrayList(sorted.values());
            }
            this.m_fragmentContents = new Content[this.m_fragments.size()];
            for (int i2 = 0; this.m_fragments != null && i2 < this.m_fragments.size(); ++i2) {
                this.m_fragmentContents[i2] = this.m_fragments.get(i2).getContent().getEntryAsContent(".");
            }
            this.m_contentPath = this.initializeContentPath();
        }
    }

    public synchronized List<Module> getDependentImporters() {
        return this.m_dependentImporters;
    }

    public synchronized void addDependentImporter(Module module) {
        if (!this.m_dependentImporters.contains(module)) {
            this.m_dependentImporters.add(module);
        }
    }

    public synchronized void removeDependentImporter(Module module) {
        this.m_dependentImporters.remove(module);
    }

    public synchronized List<Module> getDependentRequirers() {
        return this.m_dependentRequirers;
    }

    public synchronized void addDependentRequirer(Module module) {
        if (!this.m_dependentRequirers.contains(module)) {
            this.m_dependentRequirers.add(module);
        }
    }

    public synchronized void removeDependentRequirer(Module module) {
        this.m_dependentRequirers.remove(module);
    }

    public synchronized List<Module> getDependents() {
        ArrayList<Module> dependents;
        if (Util.isFragment(this)) {
            dependents = new ArrayList<Module>();
            for (int i = 0; this.m_wires != null && i < this.m_wires.size(); ++i) {
                dependents.add(this.m_wires.get(i).getExporter());
            }
        } else {
            dependents = new ArrayList(this.m_dependentImporters.size() + this.m_dependentRequirers.size());
            dependents.addAll(this.m_dependentImporters);
            dependents.addAll(this.m_dependentRequirers);
        }
        return dependents;
    }

    public synchronized void close() {
        int i;
        this.m_content.close();
        for (i = 0; this.m_contentPath != null && i < this.m_contentPath.length; ++i) {
            this.m_contentPath[i].close();
        }
        this.m_contentPath = null;
        for (i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.m_fragmentContents[i].close();
        }
        this.m_fragmentContents = null;
        this.m_classLoader = null;
    }

    public String toString() {
        return this.m_id;
    }

    private synchronized ModuleClassLoader getClassLoader() {
        if (this.m_classLoader == null) {
            Class clazz;
            if (m_isPreJava5) {
                clazz = class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader;
            } else {
                try {
                    clazz = class$org$apache$felix$framework$ModuleImpl$ModuleClassLoaderJava5 == null ? (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoaderJava5 = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoaderJava5")) : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoaderJava5;
                }
                catch (Throwable th) {
                    m_isPreJava5 = true;
                    clazz = class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader;
                }
            }
            try {
                Constructor ctor = m_secureAction.getConstructor(clazz, new Class[]{class$org$apache$felix$framework$ModuleImpl == null ? (class$org$apache$felix$framework$ModuleImpl = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl")) : class$org$apache$felix$framework$ModuleImpl, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader});
                this.m_classLoader = (ModuleClassLoader)m_secureAction.invoke(ctor, new Object[]{this, this.determineParentClassLoader()});
            }
            catch (Exception ex) {
                throw new RuntimeException(new StringBuffer().append("Unable to create module class loader: ").append(ex.getMessage()).append(" [").append(ex.getClass().getName()).append("]").toString());
            }
        }
        return this.m_classLoader;
    }

    private ClassLoader determineParentClassLoader() {
        String cfg = (String)this.m_configMap.get("org.osgi.framework.bundle.parent");
        String string = cfg = cfg == null ? "boot" : cfg;
        ClassLoader parent = cfg.equalsIgnoreCase("app") ? m_secureAction.getSystemClassLoader() : (cfg.equalsIgnoreCase("ext") ? m_secureAction.getSystemClassLoader().getParent() : (cfg.equalsIgnoreCase("framework") ? (class$org$apache$felix$framework$ModuleImpl == null ? (class$org$apache$felix$framework$ModuleImpl = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl")) : class$org$apache$felix$framework$ModuleImpl).getClassLoader() : (this.m_bootClassLoader == null ? m_secureAction.getSystemClassLoader() : null)));
        return parent;
    }

    private Object searchImports(String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        List<Wire> wires = this.getWires();
        for (int i = 0; wires != null && i < wires.size(); ++i) {
            Serializable result;
            Serializable serializable = result = isClass ? wires.get(i).getClass(name) : wires.get(i).getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Object searchDynamicImports(final String name, String pkgName, final boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        Wire wire = null;
        try {
            wire = this.m_resolver.resolve(this, pkgName);
        }
        catch (ResolveException ex) {
            // empty catch block
        }
        if (wire != null) {
            return isClass ? wire.getClass(name) : wire.getResource(name);
        }
        if (this.m_implicitBootDelegation) {
            final Class[] classes = m_sm.getClassContext();
            try {
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ModuleImpl.this.doImplicitBootDelegation(classes, name, isClass);
                        }
                    });
                }
                return this.doImplicitBootDelegation(classes, name, isClass);
            }
            catch (PrivilegedActionException ex) {
                Exception cause = ex.getException();
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                throw (ResourceNotFoundException)cause;
            }
        }
        return null;
    }

    private Object doImplicitBootDelegation(Class[] classes, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        for (int i = 1; !(i >= classes.length || (class$java$lang$Thread == null ? ModuleImpl.class$("java.lang.Thread") : class$java$lang$Thread).equals(classes[i]) || this.isClassLoadedFromModule(classes[i]) || (class$org$apache$felix$framework$BundleImpl == null ? ModuleImpl.class$("org.apache.felix.framework.BundleImpl") : class$org$apache$felix$framework$BundleImpl).equals(classes[i])); ++i) {
            if (!this.isClassExternal(classes[i])) continue;
            try {
                return isClass ? this.getClass().getClassLoader().loadClass(name) : this.getClass().getClassLoader().getResource(name);
            }
            catch (NoClassDefFoundError ex) {
                break;
            }
        }
        return null;
    }

    private boolean isClassLoadedFromModule(Class clazz) {
        if ((class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader).isInstance(clazz.getClassLoader())) {
            return true;
        }
        ClassLoader last = null;
        ClassLoader cl = clazz.getClassLoader();
        while (cl != null && last != cl) {
            last = cl;
            if ((class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader == null ? ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoader") : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader).isInstance(cl)) {
                return true;
            }
            cl = cl.getClass().getClassLoader();
        }
        return false;
    }

    private boolean isClassExternal(Class clazz) {
        if (clazz.getName().startsWith("org.apache.felix.framework.")) {
            return false;
        }
        if (clazz.getName().startsWith("org.osgi.framework.")) {
            return false;
        }
        if ((class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).equals(clazz)) {
            return false;
        }
        return !(class$java$lang$Class == null ? (class$java$lang$Class = ModuleImpl.class$("java.lang.Class")) : class$java$lang$Class).equals(clazz);
    }

    boolean shouldBootDelegate(String pkgName) {
        if (this.m_bootClassLoader != m_defBootClassLoader) {
            return true;
        }
        boolean result = false;
        if (pkgName.length() > 0) {
            for (int i = 0; !result && i < this.m_bootPkgs.length; ++i) {
                if (this.m_bootPkgWildcards[i] && pkgName.startsWith(this.m_bootPkgs[i])) {
                    return true;
                }
                if (!this.m_bootPkgs[i].equals(pkgName)) continue;
                return true;
            }
        }
        return result;
    }

    ClassLoader getBootDelegationClassLoader() {
        ClassLoader parent = this.m_classLoader == null ? this.determineParentClassLoader() : this.m_classLoader.getParent();
        return parent == null ? this.m_bootClassLoader : parent;
    }

    static URL convertToLocalUrl(URL url) {
        if (url.getProtocol().equals("bundle")) {
            try {
                url = ((URLHandlersBundleURLConnection)url.openConnection()).getLocalURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    private static String diagnoseClassLoadError(Felix.StatefulResolver resolver, ModuleImpl module, String name) {
        String pkgName = Util.getClassPackage(name);
        if (pkgName.length() == 0) {
            return null;
        }
        String importer = module.getBundle().toString();
        List<Wire> wires = module.getWires();
        for (int i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).getCapability().getNamespace().equals("package") || !wires.get(i).getCapability().getAttribute("package").getValue().equals(pkgName)) continue;
            String exporter = wires.get(i).getExporter().getBundle().toString();
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is imported by bundle ");
            sb.append(importer);
            sb.append(" from bundle ");
            sb.append(exporter);
            sb.append(", but the exported package from bundle ");
            sb.append(exporter);
            sb.append(" does not contain the requested class '");
            sb.append(name);
            sb.append("'. Please verify that the class name is correct in the importing bundle ");
            sb.append(importer);
            sb.append(" and/or that the exported package is correctly bundled in ");
            sb.append(exporter);
            sb.append(". ***");
            return sb.toString();
        }
        List<Requirement> reqs = module.getRequirements();
        if (resolver.isAllowedDynamicImport(module, pkgName)) {
            List dirs = Collections.EMPTY_LIST;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
            attrs.add(new Attribute("package", pkgName, false));
            RequirementImpl req = new RequirementImpl(module, "package", dirs, attrs);
            Set<Capability> exporters = resolver.getCandidates(req, false);
            Wire wire = null;
            try {
                wire = resolver.resolve(module, pkgName);
            }
            catch (Exception ex) {
                wire = null;
            }
            String exporter = exporters.isEmpty() ? null : exporters.iterator().next().getModule().getBundle().toString();
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found, but this is likely normal since package '");
            sb.append(pkgName);
            sb.append("' is dynamically imported by bundle ");
            sb.append(importer);
            sb.append(".");
            if (exporters.size() > 0 && wire == null) {
                sb.append(" However, bundle ");
                sb.append(exporter);
                sb.append(" does export this package with attributes that do not match.");
            }
            sb.append(" ***");
            return sb.toString();
        }
        List dirs = Collections.EMPTY_LIST;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(new Attribute("package", pkgName, false));
        RequirementImpl req = new RequirementImpl(module, "package", dirs, attrs);
        Set<Capability> exports = resolver.getCandidates(req, false);
        if (exports.size() > 0) {
            boolean classpath = false;
            try {
                (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader).getClassLoader().loadClass(name);
                classpath = true;
            }
            catch (NoClassDefFoundError err) {
            }
            catch (Exception ex) {
                // empty catch block
            }
            String exporter = exports.iterator().next().getModule().getBundle().toString();
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found because bundle ");
            sb.append(importer);
            sb.append(" does not import '");
            sb.append(pkgName);
            sb.append("' even though bundle ");
            sb.append(exporter);
            sb.append(" does export it.");
            if (classpath) {
                sb.append(" Additionally, the class is also available from the system class loader. There are two fixes: 1) Add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(importer);
                sb.append("; imports are necessary for each class directly touched by bundle code or indirectly touched, such as super classes if their methods are used. ");
                sb.append("2) Add package '");
                sb.append(pkgName);
                sb.append("' to the '");
                sb.append("org.osgi.framework.bootdelegation");
                sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            } else {
                sb.append(" To resolve this issue, add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(importer);
                sb.append(".");
            }
            sb.append(" ***");
            return sb.toString();
        }
        try {
            (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$ModuleImpl$ModuleClassLoader).getClassLoader().loadClass(name);
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is not imported by bundle ");
            sb.append(importer);
            sb.append(", nor is there any bundle that exports package '");
            sb.append(pkgName);
            sb.append("'. However, the class '");
            sb.append(name);
            sb.append("' is available from the system class loader. There are two fixes: 1) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.system.packages.extra");
            sb.append("' property and modify bundle ");
            sb.append(importer);
            sb.append(" to import this package; this causes the system bundle to export class path packages. 2) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.bootdelegation");
            sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            sb.append(" ***");
            return sb.toString();
        }
        catch (Exception ex2) {
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found. Bundle ");
            sb.append(importer);
            sb.append(" does not import package '");
            sb.append(pkgName);
            sb.append("', nor is the package exported by any other bundle or available from the system class loader.");
            sb.append(" ***");
            return sb.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        ClassLoader cl = null;
        try {
            Constructor ctor = m_secureAction.getDeclaredConstructor(class$java$security$SecureClassLoader == null ? (class$java$security$SecureClassLoader = ModuleImpl.class$("java.security.SecureClassLoader")) : class$java$security$SecureClassLoader, new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader});
            m_secureAction.setAccesssible(ctor);
            cl = (ClassLoader)m_secureAction.invoke(ctor, new Object[]{null});
        }
        catch (Throwable ex) {
            cl = null;
            System.err.println(new StringBuffer().append("Problem creating boot delegation class loader: ").append(ex).toString());
        }
        m_defBootClassLoader = cl;
        m_sm = new SecurityManagerEx();
        m_deferredActivation = new ThreadLocal();
        m_isPreJava5 = false;
        Constructor<?> dexFileClassConstructor = null;
        Method dexFileClassLoadDex = null;
        Method dexFileClassLoadClass = null;
        try {
            Class<?> dexFileClass;
            try {
                dexFileClass = Class.forName("dalvik.system.DexFile");
            }
            catch (Exception ex) {
                dexFileClass = Class.forName("android.dalvik.DexFile");
            }
            try {
                dexFileClassLoadDex = dexFileClass.getMethod("loadDex", class$java$lang$String == null ? (class$java$lang$String = ModuleImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ModuleImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            }
            catch (Exception ex) {
                // empty catch block
            }
            dexFileClassConstructor = dexFileClass.getConstructor(class$java$io$File == null ? (class$java$io$File = ModuleImpl.class$("java.io.File")) : class$java$io$File);
            dexFileClassLoadClass = dexFileClass.getMethod("loadClass", class$java$lang$String == null ? (class$java$lang$String = ModuleImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        }
        catch (Throwable ex) {
            dexFileClassConstructor = null;
            dexFileClassLoadDex = null;
            dexFileClassLoadClass = null;
        }
        m_dexFileClassConstructor = dexFileClassConstructor;
        m_dexFileClassLoadDex = dexFileClassLoadDex;
        m_dexFileClassLoadClass = dexFileClassLoadClass;
    }

    static class ToLocalUrlEnumeration
    implements Enumeration {
        final Enumeration m_enumeration;

        ToLocalUrlEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object nextElement() {
            return ModuleImpl.convertToLocalUrl((URL)this.m_enumeration.nextElement());
        }
    }

    public class ModuleClassLoader
    extends SecureClassLoader
    implements BundleReference {
        private final Map m_jarContentToDexFile;
        private Object[][] m_cachedLibs;
        private static final int LIBNAME_IDX = 0;
        private static final int LIBPATH_IDX = 1;

        public ModuleClassLoader(ClassLoader parent) {
            super(parent);
            this.m_cachedLibs = new Object[0][];
            this.m_jarContentToDexFile = m_dexFileClassLoadClass != null ? new HashMap() : null;
        }

        public Bundle getBundle() {
            return ModuleImpl.this.getBundle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class clazz = null;
            ModuleClassLoader moduleClassLoader = this;
            synchronized (moduleClassLoader) {
                clazz = this.findLoadedClass(name);
            }
            if (clazz == null) {
                try {
                    clazz = (Class)ModuleImpl.this.findClassOrResourceByDelegation(name, true);
                }
                catch (ResourceNotFoundException ex) {
                }
                catch (ClassNotFoundException cnfe) {
                    ClassNotFoundException ex = cnfe;
                    String msg = name;
                    if (ModuleImpl.this.m_logger.getLogLevel() >= 4) {
                        msg = ModuleImpl.diagnoseClassLoadError(ModuleImpl.this.m_resolver, ModuleImpl.this, name);
                        ex = msg != null ? new ClassNotFoundException(msg, cnfe) : ex;
                    }
                    throw ex;
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (clazz == null) {
                String actual = name.replace('.', '/') + ".class";
                byte[] bytes = null;
                Content[] contentPath = ModuleImpl.this.getContentPath();
                Content content = null;
                for (int i = 0; bytes == null && i < contentPath.length; ++i) {
                    bytes = contentPath[i].getEntryAsBytes(actual);
                    content = contentPath[i];
                }
                if (bytes != null) {
                    String pkgName = Util.getClassPackage(name);
                    ModuleClassLoader moduleClassLoader = this;
                    synchronized (moduleClassLoader) {
                        clazz = this.findLoadedClass(name);
                        if (clazz == null) {
                            boolean isTriggerClass;
                            int activationPolicy = ((BundleImpl)this.getBundle()).isDeclaredActivationPolicyUsed() ? ((BundleImpl)this.getBundle()).getCurrentModule().getDeclaredActivationPolicy() : 0;
                            boolean bl = isTriggerClass = ModuleImpl.this.m_isActivationTriggered ? false : ModuleImpl.this.isActivationTrigger(pkgName);
                            if (!ModuleImpl.this.m_isActivationTriggered && isTriggerClass && activationPolicy == 1 && this.getBundle().getState() == 8) {
                                ArrayList<Object[]> deferredList = (ArrayList<Object[]>)m_deferredActivation.get();
                                if (deferredList == null) {
                                    deferredList = new ArrayList<Object[]>();
                                    m_deferredActivation.set(deferredList);
                                }
                                deferredList.add(new Object[]{name, this.getBundle()});
                            }
                            if (pkgName.length() > 0 && this.getPackage(pkgName) == null) {
                                Object[] params = this.definePackage(pkgName);
                                if (params != null) {
                                    this.definePackage(pkgName, (String)params[0], (String)params[1], (String)params[2], (String)params[3], (String)params[4], (String)params[5], null);
                                } else {
                                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                                }
                            }
                            if (content instanceof JarContent) {
                                try {
                                    clazz = this.getDexFileClass((JarContent)content, name, this);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            if (clazz == null) {
                                clazz = ModuleImpl.this.m_protectionDomain != null ? this.defineClass(name, bytes, 0, bytes.length, ModuleImpl.this.m_protectionDomain) : this.defineClass(name, bytes, 0, bytes.length);
                            }
                            if (!ModuleImpl.this.m_isActivationTriggered && isTriggerClass && clazz != null) {
                                ModuleImpl.this.m_isActivationTriggered = true;
                            }
                        }
                    }
                    List deferredList = (List)m_deferredActivation.get();
                    if (deferredList != null && deferredList.size() > 0 && ((Object[])deferredList.get(0))[0].equals(name)) {
                        for (int i = deferredList.size() - 1; i >= 0; --i) {
                            try {
                                ((BundleImpl)((Object[])deferredList.get(i))[1]).getFramework().activateBundle((BundleImpl)((Object[])deferredList.get(i))[1], true);
                                continue;
                            }
                            catch (BundleException ex) {
                                ex.printStackTrace();
                            }
                        }
                        deferredList.clear();
                    }
                }
            }
            return clazz;
        }

        private Object[] definePackage(String pkgName) {
            String spectitle = (String)ModuleImpl.this.m_headerMap.get("Specification-Title");
            String specversion = (String)ModuleImpl.this.m_headerMap.get("Specification-Version");
            String specvendor = (String)ModuleImpl.this.m_headerMap.get("Specification-Vendor");
            String impltitle = (String)ModuleImpl.this.m_headerMap.get("Implementation-Title");
            String implversion = (String)ModuleImpl.this.m_headerMap.get("Implementation-Version");
            String implvendor = (String)ModuleImpl.this.m_headerMap.get("Implementation-Vendor");
            if (spectitle != null || specversion != null || specvendor != null || impltitle != null || implversion != null || implvendor != null) {
                return new Object[]{spectitle, specversion, specvendor, impltitle, implversion, implvendor};
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class getDexFileClass(JarContent content, String name, ClassLoader loader) throws Exception {
            if (this.m_jarContentToDexFile == null) {
                return null;
            }
            Object dexFile = null;
            if (!this.m_jarContentToDexFile.containsKey(content)) {
                try {
                    if (m_dexFileClassLoadDex != null) {
                        dexFile = m_dexFileClassLoadDex.invoke(null, content.getFile().getAbsolutePath(), content.getFile().getAbsolutePath() + ".dex", new Integer(0));
                    }
                    dexFile = m_dexFileClassConstructor.newInstance(content.getFile());
                }
                finally {
                    this.m_jarContentToDexFile.put(content, dexFile);
                }
            } else {
                dexFile = this.m_jarContentToDexFile.get(content);
            }
            if (dexFile != null) {
                return (Class)m_dexFileClassLoadClass.invoke(dexFile, name.replace('.', '/'), loader);
            }
            return null;
        }

        public URL getResource(String name) {
            URL url = ModuleImpl.this.getResourceByDelegation(name);
            if (ModuleImpl.this.m_useLocalURLs) {
                url = ModuleImpl.convertToLocalUrl(url);
            }
            return url;
        }

        protected URL findResource(String name) {
            return ModuleImpl.this.getResourceLocal(name);
        }

        protected Enumeration findResources(String name) {
            Enumeration urls = ModuleImpl.this.getResourcesByDelegation(name);
            if (ModuleImpl.this.m_useLocalURLs) {
                urls = new ToLocalUrlEnumeration(urls);
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String findLibrary(String name) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            String result = null;
            ModuleClassLoader moduleClassLoader = this;
            synchronized (moduleClassLoader) {
                for (int i = 0; result == null && i < this.m_cachedLibs.length; ++i) {
                    if (!this.m_cachedLibs[i][0].equals(name)) continue;
                    result = (String)this.m_cachedLibs[i][1];
                }
                if (result == null) {
                    List<R4Library> libs = ModuleImpl.this.getNativeLibraries();
                    for (int libIdx = 0; libs != null && libIdx < libs.size(); ++libIdx) {
                        if (!libs.get(libIdx).match(ModuleImpl.this.m_configMap, name)) continue;
                        result = ModuleImpl.this.getContent().getEntryAsNativeLibrary(libs.get(libIdx).getEntryName());
                        for (int i = 0; result == null && ModuleImpl.this.m_fragmentContents != null && i < ModuleImpl.this.m_fragmentContents.length; ++i) {
                            result = ModuleImpl.this.m_fragmentContents[i].getEntryAsNativeLibrary(libs.get(libIdx).getEntryName());
                        }
                    }
                    if (result != null) {
                        Object[][] tmp = new Object[this.m_cachedLibs.length + 1][];
                        System.arraycopy(this.m_cachedLibs, 0, tmp, 0, this.m_cachedLibs.length);
                        tmp[this.m_cachedLibs.length] = new Object[]{name, result};
                        this.m_cachedLibs = tmp;
                    }
                }
            }
            return result;
        }

        public String toString() {
            return ModuleImpl.this.toString();
        }
    }

    public class ModuleClassLoaderJava5
    extends ModuleClassLoader {
        public ModuleClassLoaderJava5(ClassLoader parent) {
            super(parent);
        }

        public Enumeration getResources(String name) {
            Enumeration urls = ModuleImpl.this.getResourcesByDelegation(name);
            if (ModuleImpl.this.m_useLocalURLs) {
                urls = new ToLocalUrlEnumeration(urls);
            }
            return urls;
        }

        protected Enumeration findResources(String name) {
            return ModuleImpl.this.getResourcesLocal(name);
        }
    }
}

