/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.noos.common.Question;
import org.noos.common.context.MutableContext;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerListener;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManagerListener;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowBar;
import org.noos.xing.mydoggy.ToolWindowGroup;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.ToolWindowManagerListener;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.event.ContentManagerEvent;
import org.noos.xing.mydoggy.event.ToolWindowManagerEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyContent;
import org.noos.xing.mydoggy.plaf.MyDoggyContentManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowGroup;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultDockedTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultFloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultFloatingTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultSlidingTypeDescriptor;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLPersistenceDelegate;
import org.noos.xing.mydoggy.plaf.support.CleanablePropertyChangeSupport;
import org.noos.xing.mydoggy.plaf.support.ResolvableHashtable;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.CornerPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.DebugSplitPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingDialog;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingFrame;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingLivePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingLiveWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.GlassPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ShortcutProcessor;
import org.noos.xing.mydoggy.plaf.ui.content.ContentDescriptor;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyTabbedContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.drag.ContentManagerDropTarget;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.look.MyDoggyResourceManager;
import org.noos.xing.mydoggy.plaf.ui.util.DockableManager2ToolWindowManagerWrapper;
import org.noos.xing.mydoggy.plaf.ui.util.SourceFilterPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyToolWindowManager
extends JPanel
implements ToolWindowManager,
PropertyChangeListener {
    protected final Object sync = new Object();
    protected ToolWindowGroup showingGroup;
    protected MyDoggyContentManager contentManager;
    protected Component windowAncestor;
    protected RootPaneContainer rootPaneContainer;
    protected MyDoggyToolWindowBar[] bars;
    protected Map<Object, ToolWindowDescriptor> tools;
    protected Map<Object, ToolWindowGroup> toolWindowGroups;
    protected Map<Object, ToolWindow> aliases;
    protected Map<String, DockableDescriptor> dockableDescriptorMap;
    protected ToolWindowGroup allToolWindowGroup;
    protected TableLayout contentPaneLayout;
    protected JSplitPane mainSplitPane;
    protected JPanel mainContainer;
    protected MultiSplitDockableContainer toolDockableContainer;
    protected CleanablePropertyChangeSupport propertyChangeSupport;
    protected Object activeToolWindowId;
    protected GlassPanel glassPanel;
    protected Component lastFocusOwner = null;
    protected PersistenceDelegate persistenceDelegate;
    protected DefaultFloatingTypeDescriptor floatingTypeDescriptor;
    protected DefaultDockedTypeDescriptor dockingTypeDescriptor;
    protected DefaultSlidingTypeDescriptor slidingTypeDescriptor;
    protected DefaultFloatingLiveTypeDescriptor floatingLiveTypeDescriptor;
    protected ToolWindowManagerDescriptor toolWindowManagerDescriptor;
    protected EventListenerList twmListeners;
    protected ClassLoader uiClassLoader;
    protected ResourceManagerListener resourceManagerListener;
    protected transient ResourceManager resourceManager;
    protected Component oldMainContent = null;
    protected boolean dockableMainContentMode = false;
    protected CornerPanel nordWestCorner;
    protected CornerPanel nordEastCorner;
    protected CornerPanel southWestCorner;
    protected CornerPanel southEastCorner;
    protected Map<ToolWindow, FloatingLiveWindow> livePanelMap = new HashMap<ToolWindow, FloatingLiveWindow>();
    protected Map<ToolWindow, FloatingWindow> floatingWindowMap = new HashMap<ToolWindow, FloatingWindow>();
    protected boolean firePublic = true;
    protected Question<Object, Boolean> firePublicEvent;

    public MyDoggyToolWindowManager() {
        this(Locale.getDefault(), null);
    }

    public MyDoggyToolWindowManager(Locale locale, ClassLoader uiClassLoader) {
        this.uiClassLoader = uiClassLoader;
        this.allToolWindowGroup = new AllToolWindowGroup();
        this.aliases = new HashMap<Object, ToolWindow>();
        this.dockableDescriptorMap = new HashMap<String, DockableDescriptor>();
        this.propertyChangeSupport = new CleanablePropertyChangeSupport(this);
        this.toolWindowManagerDescriptor = new MyDoggyToolWindowManagerDescriptor(this);
        this.toolWindowManagerDescriptor.addPropertyChangeListener(this);
        this.initUI(locale);
        this.initPersistenceDelegate();
        this.initComponents();
        this.initListeners();
    }

    public ToolWindow[] getDockables() {
        return this.getToolWindows();
    }

    @Override
    public ToolWindow getDockableById(String id) {
        return this.getToolWindow(id);
    }

    @Override
    public void addAlias(ToolWindow toolWindow, Object alias) {
        if (this.tools.containsKey(alias)) {
            throw new IllegalArgumentException("There is a tool whose id is the passed alias. Cannot add that alias.");
        }
        this.aliases.put(alias, toolWindow);
    }

    @Override
    public Object[] getAliases(ToolWindow toolWindow) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, ToolWindow> entry : this.aliases.entrySet()) {
            if (entry.getValue() != toolWindow) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    @Override
    public ToolWindow removeAlias(Object alias) {
        return this.aliases.remove(alias);
    }

    @Override
    public void addDockableManagerListener(DockableManagerListener listener) {
        this.addToolWindowManagerListener(new DockableManager2ToolWindowManagerWrapper(listener));
    }

    @Override
    public void removeDockableManagerListener(DockableManagerListener listener) {
        for (ToolWindowManagerListener managerListener : this.getToolWindowManagerListeners()) {
            if (!(managerListener instanceof DockableManager2ToolWindowManagerWrapper) || ((DockableManager2ToolWindowManagerWrapper)managerListener).getListener() != listener) continue;
            this.removeToolWindowManagerListener(managerListener);
        }
    }

    @Override
    public DockableManagerListener[] getDockableManagerListeners() {
        ArrayList<DockableManagerListener> listeners = new ArrayList<DockableManagerListener>();
        for (ToolWindowManagerListener managerListener : this.getToolWindowManagerListeners()) {
            if (!(managerListener instanceof DockableManager2ToolWindowManagerWrapper)) continue;
            listeners.add(((DockableManager2ToolWindowManagerWrapper)managerListener).getListener());
        }
        return listeners.toArray(new DockableManagerListener[listeners.size()]);
    }

    @Override
    public ContentManager getContentManager() {
        return this.contentManager;
    }

    @Override
    public ToolWindowManagerDescriptor getToolWindowManagerDescriptor() {
        return this.toolWindowManagerDescriptor;
    }

    @Override
    public PersistenceDelegate getPersistenceDelegate() {
        return this.persistenceDelegate;
    }

    @Override
    public ToolWindow registerToolWindow(String id, String title, Icon icon, Component component, ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot register tool window with an invalid id. Id cannot be null.");
        }
        if (component == null) {
            throw new IllegalArgumentException("Cannot register tool window with a null component. [id : " + id + "]");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Cannot register tool window with a null anchor. [id : " + id + "]");
        }
        int index = this.tools.size() + 1;
        if (index > 9) {
            index = -1;
        }
        if (this.lookupDockable(id) != null) {
            throw new IllegalArgumentException("Cannot register tool window with passed id. An already registered dockable exists. [id : " + id + "]");
        }
        MyDoggyToolWindow toolWindow = new MyDoggyToolWindow(this, id, index, anchor, ToolWindowType.DOCKED, title, icon, component);
        toolWindow.addPlafPropertyChangeListener(this);
        toolWindow.getRepresentativeAnchorDescriptor().addPropertyChangeListener(this);
        this.fireRegisteredToolEvent(toolWindow);
        return toolWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterToolWindow(String id) {
        ToolWindowDescriptor toolWindowDescriptor = this.tools.get(id);
        if (toolWindowDescriptor == null) throw new IllegalArgumentException("Doesn't exist a tool window with passed id. [id : " + id + "]");
        MyDoggyToolWindow toolWindow = toolWindowDescriptor.getToolWindow();
        try {
            try {
                this.removeIfDockableDelegator(toolWindow);
                if (toolWindow.getType() != ToolWindowType.FLOATING_FREE) {
                    toolWindow.getRepresentativeAnchorDescriptor().setVisible(false);
                }
                toolWindow.setFlashing(false);
                toolWindow.setMaximized(false);
                toolWindow.setAvailable(false);
                for (ToolWindowTab toolWindowTab : toolWindowDescriptor.getToolWindow().getToolWindowTabs()) {
                    toolWindow.removeToolWindowTab(toolWindowTab);
                }
                Object var9_9 = null;
                this.tools.remove(toolWindowDescriptor.getToolWindow().getId());
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var9_10 = null;
                this.tools.remove(toolWindowDescriptor.getToolWindow().getId());
                this.dockableDescriptorMap.remove(toolWindowDescriptor.getToolWindow().getId());
                Iterator<ToolWindow> iterator = this.aliases.values().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.fireUnregisteredToolEvent(toolWindowDescriptor.getToolWindow());
                        toolWindowDescriptor.cleanup();
                        return;
                    }
                    ToolWindow aliasedToolWindow = iterator.next();
                    if (aliasedToolWindow != toolWindow) continue;
                    iterator.remove();
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.tools.remove(toolWindowDescriptor.getToolWindow().getId());
            this.dockableDescriptorMap.remove(toolWindowDescriptor.getToolWindow().getId());
            Iterator<ToolWindow> iterator = this.aliases.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.fireUnregisteredToolEvent(toolWindowDescriptor.getToolWindow());
                    toolWindowDescriptor.cleanup();
                    throw throwable;
                }
                ToolWindow aliasedToolWindow = iterator.next();
                if (aliasedToolWindow != toolWindow) continue;
                iterator.remove();
            }
        }
        this.dockableDescriptorMap.remove(toolWindowDescriptor.getToolWindow().getId());
        Iterator<ToolWindow> iterator = this.aliases.values().iterator();
        while (iterator.hasNext()) {
            ToolWindow aliasedToolWindow = iterator.next();
            if (aliasedToolWindow != toolWindow) continue;
            iterator.remove();
        }
        this.fireUnregisteredToolEvent(toolWindowDescriptor.getToolWindow());
        toolWindowDescriptor.cleanup();
    }

    @Override
    public void unregisterAllToolWindow() {
        for (ToolWindow toolWindow : this.getToolWindows()) {
            this.unregisterToolWindow(toolWindow.getId());
        }
        this.aliases.clear();
    }

    @Override
    public ToolWindow getToolWindowByAlias(Object alias) {
        return this.aliases.get(alias);
    }

    @Override
    public ToolWindow[] getToolWindows() {
        ArrayList<MyDoggyToolWindow> result = new ArrayList<MyDoggyToolWindow>();
        for (ToolWindowDescriptor tool : this.tools.values()) {
            result.add(tool.getToolWindow());
        }
        return result.toArray(new ToolWindow[result.size()]);
    }

    @Override
    public Object getActiveToolWindowId() {
        return this.activeToolWindowId;
    }

    @Override
    public ToolWindow getToolWindow(Object key) {
        if (key == null) {
            return null;
        }
        ToolWindowDescriptor descriptor = this.tools.get(key);
        if (descriptor == null) {
            return this.aliases.get(key);
        }
        return descriptor.getToolWindow();
    }

    @Override
    public ToolWindow getToolWindow(int index) {
        if (index != -1 && index <= 0 && index > 9) {
            throw new IllegalArgumentException("Invalid index. Valid index range is [-1, 1-9]. [index : " + index + "]");
        }
        for (ToolWindow toolWindow : this.getToolWindows()) {
            if (toolWindow.getIndex() != index) continue;
            return toolWindow;
        }
        return null;
    }

    @Override
    public ToolWindow[] getToolsByAnchor(ToolWindowAnchor anchor) {
        ArrayList<MyDoggyToolWindow> result = new ArrayList<MyDoggyToolWindow>();
        for (ToolWindowDescriptor tool : this.tools.values()) {
            if (!tool.getToolWindow().getAnchor().equals((Object)anchor)) continue;
            result.add(tool.getToolWindow());
        }
        return result.toArray(new ToolWindow[result.size()]);
    }

    @Override
    public ToolWindowGroup getToolWindowGroup() {
        return this.allToolWindowGroup;
    }

    @Override
    public ToolWindowGroup getToolWindowGroup(String name) {
        return this.toolWindowGroups.get(name);
    }

    @Override
    public ToolWindowGroup[] getToolWindowGroups() {
        Collection<ToolWindowGroup> c = this.toolWindowGroups.values();
        return c.toArray(new ToolWindowGroup[c.size()]);
    }

    @Override
    public boolean removeToolWindowGroup(String name) {
        if (name == null) {
            return false;
        }
        ToolWindowGroup group = this.toolWindowGroups.remove(name);
        if (group != null) {
            this.fireRemovedGroupEvent(group);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeToolWindowGroup(ToolWindowGroup toolWindowGroup) {
        return toolWindowGroup != null && this.removeToolWindowGroup(toolWindowGroup.getName());
    }

    @Override
    public boolean containsGroup(String name) {
        return this.allToolWindowGroup.getName().equals(name) || this.toolWindowGroups.containsKey(name);
    }

    @Override
    public ToolWindowTypeDescriptor getTypeDescriptorTemplate(ToolWindowType type) {
        switch (type) {
            case FLOATING: 
            case FLOATING_FREE: {
                if (this.floatingTypeDescriptor == null) {
                    this.floatingTypeDescriptor = new DefaultFloatingTypeDescriptor();
                }
                return this.floatingTypeDescriptor;
            }
            case FLOATING_LIVE: {
                if (this.floatingLiveTypeDescriptor == null) {
                    this.floatingLiveTypeDescriptor = new DefaultFloatingLiveTypeDescriptor();
                }
                return this.floatingLiveTypeDescriptor;
            }
            case DOCKED: {
                if (this.dockingTypeDescriptor == null) {
                    this.dockingTypeDescriptor = new DefaultDockedTypeDescriptor();
                }
                return this.dockingTypeDescriptor;
            }
            case SLIDING: {
                if (this.slidingTypeDescriptor == null) {
                    this.slidingTypeDescriptor = new DefaultSlidingTypeDescriptor();
                }
                return this.slidingTypeDescriptor;
            }
        }
        throw new IllegalStateException("Doen't exist a TypeDescriptor for. [type :" + (Object)((Object)type) + "]");
    }

    @Override
    public Dockable lookupDockable(Object key) {
        Dockable<ToolWindowManager> result = this.getToolWindow(key);
        if (result == null) {
            for (ToolWindow toolWindow : this.getToolWindows()) {
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (!tab.getId().equals(key)) continue;
                    result = tab;
                    break;
                }
                if (result != null) break;
            }
            if (result == null) {
                result = this.getContentManager().getContent(key);
            }
        }
        return result;
    }

    @Override
    public ToolWindowBar getToolWindowBar(ToolWindowAnchor anchor) {
        return this.getBar(anchor);
    }

    @Override
    public void addToolWindowManagerListener(ToolWindowManagerListener listener) {
        this.twmListeners.add(ToolWindowManagerListener.class, listener);
    }

    @Override
    public void removeToolWindowManagerListener(ToolWindowManagerListener listener) {
        this.twmListeners.remove(ToolWindowManagerListener.class, listener);
    }

    @Override
    public ToolWindowManagerListener[] getToolWindowManagerListeners() {
        return (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof DockableDescriptor) {
            DockableDescriptor descriptor = (DockableDescriptor)source;
            if (descriptor.getDockableType() != DockableDescriptor.DockableType.CUSTOM && this.lookupDockable(descriptor.getDockable().getId()) != descriptor.getDockable()) {
                throw new RuntimeException("Manager doesn't contain that ToolWindow. [id : " + descriptor.getDockable().getId() + "]");
            }
        } else if (!(source instanceof Dockable || source instanceof MyDoggyToolWindowBar || source instanceof MyDoggyToolWindowManagerDescriptor || source instanceof MyDoggyToolWindowManager || source instanceof MyDoggyToolWindowTab || source instanceof ToolWindowTypeDescriptor || source instanceof ContentManager || source instanceof RepresentativeAnchorDescriptor)) {
            throw new RuntimeException("Illegal Source : " + source);
        }
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.windowAncestor = SwingUtil.getWindowAncestor(this);
        if (!(this.windowAncestor instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window Ancestor must implement RootPaneContainer");
        }
        this.rootPaneContainer = (RootPaneContainer)((Object)this.windowAncestor);
        this.propertyChangeSupport.firePropertyChange("managerWindowAncestor", null, this.windowAncestor);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (ToolWindow toolWindow : this.getToolWindows()) {
            if (toolWindow.getType() != ToolWindowType.FLOATING || !toolWindow.isVisible()) continue;
            toolWindow.setVisible(false);
        }
        for (Dockable<ToolWindowManager> dockable : this.getContentManager().getContents()) {
            dockable.setDetached(false);
        }
        this.propertyChangeSupport.firePropertyChange("managerWindowAncestor", this.windowAncestor, null);
        this.windowAncestor = null;
        this.rootPaneContainer = null;
        if (this.glassPanel != null) {
            this.glassPanel.reset();
            this.glassPanel = null;
        }
    }

    public Component getWindowAncestor() {
        return this.windowAncestor;
    }

    public JLayeredPane getLayeredPane() {
        return this.rootPaneContainer != null ? this.rootPaneContainer.getLayeredPane() : null;
    }

    public RootPaneContainer getRootPaneContainer() {
        return this.rootPaneContainer;
    }

    public void setPersistenceDelegate(PersistenceDelegate persistenceDelegate) {
        this.persistenceDelegate = persistenceDelegate;
    }

    public void setUserResourceBundle(Locale locale, String bundle, ClassLoader classLoader) {
        this.resourceManager.setUserBundle(locale, bundle, classLoader);
    }

    public void setMainSplitPane(ToolWindowAnchor anchor) {
        switch (anchor) {
            case LEFT: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setRightComponent(this.mainContainer);
                break;
            }
            case RIGHT: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setLeftComponent(this.mainContainer);
                break;
            }
            case TOP: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setBottomComponent(this.mainContainer);
                break;
            }
            case BOTTOM: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setTopComponent(this.mainContainer);
            }
        }
    }

    public MyDoggyToolWindowBar getBar(ToolWindowAnchor anchor) {
        return this.bars[anchor.ordinal()];
    }

    public MyDoggyToolWindowBar[] getBars() {
        return this.bars;
    }

    public Collection<ToolWindowDescriptor> getToolWindowDescriptors() {
        return this.tools.values();
    }

    public ToolWindowGroup getShowingGroup() {
        return this.showingGroup;
    }

    public ToolWindowDescriptor getDescriptor(ToolWindow toolWindow) {
        return this.tools.get(toolWindow.getId());
    }

    public void setCornerComponent(ToolWindowManagerDescriptor.Corner corner, Component component) {
        switch (corner) {
            case NORD_WEST: {
                this.nordWestCorner.setComponent(component);
                break;
            }
            case SOUTH_WEST: {
                this.southWestCorner.setComponent(component);
                break;
            }
            case NORD_EAST: {
                this.nordEastCorner.setComponent(component);
                break;
            }
            case SOUTH_EAST: {
                this.southEastCorner.setComponent(component);
            }
        }
    }

    public GlassPanel getGlassPanel() {
        return this.glassPanel;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        if (this.resourceManager != null) {
            this.resourceManager.removePropertyChangeListener(this.resourceManagerListener);
        }
        if (this.resourceManagerListener == null) {
            this.resourceManagerListener = new ResourceManagerListener();
        }
        this.resourceManager = resourceManager;
        resourceManager.addPropertyChangeListener(this.resourceManagerListener);
        resourceManager.setClassloader(this.uiClassLoader);
        this.propertyChange(new PropertyChangeEvent(this, "resourceManager", null, resourceManager));
    }

    public ToolWindowAnchor getToolWindowAnchor(Point p) {
        p = SwingUtil.convertPointFromScreen(p, this);
        Rectangle b = this.getBounds();
        int leftLength = this.getBar(ToolWindowAnchor.LEFT).getLength();
        int rightLength = this.getBar(ToolWindowAnchor.RIGHT).getLength();
        int topLength = this.getBar(ToolWindowAnchor.TOP).getLength();
        int bottomLength = this.getBar(ToolWindowAnchor.BOTTOM).getLength();
        if (p.x <= leftLength && p.y >= topLength && p.y <= b.height - bottomLength) {
            return ToolWindowAnchor.LEFT;
        }
        if (p.x >= b.width - rightLength && p.y >= topLength && p.y <= b.height - bottomLength) {
            return ToolWindowAnchor.RIGHT;
        }
        if (p.y <= topLength && p.x >= leftLength && p.x <= b.width - rightLength) {
            return ToolWindowAnchor.TOP;
        }
        if (p.y >= b.height - bottomLength && p.x >= leftLength && p.x <= b.width - rightLength) {
            return ToolWindowAnchor.BOTTOM;
        }
        return null;
    }

    public void removeIfDockableDelegator(Dockable dockable) {
        block0: for (ToolWindow toolWindow : this.getToolWindows()) {
            for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                if (tab.getDockableDelegator() != dockable) continue;
                toolWindow.removeToolWindowTab(tab);
                continue block0;
            }
        }
        for (Dockable<ToolWindowManager> dockable2 : this.contentManager.getContents()) {
            if (dockable2.getDockableDelegator() != dockable) continue;
            this.contentManager.removeContent((Content)dockable2);
            break;
        }
    }

    public void addInternalPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void removeInternalPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    public void addRemoveNotifyListener(PropertyChangeListener listener) {
        this.addInternalPropertyChangeListener("managerWindowAncestor", listener);
    }

    public void removeRemoveNotifyListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener("managerWindowAncestor", listener);
    }

    public void setMainContent(Component content) {
        if (content == null) {
            this.resetMainContent();
        } else if (this.dockableMainContentMode) {
            this.oldMainContent = content;
        } else {
            this.mainContainer.setOpaque(false);
            this.mainContainer.removeAll();
            this.mainContainer.add(content, "0,0,FULL,FULL");
            this.mainSplitPane.invalidate();
            this.mainSplitPane.validate();
            SwingUtil.repaint(this.mainSplitPane);
        }
    }

    public void resetMainContent() {
        if (this.dockableMainContentMode) {
            this.oldMainContent = null;
        } else {
            this.mainContainer.removeAll();
            SwingUtil.repaint(this.mainSplitPane);
            this.mainContainer.setOpaque(true);
        }
    }

    public Container getMainContainer() {
        return this.mainContainer;
    }

    public Component getMainContent() {
        return this.mainContainer.getComponentCount() == 0 ? null : this.mainContainer.getComponent(0);
    }

    public void setDockableMainContentMode(boolean enable) {
        if (enable) {
            this.toolDockableContainer = new MultiSplitDockableContainer(this, 0);
            this.toolDockableContainer.setStoreLayout(false);
            ToolDockableDropPanel dockableDropPanel = new ToolDockableDropPanel();
            dockableDropPanel.setComponent(this.toolDockableContainer);
            this.oldMainContent = this.getMainContent();
            this.setMainContent(dockableDropPanel);
            this.dockableMainContentMode = true;
        } else {
            this.dockableMainContentMode = false;
            this.setMainContent(this.oldMainContent);
        }
    }

    public Rectangle getBoundsToScreen(Rectangle bounds, Component ref) {
        Point location = bounds.getLocation();
        SwingUtil.convertPointToScreen(location, ref);
        bounds.setLocation(location);
        bounds.y += this.getJMenuBarExtraHeight();
        return bounds;
    }

    public Question<Object, Boolean> getFirePublicEvent() {
        if (this.firePublicEvent == null) {
            this.firePublicEvent = new Question<Object, Boolean>(){

                @Override
                public Boolean getAnswer(Object param) {
                    return MyDoggyToolWindowManager.this.firePublic;
                }
            };
        }
        return this.firePublicEvent;
    }

    protected void initPersistenceDelegate() {
        this.persistenceDelegate = new XMLPersistenceDelegate(this);
    }

    protected void initContentManager() {
        this.contentManager = new MyDoggyContentManager(this);
        this.contentManager.setContentManagerUI(new MyDoggyTabbedContentManagerUI());
        this.contentManager.addPropertyChangeListener(this);
        this.contentManager.addContentManagerListener(new InternalContentMananagerListener());
    }

    protected void initUI(Locale locale) {
        ResourceManager resourceManager;
        Properties properties = SwingUtil.loadPropertiesFile("mydoggyplaf.properties", this.uiClassLoader);
        String className = properties.getProperty("ResourceManager.class");
        if (className == null) {
            System.err.println("Cannot find ResourceManager.class property value. Use default.");
            className = MyDoggyResourceManager.class.getName();
        }
        try {
            resourceManager = (ResourceManager)SwingUtil.newObject(this.uiClassLoader, className);
        }
        catch (Exception e) {
            e.printStackTrace();
            resourceManager = new MyDoggyResourceManager();
        }
        resourceManager.setClassloader(this.uiClassLoader);
        resourceManager.setLocale(locale);
        this.setResourceManager(resourceManager);
    }

    protected void initComponents() {
        this.twmListeners = new EventListenerList();
        this.initContentManager();
        this.bars = new MyDoggyToolWindowBar[4];
        this.tools = new LinkedHashMap<Object, ToolWindowDescriptor>();
        this.toolWindowGroups = new ResolvableHashtable<Object, ToolWindowGroup>(new ResolvableHashtable.Resolver<ToolWindowGroup>(){

            @Override
            public ToolWindowGroup get(Object key) {
                MyDoggyToolWindowGroup group = new MyDoggyToolWindowGroup(MyDoggyToolWindowManager.this, key.toString(), false);
                MyDoggyToolWindowManager.this.toolWindowGroups.put(key, group);
                MyDoggyToolWindowManager.this.fireAddedGroupEvent(group);
                return group;
            }
        });
        this.contentPaneLayout = new ExtendedTableLayout(new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}});
        this.setLayout(this.contentPaneLayout);
        this.nordWestCorner = new CornerPanel(ToolWindowManagerDescriptor.Corner.NORD_WEST);
        this.add((Component)this.nordWestCorner, "0,0,c,c");
        this.southWestCorner = new CornerPanel(ToolWindowManagerDescriptor.Corner.SOUTH_WEST);
        this.add((Component)this.southWestCorner, "0,2,c,c");
        this.nordEastCorner = new CornerPanel(ToolWindowManagerDescriptor.Corner.NORD_EAST);
        this.add((Component)this.nordEastCorner, "2,0,c,c");
        this.southEastCorner = new CornerPanel(ToolWindowManagerDescriptor.Corner.SOUTH_EAST);
        this.add((Component)this.southEastCorner, "2,2,c,c");
        this.addBar(ToolWindowAnchor.LEFT, 1, "0,1");
        this.addBar(ToolWindowAnchor.RIGHT, 1, "2,1");
        this.addBar(ToolWindowAnchor.TOP, 0, "1,0");
        this.addBar(ToolWindowAnchor.BOTTOM, 0, "1,2");
        this.mainContainer = new JPanel();
        this.mainContainer.setOpaque(true);
        this.mainContainer.setBackground(Color.GRAY);
        this.mainContainer.setName("toolWindowManager.mainContainer");
        this.mainContainer.setLayout(new ExtendedTableLayout(new double[][]{{-1.0}, {-1.0}}));
        this.mainContainer.setFocusable(false);
        this.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setTopComponent(this.getBar(ToolWindowAnchor.TOP).getSplitPane());
        this.getBar(ToolWindowAnchor.TOP).getSplitPane().setBottomComponent(this.getBar(ToolWindowAnchor.LEFT).getSplitPane());
        this.getBar(ToolWindowAnchor.LEFT).getSplitPane().setRightComponent(this.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
        this.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setResizeWeight(1.0);
        this.add((Component)this.getBar(ToolWindowAnchor.BOTTOM).getSplitPane(), "1,1,FULL,FULL");
        this.mainSplitPane = this.getBar(ToolWindowAnchor.RIGHT).getSplitPane();
        this.mainSplitPane.addPropertyChangeListener("UI", new UpdateUIChangeListener());
        this.mainSplitPane.setLeftComponent(this.mainContainer);
    }

    protected void initGlassPane() {
        this.glassPanel = new GlassPanel(this.rootPaneContainer);
    }

    protected void initListeners() {
        AvailablePropertyChangeListener availablePropertyChangeListener = new AvailablePropertyChangeListener();
        this.propertyChangeSupport.addPropertyChangeListener("available", availablePropertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("visible", new SourceFilterPropertyChangeListener(availablePropertyChangeListener, RepresentativeAnchorDescriptor.class));
        this.propertyChangeSupport.addPropertyChangeListener("showUnavailableTools", new ShowUnavailableToolsPropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible", new SourceFilterPropertyChangeListener(new VisiblePropertyChangeListener(), ToolWindow.class));
        this.propertyChangeSupport.addPropertyChangeListener("visible", new SourceFilterPropertyChangeListener(new ToolBarVisiblePropertyChangeListener(), ToolWindowBar.class));
        this.propertyChangeSupport.addPropertyChangeListener("active", new ActivePropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("anchor", new AnchorPropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("type", new TypePropertyChangeListener());
        MaximizedChangeListener maximizedChangeListener = new MaximizedChangeListener();
        this.propertyChangeSupport.addPropertyChangeListener("maximized", maximizedChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("maximizedBefore", maximizedChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("index", new IndexChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("icon", new IconChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("temporarilyVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.propertyChangeSupport.addPropertyChangeListener("anchor.index", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ToolWindow sourceTool = (ToolWindow)evt.getSource();
                if (sourceTool.getType() == ToolWindowType.DOCKED) {
                    MyDoggyToolWindowManager.this.getBar(sourceTool.getAnchor()).propertyChange(evt);
                }
            }
        });
        this.propertyChangeSupport.addPropertyChangeListener("enabled", new ContentMananagerEnabledChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("length", new BarLengthListener());
        this.initKeyboardFocusManagerListeners();
        this.mainContainer.setDropTarget(new ContentManagerDropTarget(this.mainContainer, this));
    }

    protected void initKeyboardFocusManagerListeners() {
        this.propertyChangeSupport.addPropertyChangeListener("managerWindowAncestor", new PropertyChangeListener(){
            final ShortcutProcessor shortcutProcessor;
            final FocusOwnerChangeListener focusOwnerChangeListener;
            {
                this.shortcutProcessor = new ShortcutProcessor(MyDoggyToolWindowManager.this, MyDoggyToolWindowManager.this);
                this.focusOwnerChangeListener = new FocusOwnerChangeListener();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (evt.getNewValue() != null) {
                    keyboardFocusManager.addKeyEventPostProcessor(this.shortcutProcessor);
                    keyboardFocusManager.addPropertyChangeListener("focusOwner", this.focusOwnerChangeListener);
                    MyDoggyToolWindowManager.this.initGlassPane();
                } else {
                    keyboardFocusManager.removeKeyEventPostProcessor(this.shortcutProcessor);
                    keyboardFocusManager.removePropertyChangeListener("focusOwner", this.focusOwnerChangeListener);
                    for (PropertyChangeListener listener : keyboardFocusManager.getPropertyChangeListeners("focusOwner")) {
                        if (!listener.getClass().getPackage().getName().startsWith(MyDoggyToolWindowManager.this.getClass().getPackage().getName())) continue;
                        keyboardFocusManager.removePropertyChangeListener("focusOwner", listener);
                    }
                }
            }
        });
    }

    protected JSplitPane renderSplitPane(int orientation) {
        DebugSplitPane splitPane = new DebugSplitPane(orientation);
        splitPane.setBorder(null);
        splitPane.setContinuousLayout(true);
        splitPane.setDividerSize(0);
        ((JSplitPane)splitPane).setDividerLocation(300);
        splitPane.setLeftComponent(null);
        splitPane.setRightComponent(null);
        return splitPane;
    }

    protected JSplitPane addBar(ToolWindowAnchor anchor, int splitPaneOrientation, String barConstraints) {
        MyDoggyToolWindowBar myDoggyToolWindowBar = new MyDoggyToolWindowBar(this, this.renderSplitPane(splitPaneOrientation), anchor);
        myDoggyToolWindowBar.addPropertyChangeListener(this);
        this.bars[anchor.ordinal()] = myDoggyToolWindowBar;
        this.add((Component)myDoggyToolWindowBar.getContainer(), barConstraints);
        return myDoggyToolWindowBar.getSplitPane();
    }

    protected void fireRegisteredToolEvent(ToolWindow toolWindow) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.TOOL_REGISTERED, toolWindow);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowRegistered(event);
        }
    }

    protected void fireUnregisteredToolEvent(ToolWindow toolWindow) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.TOOL_UNREGISTERED, toolWindow);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowUnregistered(event);
        }
    }

    protected void fireAddedGroupEvent(ToolWindowGroup toolWindowGroup) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.GROUP_ADDED, toolWindowGroup);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowGroupAdded(event);
        }
    }

    protected void fireRemovedGroupEvent(ToolWindowGroup toolWindowGroup) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.GROUP_REMOVED, toolWindowGroup);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowGroupRemoved(event);
        }
    }

    void syncPanel(ToolWindowAnchor anchor) {
        boolean revalidate = false;
        MyDoggyToolWindowBar toolWindowBar = this.getBar(anchor);
        if (anchor == ToolWindowAnchor.LEFT) {
            if (!toolWindowBar.isVisible()) {
                this.contentPaneLayout.setColumn(0, 0.0);
                revalidate = true;
            } else if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTemporarilyVisible() && this.contentPaneLayout.getColumn(0) != 0.0) {
                this.contentPaneLayout.setColumn(0, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTemporarilyVisible()) && this.contentPaneLayout.getColumn(0) == 0.0) {
                this.contentPaneLayout.setColumn(0, this.getBar(ToolWindowAnchor.LEFT).getLength());
                revalidate = true;
            }
        } else if (anchor == ToolWindowAnchor.RIGHT) {
            if (!toolWindowBar.isVisible()) {
                this.contentPaneLayout.setColumn(2, 0.0);
                revalidate = true;
            } else if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTemporarilyVisible() && this.contentPaneLayout.getColumn(2) != 0.0) {
                this.contentPaneLayout.setColumn(2, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTemporarilyVisible()) && this.contentPaneLayout.getColumn(2) == 0.0) {
                this.contentPaneLayout.setColumn(2, this.getBar(ToolWindowAnchor.RIGHT).getLength());
                revalidate = true;
            }
        } else if (anchor == ToolWindowAnchor.TOP) {
            if (!toolWindowBar.isVisible()) {
                this.contentPaneLayout.setRow(0, 0.0);
                revalidate = true;
            } else if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTemporarilyVisible() && this.contentPaneLayout.getRow(0) != 0.0) {
                this.contentPaneLayout.setRow(0, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTemporarilyVisible()) && this.contentPaneLayout.getRow(0) == 0.0) {
                this.contentPaneLayout.setRow(0, this.getBar(ToolWindowAnchor.TOP).getLength());
                revalidate = true;
            }
        } else if (anchor == ToolWindowAnchor.BOTTOM) {
            if (!toolWindowBar.isVisible()) {
                this.contentPaneLayout.setRow(2, 0.0);
                revalidate = true;
            } else if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTemporarilyVisible() && this.contentPaneLayout.getRow(2) != 0.0) {
                this.contentPaneLayout.setRow(2, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTemporarilyVisible()) && this.contentPaneLayout.getRow(2) == 0.0) {
                this.contentPaneLayout.setRow(2, this.getBar(ToolWindowAnchor.BOTTOM).getLength());
                revalidate = true;
            }
        }
        if (revalidate) {
            SwingUtil.repaint(this);
        }
    }

    void setShowingGroup(ToolWindowGroup toolWindowGroup) {
        this.showingGroup = toolWindowGroup;
    }

    void setShowingGroup() {
        if (this.showingGroup == null) {
            this.setShowingGroup(this.allToolWindowGroup);
        }
    }

    void resetShowingGroup() {
        if (this.showingGroup == this.getToolWindowGroup()) {
            this.showingGroup = null;
        }
    }

    boolean isShowingGroup() {
        return this.showingGroup == this.allToolWindowGroup;
    }

    public boolean isWindowFocused() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focusOwner != null && SwingUtil.getWindowAncestor(focusOwner) == this.windowAncestor;
    }

    public int getJMenuBarExtraHeight() {
        if (this.getRootPane() == null) {
            return 0;
        }
        JMenuBar jMenuBar = this.getRootPane().getJMenuBar();
        if (jMenuBar != null && jMenuBar.isVisible()) {
            return jMenuBar.getHeight();
        }
        return 0;
    }

    public DockableDescriptor getDockableDescriptor(String id) {
        return this.dockableDescriptorMap.get(id);
    }

    public void putDockableDescriptor(String id, DockableDescriptor dockableDescriptor) {
        this.dockableDescriptorMap.put(id, dockableDescriptor);
    }

    public void removeDockableDescriptor(String id) {
        DockableDescriptor descriptor = this.dockableDescriptorMap.remove(id);
        if (descriptor != null) {
            descriptor.cleanup();
        }
    }

    public DockableDescriptor getDockableDescriptorBySource(Object source) {
        if (source instanceof Dockable) {
            return this.getDockableDescriptor(((Dockable)source).getId());
        }
        if (source instanceof DockableDescriptor) {
            return (DockableDescriptor)source;
        }
        if (source instanceof RepresentativeAnchorDescriptor) {
            return this.getDockableDescriptor(((RepresentativeAnchorDescriptor)source).getDockable().getId());
        }
        throw new IllegalArgumentException("Cannot recognize source!!");
    }

    public void setBarsTemporarilyVisible(boolean tempShown) {
        this.getBar(ToolWindowAnchor.LEFT).setTemporarilyVisible(tempShown);
        this.getBar(ToolWindowAnchor.RIGHT).setTemporarilyVisible(tempShown);
        this.getBar(ToolWindowAnchor.TOP).setTemporarilyVisible(tempShown);
        this.getBar(ToolWindowAnchor.BOTTOM).setTemporarilyVisible(tempShown);
    }

    public DockableDescriptor createDescriptor(Dockable dockable) {
        if (dockable instanceof ToolWindow) {
            ToolWindowDescriptor descriptor = new ToolWindowDescriptor(this, (MyDoggyToolWindow)dockable);
            this.tools.put(dockable.getId(), descriptor);
            this.dockableDescriptorMap.put(dockable.getId(), descriptor);
            return descriptor;
        }
        if (dockable instanceof Content) {
            return new ContentDescriptor(this, (Content)dockable);
        }
        throw new IllegalArgumentException("Invalid dockable. [dockable : " + dockable + "]");
    }

    public Dockable getDockableWrapper(Dockable dockable) {
        for (ToolWindow toolWindow : this.getToolWindows()) {
            for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                if (tab.getDockableDelegator() != dockable) continue;
                return tab;
            }
        }
        for (Dockable<ToolWindowManager> dockable2 : this.contentManager.getContents()) {
            if (dockable2.getDockableDelegator() != dockable) continue;
            return dockable2;
        }
        return null;
    }

    public MutableContext getContext() {
        DefaultMutableContext context = new DefaultMutableContext();
        context.put(ToolWindowManager.class, this);
        context.put(MyDoggyToolWindowManager.class, this);
        context.put(ResourceManager.class, this.getResourceManager());
        return context;
    }

    public MutableContext getContext(Object ... entries) {
        DefaultMutableContext context = new DefaultMutableContext(entries);
        context.put(ToolWindowManager.class, this);
        context.put(MyDoggyToolWindowManager.class, this);
        context.put(ResourceManager.class, this.getResourceManager());
        return context;
    }

    public void ensureContentVisible(Content content) {
        for (ToolWindowDescriptor t : this.tools.values()) {
            if (!t.getToolWindow().isMaximized() || t.isFloatingWindow() || t.getToolWindow().isDetached()) continue;
            t.getToolWindow().setMaximized(false);
        }
        if (this.mainContainer.getWidth() < 50 || this.mainContainer.getHeight() < 50) {
            this.mainSplitPane.setDividerLocation(0.5);
            for (MyDoggyToolWindowBar bar : this.bars) {
                bar.getSplitPane().setDividerLocation(0.5);
            }
        }
    }

    public FloatingLiveWindow getFloatingLiveWindow(ToolWindow toolWindow) {
        FloatingLiveWindow panel = this.livePanelMap.get(toolWindow);
        if (panel == null) {
            panel = new FloatingLivePanel(this);
            this.livePanelMap.put(toolWindow, panel);
        }
        return panel;
    }

    public void removeFloatingLiveWindow(ToolWindow toolWindow) {
        this.livePanelMap.remove(toolWindow);
    }

    public Collection<FloatingLiveWindow> getFloatingLiveWindows() {
        return this.livePanelMap.values();
    }

    public FloatingWindow getFloatingWindow(ToolWindow toolWindow) {
        FloatingWindow floatingWindow = this.floatingWindowMap.get(toolWindow);
        if (floatingWindow == null) {
            FloatingTypeDescriptor floatingTypeDescriptor = toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class);
            floatingWindow = floatingTypeDescriptor.isAddToTaskBar() ? new FloatingFrame(this, toolWindow, floatingTypeDescriptor.isAlwaysOnTop() ? (this.windowAncestor instanceof Window ? (Window)this.windowAncestor : null) : null, floatingTypeDescriptor.isModal()) : new FloatingDialog(this, floatingTypeDescriptor.isAlwaysOnTop() ? (this.windowAncestor instanceof Window ? (Window)this.windowAncestor : null) : null, floatingTypeDescriptor.isModal());
            floatingWindow.setName("toolWindow.floating.window." + toolWindow.getId());
            floatingWindow.setAlwaysOnTop(floatingTypeDescriptor.isAlwaysOnTop());
            floatingWindow.setUndecorated(!floatingTypeDescriptor.isOsDecorated());
            this.floatingWindowMap.put(toolWindow, floatingWindow);
        }
        return floatingWindow;
    }

    public void removeFloatingWindow(ToolWindow toolWindow) {
        FloatingWindow ft = this.floatingWindowMap.remove(toolWindow);
        if (ft != null) {
            ft.dispose();
        }
    }

    public Collection<FloatingWindow> getFloatingWindows() {
        return this.floatingWindowMap.values();
    }

    class AllToolWindowGroup
    extends MyDoggyToolWindowGroup {
        AllToolWindowGroup() {
            super(MyDoggyToolWindowManager.this, "all", false);
        }

        public void addToolWindow(ToolWindow toolWindow) {
            throw new IllegalStateException("Cannot call this method!!!");
        }

        public boolean removeToolWindow(ToolWindow toolWindow) {
            throw new IllegalStateException("Cannot call this method!!!");
        }

        public ToolWindow[] getToolsWindow() {
            return MyDoggyToolWindowManager.this.getToolWindows();
        }

        public boolean containesToolWindow(ToolWindow toolWindow) {
            return true;
        }

        public void setImplicit(boolean implicit) {
            throw new IllegalStateException("Cannot call this method on this instance.");
        }

        public boolean isImplicit() {
            return false;
        }

        public String toString() {
            return "MyDoggyToolWindowGroup{name='all', tools=" + this.tools + '}';
        }
    }

    public class ToolDockableDropPanel
    extends DockableDropPanel {
        public ToolDockableDropPanel() {
            super(ToolWindow.class, Content.class);
        }

        public boolean dragStart(Transferable transferable, int action) {
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(MyDoggyToolWindowManager.this)) && action == 2 && (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF))) {
                    return super.dragStart(transferable, action);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean drop(Transferable transferable) {
            block44: {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) {
                    try {
                        ToolWindow toolWindow = MyDoggyToolWindowManager.this.getToolWindow(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF));
                        if (toolWindow != null) {
                            ToolWindow onToolWindow;
                            int anchorIndex;
                            if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) {
                                ToolWindowTab tab = (ToolWindowTab)MyDoggyToolWindowManager.this.lookupDockable(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF));
                                tab.getOwner().removeToolWindowTab(tab);
                                toolWindow = (ToolWindow)tab.getDockableDelegator();
                            }
                            int n = anchorIndex = (onToolWindow = (ToolWindow)this.getOnDockable()) != null ? onToolWindow.getAnchorIndex() : -1;
                            if (toolWindow == onToolWindow) {
                                return false;
                            }
                            boolean oldAggregateMode = toolWindow.isAggregateMode();
                            toolWindow.setAggregateMode(true);
                            ToolWindowAnchor dragAnchor = this.getOnAnchor();
                            try {
                                if (dragAnchor != null) {
                                    switch (dragAnchor) {
                                        case LEFT: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(dragAnchor, anchorIndex != -1 ? anchorIndex - 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.LEFT);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(dragAnchor, 0);
                                            toolWindow.aggregate(AggregationPosition.LEFT);
                                            break;
                                        }
                                        case RIGHT: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(dragAnchor, anchorIndex != -1 ? anchorIndex + 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.RIGHT);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(dragAnchor);
                                            toolWindow.aggregate(AggregationPosition.RIGHT);
                                            break;
                                        }
                                        case BOTTOM: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(dragAnchor, anchorIndex != -1 ? anchorIndex + 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.BOTTOM);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(dragAnchor);
                                            toolWindow.aggregate(AggregationPosition.BOTTOM);
                                            break;
                                        }
                                        case TOP: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(dragAnchor, anchorIndex != -1 ? anchorIndex - 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.TOP);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(dragAnchor, 0);
                                            toolWindow.aggregate(AggregationPosition.TOP);
                                        }
                                    }
                                } else if (onToolWindow != null && toolWindow != onToolWindow) {
                                    onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                } else {
                                    toolWindow.aggregate();
                                }
                                toolWindow.setActive(true);
                                Object var8_14 = null;
                                toolWindow.setAggregateMode(oldAggregateMode);
                            }
                            catch (Throwable throwable) {
                                Object var8_15 = null;
                                toolWindow.setAggregateMode(oldAggregateMode);
                                throw throwable;
                            }
                            return true;
                        }
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                    try {
                        Content content = MyDoggyToolWindowManager.this.getContentManager().getContent(transferable.getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                        if (content != null) {
                            MyDoggyToolWindowManager.this.getContentManager().removeContent(content);
                            if (content.getDockableDelegator() != null) {
                                int anchorIndex;
                                Dockable delegator = content.getDockableDelegator();
                                if (!(delegator instanceof ToolWindow)) break block44;
                                ToolWindow toolWindow = (ToolWindow)delegator;
                                ToolWindow onToolWindow = (ToolWindow)this.getOnDockable();
                                int n = anchorIndex = onToolWindow != null ? onToolWindow.getAnchorIndex() : -1;
                                if (toolWindow == onToolWindow) {
                                    return false;
                                }
                                boolean oldAggregateMode = toolWindow.isAggregateMode();
                                toolWindow.setAggregateMode(true);
                                ToolWindowAnchor dragAnchor = this.getOnAnchor();
                                try {
                                    toolWindow.setAnchor(dragAnchor, anchorIndex);
                                    if (dragAnchor != null) {
                                        switch (dragAnchor) {
                                            case LEFT: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.LEFT);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.LEFT);
                                                break;
                                            }
                                            case RIGHT: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.RIGHT);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.RIGHT);
                                                break;
                                            }
                                            case BOTTOM: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.BOTTOM);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.BOTTOM);
                                                break;
                                            }
                                            case TOP: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.TOP);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.TOP);
                                            }
                                        }
                                    } else if (onToolWindow != null) {
                                        onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                    } else {
                                        toolWindow.aggregate();
                                    }
                                    toolWindow.setActive(true);
                                    Object var10_19 = null;
                                    toolWindow.setAggregateMode(oldAggregateMode);
                                }
                                catch (Throwable throwable) {
                                    Object var10_20 = null;
                                    toolWindow.setAggregateMode(oldAggregateMode);
                                    throw throwable;
                                }
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }
            return false;
        }

        protected boolean checkCondition(ToolWindow toolWindow) {
            return true;
        }
    }

    public class InternalContentMananagerListener
    implements ContentManagerListener,
    PropertyChangeListener {
        public void contentAdded(ContentManagerEvent event) {
            MyDoggyContent content = (MyDoggyContent)event.getContent();
            MyDoggyToolWindowManager.this.ensureContentVisible(content);
            content.addPlafPropertyChangeListener("ensureVisible", this);
        }

        public void contentRemoved(ContentManagerEvent event) {
        }

        public void contentSelected(ContentManagerEvent event) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindowManager.this.ensureContentVisible((Content)evt.getNewValue());
        }
    }

    public class ContentMananagerEnabledChangeListener
    implements PropertyChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ContentManager) {
                MyDoggyToolWindowGroup group = new MyDoggyToolWindowGroup(MyDoggyToolWindowManager.this, "temp", true);
                group.setActiveteTool(false);
                for (ToolWindow toolWindow : MyDoggyToolWindowManager.this.getToolWindows()) {
                    if (!toolWindow.isVisible() || toolWindow.getType() != ToolWindowType.DOCKED) continue;
                    group.addToolWindow(toolWindow);
                }
                ToolWindow activeTool = MyDoggyToolWindowManager.this.getToolWindow(MyDoggyToolWindowManager.this.getActiveToolWindowId());
                if (group.getToolsWindow().length > 0) {
                    try {
                        MyDoggyToolWindowManager.this.firePublic = false;
                        group.setVisible(false);
                        MyDoggyToolWindowManager.this.setDockableMainContentMode((Boolean)evt.getNewValue() == false);
                        group.setVisible(true);
                        if (activeTool != null) {
                            activeTool.setActive(true);
                        }
                        Object var8_7 = null;
                        MyDoggyToolWindowManager.this.firePublic = true;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        MyDoggyToolWindowManager.this.firePublic = true;
                        throw throwable;
                    }
                } else {
                    MyDoggyToolWindowManager.this.setDockableMainContentMode((Boolean)evt.getNewValue() == false);
                }
            }
        }
    }

    public class FocusOwnerChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Component newFocusOwner = (Component)evt.getNewValue();
            if (newFocusOwner != null && SwingUtilities.isDescendingFrom(newFocusOwner, MyDoggyToolWindowManager.this.mainContainer)) {
                MyDoggyToolWindowManager.this.lastFocusOwner = newFocusOwner;
            }
            MyDoggyToolWindowManager.this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    public class BarLengthListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowBar bar = (ToolWindowBar)evt.getSource();
            switch (bar.getAnchor()) {
                case LEFT: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getColumn(0) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setColumn(0, bar.getLength());
                    break;
                }
                case RIGHT: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getColumn(2) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setColumn(2, bar.getLength());
                    break;
                }
                case TOP: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getRow(0) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setRow(0, bar.getLength());
                    break;
                }
                case BOTTOM: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getRow(2) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setRow(2, bar.getLength());
                }
            }
            SwingUtil.repaint(MyDoggyToolWindowManager.this);
        }
    }

    public class ResourceManagerListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtil.repaint(MyDoggyToolWindowManager.this);
        }
    }

    public class MaximizedChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowAnchor anchor = ((ToolWindow)evt.getSource()).getAnchor();
            MyDoggyToolWindowManager.this.getBar(anchor).propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(anchor);
        }
    }

    public class UpdateUIChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindowManager.this.contentManager.updateUI();
            for (ToolWindowDescriptor descriptor : MyDoggyToolWindowManager.this.tools.values()) {
                descriptor.updateUI();
            }
            for (FloatingLiveWindow floatingLiveWindow : MyDoggyToolWindowManager.this.livePanelMap.values()) {
                floatingLiveWindow.updateUI();
            }
        }
    }

    public class IconChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindowManager.this.getDescriptor((ToolWindow)evt.getSource()).getToolBar().propertyChange(evt);
        }
    }

    public class IndexChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            int newIndex = (Integer)evt.getNewValue();
            if (newIndex > 0) {
                for (ToolWindow toolWindow : MyDoggyToolWindowManager.this.getToolWindows()) {
                    if (toolWindow == sourceTool || toolWindow.getIndex() != newIndex) continue;
                    toolWindow.setIndex(-1);
                    break;
                }
            }
            MyDoggyToolWindowManager.this.getBar(sourceTool.getAnchor()).propertyChange(evt);
        }
    }

    public class TypePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = MyDoggyToolWindowManager.this.getDescriptor((ToolWindow)evt.getSource());
            toolWindowDescriptor.getToolBar().propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(toolWindowDescriptor.getToolWindow().getAnchor());
        }
    }

    public class AnchorPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowType toolType;
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            ToolWindowAnchor oldAnchor = (ToolWindowAnchor)((Object)evt.getOldValue());
            ToolWindowAnchor newAnchor = (ToolWindowAnchor)((Object)evt.getNewValue());
            boolean force = false;
            if (oldAnchor == null) {
                oldAnchor = newAnchor;
                force = true;
            }
            if ((toolType = sourceTool.getType()) == ToolWindowType.FLOATING || toolType == ToolWindowType.FLOATING_FREE || toolType == ToolWindowType.FLOATING_LIVE || force || !sourceTool.isAvailable()) {
                UserPropertyChangeEvent avEvent = new UserPropertyChangeEvent(evt.getSource(), "available", true, false, new Object[]{-1, true});
                MyDoggyToolWindowManager.this.getBar(oldAnchor).propertyChange(avEvent);
                MyDoggyToolWindowManager.this.syncPanel(oldAnchor);
                assert (evt instanceof UserPropertyChangeEvent);
                avEvent = new UserPropertyChangeEvent(evt.getSource(), "available", false, true, new Object[]{((UserPropertyChangeEvent)evt).getUserObject(), true});
                MyDoggyToolWindowManager.this.getBar(newAnchor).propertyChange(avEvent);
                MyDoggyToolWindowManager.this.syncPanel(newAnchor);
            }
            MyDoggyToolWindowManager.this.syncPanel(oldAnchor);
            MyDoggyToolWindowManager.this.syncPanel(newAnchor);
            if (force) {
                // empty if block
            }
        }
    }

    public class ActivePropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            PropertyChangeEvent event = new PropertyChangeEvent(evt.getSource(), "active.before", evt.getOldValue(), evt.getNewValue());
            for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                bar.propertyChange(event);
            }
            MyDoggyToolWindowManager.this.getBar(sourceTool.getAnchor()).propertyChange(evt);
            if (Boolean.FALSE.equals(evt.getNewValue())) {
                MyDoggyToolWindowManager.this.activeToolWindowId = null;
                if (MyDoggyToolWindowManager.this.lastFocusOwner != null) {
                    boolean shouldRequest = true;
                    for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                        if (!bar.valueAdjusting || MyDoggyToolWindowManager.this.getBar(sourceTool.getAnchor()) != bar) continue;
                        shouldRequest = false;
                        break;
                    }
                    if (shouldRequest) {
                        SwingUtil.requestFocus(MyDoggyToolWindowManager.this.lastFocusOwner);
                    }
                }
            } else {
                MyDoggyToolWindowManager.this.activeToolWindowId = sourceTool.getId();
            }
        }
    }

    public class VisiblePropertyChangeListener
    implements PropertyChangeListener {
        boolean showingGroupValueAdj = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtil.revalidate(MyDoggyToolWindowManager.this);
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            PropertyChangeEvent event = new PropertyChangeEvent(evt.getSource(), "visible.before", evt.getOldValue(), evt.getNewValue());
            for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                bar.propertyChange(event);
            }
            MyDoggyToolWindowManager.this.getBar(sourceTool.getAnchor()).propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(sourceTool.getAnchor());
            Object object = MyDoggyToolWindowManager.this.sync;
            synchronized (object) {
                if ((MyDoggyToolWindowManager.this.showingGroup == null || MyDoggyToolWindowManager.this.showingGroup == MyDoggyToolWindowManager.this.getToolWindowGroup()) && Boolean.TRUE.equals(evt.getNewValue()) && !this.showingGroupValueAdj) {
                    this.showingGroupValueAdj = true;
                    try {
                        for (ToolWindowGroup group : MyDoggyToolWindowManager.this.getToolWindowGroups()) {
                            if (!group.isImplicit() || !group.containesToolWindow(sourceTool)) continue;
                            for (ToolWindow tool : group.getToolsWindow()) {
                                if (tool == sourceTool) continue;
                                tool.aggregate();
                            }
                            break;
                        }
                        Object var14_15 = null;
                        this.showingGroupValueAdj = false;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        this.showingGroupValueAdj = false;
                        throw throwable;
                    }
                }
            }
        }
    }

    public class ToolBarVisiblePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindowManager.this.syncPanel(((ToolWindowBar)evt.getSource()).getAnchor());
        }
    }

    public class ShowUnavailableToolsPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                bar.propertyChange(evt);
            }
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.LEFT);
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.RIGHT);
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.TOP);
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.BOTTOM);
        }
    }

    public class AvailablePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            DockableDescriptor descriptor = MyDoggyToolWindowManager.this.getDockableDescriptorBySource(evt.getSource());
            ToolWindowAnchor target = descriptor.getAnchor();
            MyDoggyToolWindowManager.this.getBar(target).propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(target);
        }
    }
}

