/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.docking;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.ui.docking.DockableTool;
import org.weasis.core.ui.docking.UIManager;

public abstract class PluginTool
extends JPanel
implements DockableTool {
    private static final long serialVersionUID = -204558500055275231L;
    private final String dockableUID;
    private String toolName;
    private Icon icon;
    private int dockableWidth;
    private boolean hide;
    private ToolWindowAnchor anchor;

    public PluginTool(String id, String toolName, ToolWindowAnchor anchor) {
        this.toolName = toolName;
        this.icon = null;
        this.dockableUID = id;
        this.dockableWidth = -1;
        this.anchor = anchor;
        this.hide = true;
    }

    protected abstract void changeToolWindowAnchor(ToolWindowAnchor var1);

    @Override
    public ToolWindow registerToolAsDockable() {
        ToolWindow win = this.getToolWindow();
        if (win == null) {
            win = UIManager.toolWindowManager.registerToolWindow(this.dockableUID, this.toolName, this.icon, this.getToolComponent(), this.anchor);
            win.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("anchor".equals(evt.getPropertyName()) && evt.getNewValue() instanceof ToolWindowAnchor) {
                        PluginTool.this.setAnchor((ToolWindowAnchor)evt.getNewValue());
                    }
                }
            });
        }
        DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)win.getTypeDescriptor(ToolWindowType.DOCKED);
        if (this.dockableWidth > 0) {
            if (dockedTypeDescriptor.getMinimumDockLength() > this.dockableWidth) {
                dockedTypeDescriptor.setMinimumDockLength(this.dockableWidth);
            }
            dockedTypeDescriptor.setDockLength(this.dockableWidth);
        }
        win.setAvailable(true);
        win.setVisible(!this.hide);
        return win;
    }

    @Override
    public Component getToolComponent() {
        return this;
    }

    public void setDockableWidth(int width) {
        this.dockableWidth = width;
    }

    @Override
    public String getDockableUID() {
        return this.dockableUID;
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public ToolWindowAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(ToolWindowAnchor anchor) {
        if (anchor != null && !anchor.equals((Object)this.anchor)) {
            this.anchor = anchor;
            this.changeToolWindowAnchor(anchor);
        }
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public int getDockableWidth() {
        return this.dockableWidth;
    }

    @Override
    public final ToolWindow getToolWindow() {
        return UIManager.toolWindowManager.getToolWindow((Object)this.dockableUID);
    }

    @Override
    public void showDockable() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ToolWindow tool = PluginTool.this.getToolWindow();
                if (tool != null) {
                    tool.setActive(true);
                }
            }
        });
    }

    @Override
    public void closeDockable() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                UIManager.toolWindowManager.unregisterToolWindow(PluginTool.this.dockableUID);
            }
        });
    }
}

