/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BoundedRangeModel;
import javax.swing.event.SwingPropertyChangeSupport;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.SliderCineListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.image.GridBagLayoutModel;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.ui.editor.SeriesViewerEvent;
import org.weasis.core.ui.editor.SeriesViewerListener;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.MouseActions;
import org.weasis.core.ui.editor.image.PannerListener;
import org.weasis.core.ui.editor.image.SynchView;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.util.ViewSetting;
import org.weasis.core.ui.util.ZoomSetting;

public abstract class ImageViewerEventManager<E extends ImageElement> {
    public static final int ZOOM_SLIDER_MIN = -100;
    public static final int ZOOM_SLIDER_MAX = 100;
    public static final int WINDOW_SMALLEST = 0;
    public static final int WINDOW_LARGEST = 4096;
    public static final int WINDOW_DEFAULT = 700;
    public static final int LEVEL_SMALLEST = 0;
    public static final int LEVEL_LARGEST = 4096;
    public static final int LEVEL_DEFAULT = 300;
    protected final ArrayList<SeriesViewerListener> seriesViewerListeners = new ArrayList();
    protected final MouseActions mouseActions = new MouseActions(null);
    protected final ZoomSetting zoomSetting = new ZoomSetting();
    protected final ViewSetting viewSetting = new ViewSetting();
    protected ImageViewerPlugin<E> selectedView2dContainer;
    protected final SwingPropertyChangeSupport propertySupport = new SwingPropertyChangeSupport(this);
    protected final HashMap<ActionW, ActionState> actions = new HashMap();
    protected boolean enabledAction = true;

    protected SliderCineListener getMoveTroughSliceAction(int speed, final SliderCineListener.TIME time, double mouseSensivity) {
        return new SliderCineListener(ActionW.SCROLL_SERIES, 1, 2, 1, speed, time, mouseSensivity){
            private volatile boolean cining;
            protected org.weasis.core.ui.editor.image.ImageViewerEventManager.1.CineThread currentCine;
            {
                super(x0, x1, x2, x3, x4, x5, x6);
                this.cining = true;
            }

            public void stateChanged(BoundedRangeModel model) {
                MediaElement media;
                DefaultView2d selectedImagePane;
                int index = model.getValue() - 1;
                Series series = null;
                ImageElement image = null;
                if (ImageViewerEventManager.this.selectedView2dContainer != null && (selectedImagePane = ImageViewerEventManager.this.selectedView2dContainer.getSelectedImagePane()).getSeries() instanceof Series && (media = (series = (Series)selectedImagePane.getSeries()).getMedia(index)) instanceof ImageElement) {
                    image = (ImageElement)media;
                }
                Integer location = index;
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, location);
                if (image != null) {
                    ImageViewerEventManager.this.fireSeriesViewerListeners(new SeriesViewerEvent(ImageViewerEventManager.this.selectedView2dContainer, series, (MediaElement)image, SeriesViewerEvent.EVENT.SELECT));
                }
            }

            public void setSpeed(int speed) {
                super.setSpeed(speed);
                if (this.currentCine != null) {
                    this.currentCine.iniSpeed();
                }
            }

            public synchronized void start() {
                if (this.currentCine != null) {
                    this.stop();
                }
                if (this.getMax() - this.getMin() > 0) {
                    this.cining = true;
                    this.currentCine = new CineThread();
                    this.currentCine.start();
                }
            }

            public synchronized void stop() {
                org.weasis.core.ui.editor.image.ImageViewerEventManager.1.CineThread moribund = this.currentCine;
                this.currentCine = null;
                if (moribund != null) {
                    this.cining = false;
                    moribund.interrupt();
                }
            }

            public void mouseWheelMoved(MouseWheelEvent e) {
                this.setValue(this.getValue() + e.getWheelRotation());
            }

            public int getCurrentCineRate() {
                if (this.currentCine != null) {
                    return this.currentCine.getCurrentCineRate();
                }
                return 0;
            }

            class CineThread
            extends Thread {
                private volatile int iteration;
                private volatile int wait;
                private volatile int currentCineRate;
                private volatile long start;
                private final int timeDiv;

                CineThread() {
                    this.timeDiv = SliderCineListener.TIME.second.equals((Object)time) ? 1000 : (SliderCineListener.TIME.minute.equals((Object)time) ? 60000 : 3600000);
                }

                @Override
                public void run() {
                    this.iniSpeed();
                    while (cining) {
                        GuiExecutor.instance().execute(new Runnable(){

                            @Override
                            public void run() {
                                int frameIndex = this.getValue() + 1;
                                frameIndex = frameIndex > this.getMax() ? 0 : frameIndex;
                                this.setValue(frameIndex);
                            }
                        });
                        ++this.iteration;
                        long elapsed = (System.currentTimeMillis() - this.start) / 1000L;
                        if (elapsed > 0L) {
                            this.currentCineRate = (int)((long)this.iteration / elapsed);
                            this.wait = this.currentCineRate < this.getSpeed() ? --this.wait : ++this.wait;
                            if (this.wait < 0) {
                                this.wait = 0;
                            }
                        }
                        if (this.wait <= 0) continue;
                        try {
                            Thread.sleep(this.wait);
                        }
                        catch (Exception exception) {}
                    }
                }

                public void iniSpeed() {
                    this.iteration = 0;
                    this.wait = this.timeDiv / this.getSpeed();
                    this.currentCineRate = this.getSpeed();
                    this.start = System.currentTimeMillis();
                }

                public int getCurrentCineRate() {
                    return this.currentCineRate;
                }
            }
        };
    }

    protected SliderChangeListener newWindowAction() {
        return new SliderChangeListener(ActionW.WINDOW, 0, 4096, 700, true, 1.25){

            public void stateChanged(BoundedRangeModel model) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, model.getValue());
            }
        };
    }

    protected SliderChangeListener newLevelAction() {
        return new SliderChangeListener(ActionW.LEVEL, 0, 4096, 300, true, 1.25){

            public void stateChanged(BoundedRangeModel model) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, model.getValue());
            }
        };
    }

    protected SliderChangeListener newRotateAction() {
        return new SliderChangeListener(ActionW.ROTATION, 0, 360, 0, true, 0.25){

            public void stateChanged(BoundedRangeModel model) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, model.getValue());
            }

            public String getValueToDisplay() {
                return this.getValue() + " \u00b0";
            }
        };
    }

    protected SliderChangeListener newZoomAction() {
        return new SliderChangeListener(ActionW.ZOOM, -100, 100, 0, true, 0.1){

            public void stateChanged(BoundedRangeModel model) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, ImageViewerEventManager.this.sliderValueToViewScale(model.getValue()));
            }

            public String getValueToDisplay() {
                return DecFormater.twoDecimal((double)(ImageViewerEventManager.this.sliderValueToViewScale(this.getValue()) * 100.0)) + " %";
            }
        };
    }

    protected PannerListener newPanAction() {
        return new PannerListener(ActionW.PAN, null){

            @Override
            public void pointChanged(Point2D point) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, point);
            }
        };
    }

    protected ToggleButtonListener newFlipAction() {
        return new ToggleButtonListener(ActionW.FLIP, false){

            public void actionPerformed(boolean selected) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, selected);
            }
        };
    }

    protected ToggleButtonListener newInverseLutAction() {
        return new ToggleButtonListener(ActionW.INVERSELUT, false){

            public void actionPerformed(boolean selected) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, selected);
            }
        };
    }

    protected ToggleButtonListener newLensAction() {
        return new ToggleButtonListener(ActionW.LENS, false){

            public void actionPerformed(boolean selected) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, selected);
            }
        };
    }

    protected SliderChangeListener newLensZoomAction() {
        return new SliderChangeListener(ActionW.LENSZOOM, -100, 100, this.viewScaleToSliderValue(2.0), true, 0.1){

            public void stateChanged(BoundedRangeModel model) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, ImageViewerEventManager.this.sliderValueToViewScale(model.getValue()));
            }

            public String getValueToDisplay() {
                return DecFormater.twoDecimal((double)(ImageViewerEventManager.this.sliderValueToViewScale(this.getValue()) * 100.0)) + " %";
            }
        };
    }

    protected ComboItemListener newLayoutAction(GridBagLayoutModel[] layouts) {
        if (layouts == null) {
            layouts = new GridBagLayoutModel[]{};
        }
        return new ComboItemListener(ActionW.LAYOUT, layouts){

            public void itemStateChanged(Object object) {
                if (object instanceof GridBagLayoutModel && ImageViewerEventManager.this.selectedView2dContainer != null) {
                    ImageViewerEventManager.this.clearAllPropertyChangeListeners();
                    DefaultView2d view = ImageViewerEventManager.this.selectedView2dContainer.getSelectedImagePane();
                    ImageViewerEventManager.this.selectedView2dContainer.setLayoutModel((GridBagLayoutModel)object);
                    if (!ImageViewerEventManager.this.selectedView2dContainer.isContainingView(view)) {
                        view = ImageViewerEventManager.this.selectedView2dContainer.getSelectedImagePane();
                    }
                    ImageViewerEventManager.this.selectedView2dContainer.setSelectedImagePane(view);
                    ActionState synch = ImageViewerEventManager.this.getAction(ActionW.SYNCH);
                    if (synch instanceof ComboItemListener) {
                        ImageViewerEventManager.this.selectedView2dContainer.setSynchView((SynchView)((ComboItemListener)synch).getSelectedItem());
                    }
                }
            }
        };
    }

    protected ComboItemListener newSynchAction(SynchView[] synchViewList) {
        if (synchViewList == null) {
            synchViewList = new SynchView[]{};
        }
        return new ComboItemListener(ActionW.SYNCH, synchViewList){

            public void itemStateChanged(Object object) {
                if (object instanceof SynchView && ImageViewerEventManager.this.selectedView2dContainer != null) {
                    SynchView synchView = (SynchView)object;
                    ImageViewerEventManager.this.selectedView2dContainer.setSynchView(synchView);
                }
            }
        };
    }

    protected ToggleButtonListener newInverseStackAction() {
        return new ToggleButtonListener(ActionW.INVERSESTACK, false){

            public void actionPerformed(boolean selected) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, selected);
            }
        };
    }

    protected ComboItemListener newMeasurementAction(Graphic[] graphics) {
        if (graphics == null) {
            graphics = new Graphic[]{};
        }
        return new ComboItemListener(ActionW.DRAW_MEASURE, graphics){

            public void itemStateChanged(Object object) {
                if (object instanceof Graphic && ImageViewerEventManager.this.selectedView2dContainer != null) {
                    ImageViewerEventManager.this.selectedView2dContainer.setDrawActions((Graphic)object);
                }
            }
        };
    }

    protected ToggleButtonListener newDrawOnlyOnceAction() {
        return new ToggleButtonListener(ActionW.DRAW_ONLY_ONCE, true){

            public void actionPerformed(boolean selected) {
                ImageViewerEventManager.this.firePropertyChange(this.action.cmd(), null, selected);
                ImageViewerEventManager.this.viewSetting.setDrawOnlyOnce(selected);
            }
        };
    }

    public abstract boolean updateComponentsListener(DefaultView2d<E> var1);

    private static double roundAndCropViewScale(double viewScale, double minViewScale, double maxViewScale) {
        double v;
        if ((viewScale *= 1000.0) - (v = Math.floor(viewScale)) >= 0.5) {
            v += 0.5;
        }
        if ((viewScale = v / 1000.0) < minViewScale) {
            viewScale = minViewScale;
        }
        if (viewScale > maxViewScale) {
            viewScale = maxViewScale;
        }
        return viewScale;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addSeriesViewerListener(SeriesViewerListener listener) {
        if (!this.seriesViewerListeners.contains(listener)) {
            this.seriesViewerListeners.add(listener);
        }
    }

    public void removeSeriesViewerListener(SeriesViewerListener listener) {
        this.seriesViewerListeners.remove(listener);
    }

    public void fireSeriesViewerListeners(SeriesViewerEvent event) {
        if (event != null) {
            for (SeriesViewerListener listener : this.seriesViewerListeners) {
                listener.changingViewContentEvent(event);
            }
        }
    }

    public void clearAllPropertyChangeListeners() {
        PropertyChangeListener[] changeListeners;
        for (PropertyChangeListener propertyChangeListener : changeListeners = this.propertySupport.getPropertyChangeListeners()) {
            this.propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListeners(String command, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(command, listener);
    }

    public void addPropertyChangeListeners(DefaultView2d<E> viewPane, SynchView synchView) {
        HashMap<ActionW, Boolean> synchActions = synchView.getActions();
        for (ActionState a : this.actions.values()) {
            Boolean bool = synchActions.get(a.getActionW());
            if (bool == null || !bool.booleanValue()) continue;
            this.propertySupport.addPropertyChangeListener(a.getActionW().cmd(), viewPane);
        }
    }

    public void addPropertyChangeListeners(DefaultView2d<E> viewPane) {
        for (ActionState a : this.actions.values()) {
            this.propertySupport.addPropertyChangeListener(a.getActionW().cmd(), viewPane);
        }
    }

    public ActionState getAction(ActionW action) {
        if (action != null) {
            return this.actions.get(action);
        }
        return null;
    }

    public ActionW getActionFromCommand(String command) {
        if (command != null) {
            for (ActionW action : this.actions.keySet()) {
                if (!action.cmd().equals(command)) continue;
                return action;
            }
        }
        return null;
    }

    public ActionW getActionFromkeyEvent(int keyEvent) {
        if (keyEvent != 0) {
            for (ActionW action : this.actions.keySet()) {
                if (action.getKeyCode() != keyEvent) continue;
                return action;
            }
        }
        return null;
    }

    public Collection<ActionState> getAllActionValues() {
        return this.actions.values();
    }

    public MouseActions getMouseActions() {
        return this.mouseActions;
    }

    public ZoomSetting getZoomSetting() {
        return this.zoomSetting;
    }

    public ViewSetting getViewSetting() {
        return this.viewSetting;
    }

    public int viewScaleToSliderValue(double viewScale) {
        double v = Math.log(viewScale) / Math.log(12.0) * 100.0;
        return (int)Math.round(v);
    }

    public synchronized void enableActions(boolean enabled) {
        this.enabledAction = enabled;
        for (ActionState a : this.actions.values()) {
            a.enableAction(enabled);
        }
    }

    public double sliderValueToViewScale(int sliderValue) {
        double v = (double)sliderValue / 100.0;
        double viewScale = Math.exp(v * Math.log(12.0));
        viewScale = ImageViewerEventManager.roundAndCropViewScale(viewScale, 0.08333333333333333, 12.0);
        return viewScale;
    }

    public DefaultView2d<E> getSelectedViewPane() {
        if (this.selectedView2dContainer != null) {
            return this.selectedView2dContainer.getSelectedImagePane();
        }
        return null;
    }

    public ImageViewerPlugin<E> getSelectedView2dContainer() {
        return this.selectedView2dContainer;
    }

    public void updateAllListeners(ImageViewerPlugin<E> viewerPlugin, SynchView synchView) {
        this.clearAllPropertyChangeListeners();
        if (viewerPlugin != null) {
            DefaultView2d<E> viewPane = viewerPlugin.getSelectedImagePane();
            if (viewPane == null) {
                return;
            }
            if (viewPane.getSeries() != null) {
                this.addPropertyChangeListeners(viewPane);
                Boolean synchLink = (Boolean)viewPane.getActionValue(ActionW.SYNCH_LINK.cmd());
                ArrayList<DefaultView2d<E>> panes = viewerPlugin.getImagePanels();
                panes.remove(viewPane);
                if (!SynchView.NONE.equals(synchView)) {
                    if (SynchView.Mode.Stack.equals((Object)synchView.getMode())) {
                        boolean hasLink = false;
                        for (int i = 0; i < panes.size(); ++i) {
                            if (!this.isCompatible(viewPane.getSeries(), panes.get(i).getSeries()) || synchLink != null && !synchLink.booleanValue()) continue;
                            hasLink = true;
                            panes.get(i).setActionsInView(ActionW.SYNCH_LINK.cmd(), true);
                            this.addPropertyChangeListeners(panes.get(i), synchView);
                        }
                        if (synchLink == null && hasLink) {
                            viewPane.setActionsInView(ActionW.SYNCH_LINK.cmd(), hasLink);
                        }
                    } else if (SynchView.Mode.Tile.equals((Object)synchView.getMode())) {
                        for (int i = 0; i < panes.size(); ++i) {
                            if (synchLink != null && !synchLink.booleanValue()) continue;
                            panes.get(i).setActionsInView(ActionW.SYNCH_LINK.cmd(), true);
                            this.addPropertyChangeListeners(panes.get(i), synchView);
                        }
                    }
                }
            }
        }
    }

    protected boolean isCompatible(MediaSeries<E> series, MediaSeries<E> series2) {
        return true;
    }

    public void setSelectedView2dContainer(ImageViewerPlugin<E> selectedView2dContainer) {
        if (this.selectedView2dContainer != null) {
            this.selectedView2dContainer.setMouseActions(null);
            this.selectedView2dContainer.setDrawActions(null);
        }
        this.selectedView2dContainer = selectedView2dContainer;
        if (selectedView2dContainer != null) {
            selectedView2dContainer.setMouseActions(this.mouseActions);
            Graphic graphic = null;
            ActionState action = this.getAction(ActionW.DRAW_MEASURE);
            if (action instanceof ComboItemListener) {
                graphic = (Graphic)((ComboItemListener)action).getSelectedItem();
            }
            selectedView2dContainer.setDrawActions(graphic);
        }
    }
}

