/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.weasis.core.api.image.util.ImageFiler;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.editor.image.DefaultView2d;

public class ViewTransferHandler
extends TransferHandler
implements Transferable {
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
    private Image image;

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        DefaultView2d view2DPane;
        PlanarImage imgP;
        this.image = null;
        if (comp instanceof DefaultView2d && (imgP = ViewTransferHandler.createComponentImage(view2DPane = (DefaultView2d)comp)) != null) {
            this.image = imgP.getAsBufferedImage();
            return this;
        }
        return null;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (this.isDataFlavorSupported(flavor)) {
            return this.image;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.imageFlavor);
    }

    public static PlanarImage createComponentImage(DefaultView2d<ImageElement> canvas) {
        TiledImage image = ImageFiler.getEmptyTiledImage((Color)Color.BLACK, (float)canvas.getWidth(), (float)canvas.getHeight());
        Graphics2D g = image.createGraphics();
        if (g != null) {
            boolean anonymAnnotationsStatus = canvas.getInfoLayer().getDisplayPreferences("Anonymize");
            if (!anonymAnnotationsStatus) {
                canvas.getInfoLayer().setDisplayPreferencesValue("Anonymize", true);
            }
            canvas.draw(g);
            g.dispose();
            if (!anonymAnnotationsStatus) {
                canvas.getInfoLayer().setDisplayPreferencesValue("Anonymize", false);
            }
        }
        return image;
    }
}

