/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.GraphicLabel;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.util.MouseEventDouble;

public class DragLayer
extends AbstractLayer {
    private static final long serialVersionUID = 8576601524359423997L;

    public DragLayer(LayerModel canvas1, int drawMode) {
        super(canvas1, drawMode);
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform, AffineTransform inverseTransform, Rectangle2D bounds) {
        if (this.graphics == null) {
            return;
        }
        for (Graphic graphic : this.graphics) {
            if (bounds != null) {
                Rectangle repaintBounds = graphic.getRepaintBounds(transform);
                if (repaintBounds != null && repaintBounds.intersects(bounds)) {
                    graphic.paint(g2d, transform);
                    continue;
                }
                GraphicLabel graphicLabel = graphic.getGraphicLabel();
                Rectangle2D labelBounds = graphicLabel != null ? graphicLabel.getBounds(transform) : null;
                if (labelBounds == null || !labelBounds.intersects(bounds)) continue;
                graphic.paintLabel(g2d, transform);
                continue;
            }
            graphic.paint(g2d, transform);
            graphic.paintLabel(g2d, transform);
        }
    }

    @Override
    public List<Graphic> getGraphicsSurfaceInArea(Rectangle selectGraphic, AffineTransform transform) {
        ArrayList<Graphic> selectedGraphicList = new ArrayList<Graphic>();
        if (this.graphics != null && this.graphics.size() > 0 && selectGraphic != null) {
            for (Graphic graphic : this.graphics) {
                Area selectionArea;
                Area selectionArea2;
                Rectangle graphBounds = graphic.getBounds(transform);
                if (graphBounds != null && graphBounds.intersects(selectGraphic) && (selectionArea2 = graphic.getArea(transform)) != null && selectionArea2.intersects(selectGraphic)) {
                    selectedGraphicList.add(graphic);
                    continue;
                }
                GraphicLabel graphicLabel = graphic.getGraphicLabel();
                if (graphicLabel == null || !graphic.isLabelVisible() || (selectionArea = graphicLabel.getArea(transform)) == null || !selectionArea.intersects(selectGraphic)) continue;
                selectedGraphicList.add(graphic);
            }
        }
        return selectedGraphicList;
    }

    @Override
    public List<Graphic> getGraphicsSurfaceInArea(Rectangle rect, AffineTransform transform, boolean firstGraphicOnly) {
        ArrayList<Graphic> selectedGraphicList = new ArrayList<Graphic>();
        if (this.graphics != null && this.graphics.size() > 0 && rect != null) {
            ArrayList<Area> selectedAreaList = new ArrayList<Area>();
            ListIterator graphicsIt = this.graphics.listIterator(this.graphics.size());
            while (graphicsIt.hasPrevious()) {
                Area labelArea;
                GraphicLabel graphicLabel;
                Graphic selectedGraphic = (Graphic)graphicsIt.previous();
                if (selectedGraphic == null) continue;
                Area selectedArea = null;
                Rectangle selectionBounds = selectedGraphic.getRepaintBounds(this.getAffineTransform());
                if (selectionBounds != null && selectionBounds.intersects(rect)) {
                    selectedArea = selectedGraphic.getArea(transform);
                }
                if ((graphicLabel = selectedGraphic.getGraphicLabel()) != null && (labelArea = graphicLabel.getArea(transform)) != null) {
                    if (selectedArea != null) {
                        selectedArea.add(labelArea);
                    } else if (labelArea.intersects(rect)) {
                        selectedArea = selectedGraphic.getArea(transform);
                        selectedArea.add(labelArea);
                    }
                }
                if (selectedArea == null) continue;
                if (firstGraphicOnly) {
                    for (Area area : selectedAreaList) {
                        selectedArea.subtract(area);
                    }
                }
                if (!selectedArea.intersects(rect)) continue;
                selectedAreaList.add(selectedArea);
                selectedGraphicList.add(selectedGraphic);
            }
        }
        return selectedGraphicList;
    }

    @Override
    public List<Graphic> getGraphicsBoundsInArea(Rectangle rect) {
        ArrayList<Graphic> arraylist = new ArrayList<Graphic>();
        if (this.graphics != null && rect != null) {
            for (int j = this.graphics.size() - 1; j >= 0; --j) {
                Graphic graphic = (Graphic)this.graphics.get(j);
                Rectangle graphicBounds = graphic.getRepaintBounds(this.getAffineTransform());
                if (graphicBounds == null || !graphicBounds.intersects((Rectangle2D)rect)) continue;
                arraylist.add(graphic);
            }
        }
        return arraylist;
    }

    @Override
    public AbstractDragGraphic getGraphicContainPoint(MouseEventDouble mouseEvt) {
        Point2D mousePt = mouseEvt.getImageCoordinates();
        if (this.graphics != null && mousePt != null) {
            for (int j = this.graphics.size() - 1; j >= 0; --j) {
                if (!(this.graphics.get(j) instanceof AbstractDragGraphic)) continue;
                AbstractDragGraphic dragGraph = (AbstractDragGraphic)this.graphics.get(j);
                if (dragGraph.isOnGraphicLabel(mouseEvt)) {
                    return dragGraph;
                }
                Rectangle repaintBound = dragGraph.getRepaintBounds(mouseEvt);
                if (repaintBound == null || !repaintBound.contains(mousePt) || dragGraph.getHandlePointIndex(mouseEvt) < 0 && !dragGraph.getArea(mouseEvt).contains(mousePt)) continue;
                return dragGraph;
            }
        }
        return null;
    }

    @Override
    public List<Graphic> getGraphicListContainPoint(MouseEventDouble mouseEvt) {
        ArrayList<AbstractDragGraphic> selectedGraphicList = null;
        Point2D mousePt = mouseEvt.getImageCoordinates();
        if (this.graphics != null && mousePt != null) {
            selectedGraphicList = new ArrayList<AbstractDragGraphic>();
            for (int j = this.graphics.size() - 1; j >= 0; --j) {
                if (!(this.graphics.get(j) instanceof AbstractDragGraphic)) continue;
                AbstractDragGraphic dragGraph = (AbstractDragGraphic)this.graphics.get(j);
                if (dragGraph.isOnGraphicLabel(mouseEvt)) {
                    selectedGraphicList.add(dragGraph);
                    continue;
                }
                Rectangle repaintBound = dragGraph.getRepaintBounds(mouseEvt);
                if (repaintBound == null || !repaintBound.contains(mousePt) || dragGraph.getHandlePointIndex(mouseEvt) < 0 && !dragGraph.getArea(mouseEvt).contains(mousePt)) continue;
                selectedGraphicList.add(dragGraph);
            }
        }
        return selectedGraphicList;
    }
}

