/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class LineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(LineGraphic.class.getResource("/icon/22x22/draw-line.png"));
    public static final Measurement FIRST_POINT_X = new Measurement("First point X", true, true, false);
    public static final Measurement FIRST_POINT_Y = new Measurement("First point Y", true, true, false);
    public static final Measurement LAST_POINT_X = new Measurement("Last point X", true, true, false);
    public static final Measurement LAST_POINT_Y = new Measurement("Last point Y", true, true, false);
    public static final Measurement LINE_LENGTH = new Measurement("Line length", true, true, true);
    public static final Measurement ORIENTATION = new Measurement("Orientation", true, true, false);
    public static final Measurement AZIMUTH = new Measurement("Azimuth", true, true, false);
    protected Point2D ptA;
    protected Point2D ptB;
    protected boolean lineABvalid;

    public LineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(2, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.line");
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Line2D.Double newShape = null;
        if (this.lineABvalid) {
            newShape = new Line2D.Double(this.ptA, this.ptB);
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (FIRST_POINT_X.isComputed() && (!drawOnLabel || FIRST_POINT_X.isGraphicLabel())) {
                val = null;
                if (releaseEvent || FIRST_POINT_X.isQuickComputing()) {
                    val = adapter.getXCalibratedValue(this.ptA.getX());
                }
                measVal.add(new MeasureItem(FIRST_POINT_X, val, adapter.getUnit()));
            }
            if (FIRST_POINT_Y.isComputed() && (!drawOnLabel || FIRST_POINT_Y.isGraphicLabel())) {
                val = null;
                if (releaseEvent || FIRST_POINT_Y.isQuickComputing()) {
                    val = adapter.getXCalibratedValue(this.ptA.getY());
                }
                measVal.add(new MeasureItem(FIRST_POINT_Y, val, adapter.getUnit()));
            }
            if (LAST_POINT_X.isComputed() && (!drawOnLabel || LAST_POINT_X.isGraphicLabel())) {
                val = null;
                if (releaseEvent || LAST_POINT_X.isQuickComputing()) {
                    val = adapter.getXCalibratedValue(this.ptB.getX());
                }
                measVal.add(new MeasureItem(LAST_POINT_X, val, adapter.getUnit()));
            }
            if (LAST_POINT_Y.isComputed() && (!drawOnLabel || LAST_POINT_Y.isGraphicLabel())) {
                val = null;
                if (releaseEvent || LAST_POINT_Y.isQuickComputing()) {
                    val = adapter.getXCalibratedValue(this.ptB.getY());
                }
                measVal.add(new MeasureItem(LAST_POINT_Y, val, adapter.getUnit()));
            }
            if (LINE_LENGTH.isComputed() && (!drawOnLabel || LINE_LENGTH.isGraphicLabel())) {
                val = null;
                if (releaseEvent || LINE_LENGTH.isQuickComputing()) {
                    val = this.ptA.distance(this.ptB) * adapter.getCalibRatio();
                }
                measVal.add(new MeasureItem(LINE_LENGTH, val, adapter.getUnit()));
            }
            if (ORIENTATION.isComputed() && (!drawOnLabel || ORIENTATION.isGraphicLabel())) {
                val = null;
                if (releaseEvent || ORIENTATION.isQuickComputing()) {
                    val = MathUtil.getOrientation((Point2D)this.ptA, (Point2D)this.ptB);
                }
                measVal.add(new MeasureItem(ORIENTATION, val, "deg"));
            }
            if (AZIMUTH.isComputed() && (!drawOnLabel || AZIMUTH.isGraphicLabel())) {
                val = null;
                if (releaseEvent || AZIMUTH.isQuickComputing()) {
                    val = MathUtil.getAzimuth((Point2D)this.ptA, (Point2D)this.ptB);
                }
                measVal.add(new MeasureItem(AZIMUTH, val, "deg"));
            }
            return measVal;
        }
        return null;
    }

    protected void updateTool() {
        this.ptA = this.getHandlePoint(0);
        this.ptB = this.getHandlePoint(1);
        this.lineABvalid = this.ptA != null && this.ptB != null && !this.ptB.equals(this.ptA);
    }

    public Point2D getStartPoint() {
        this.updateTool();
        return this.ptA;
    }

    public Point2D getEndPoint() {
        this.updateTool();
        return this.ptB;
    }
}

