/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Window;
import java.util.List;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.PropertiesDialog;

public class MeasureDialog
extends PropertiesDialog {
    private List<AbstractDragGraphic> graphics;

    public MeasureDialog(Window parent, List<AbstractDragGraphic> selectedGraphic) {
        super(parent, "Drawing Properties");
        if (selectedGraphic == null) {
            throw new IllegalArgumentException("Selected Graphics cannot be null!");
        }
        this.graphics = selectedGraphic;
        this.iniGraphicDialog();
        this.pack();
    }

    public void iniGraphicDialog() {
        if (this.graphics.size() > 0) {
            AbstractDragGraphic graphic = this.graphics.get(0);
            Color color = (Color)graphic.getColorPaint();
            int width = (int)graphic.getLineThickness();
            boolean fill = graphic.isFilled();
            this.jButtonColor.setBackground(color);
            this.spinnerLineWidth.setValue(width);
            this.jCheckBoxFilled.setSelected(fill);
            boolean areaGraphics = false;
            boolean mfill = false;
            boolean mcolor = false;
            boolean mwidth = false;
            for (AbstractDragGraphic g : this.graphics) {
                if (g instanceof AbstractDragGraphicArea) {
                    areaGraphics = true;
                    if (g.isFilled() != fill) {
                        mfill = true;
                    }
                }
                if ((int)g.getLineThickness() != width) {
                    mwidth = true;
                }
                if (color.equals(g.getColorPaint())) continue;
                mcolor = true;
            }
            this.checkBox_color.setVisible(mcolor);
            this.jLabelLineColor.setEnabled(!mcolor);
            this.jButtonColor.setEnabled(!mcolor);
            this.checkBox_width.setVisible(mwidth);
            this.spinnerLineWidth.setEnabled(!mwidth);
            this.jLabelLineWidth.setEnabled(!mwidth);
            this.checkBox_fill.setVisible(mfill);
            this.jCheckBoxFilled.setEnabled(areaGraphics && !mfill);
            if (this.graphics.size() == 1 || !mcolor && !mfill && !mwidth) {
                this.lbloverridesmultipleValues.setVisible(false);
            }
        }
    }

    @Override
    protected void okAction() {
        for (AbstractDragGraphic graphic : this.graphics) {
            if (this.spinnerLineWidth.isEnabled()) {
                graphic.setLineThickness(((Integer)this.spinnerLineWidth.getValue()).floatValue());
            }
            if (this.jButtonColor.isEnabled()) {
                graphic.setPaint(this.jButtonColor.getBackground());
            }
            if (!this.jCheckBoxFilled.isEnabled()) continue;
            graphic.setFilled(this.jCheckBoxFilled.isSelected());
        }
        this.dispose();
    }
}

