/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class RectangleGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(RectangleGraphic.class.getResource("/icon/22x22/draw-rectangle.png"));
    public static final Measurement AREA = new Measurement("Area", true, true, true);
    public static final Measurement PERIMETER = new Measurement("Perimeter", true, true, false);
    public static final Measurement TOP_LEFT_POINT_X = new Measurement("Top Left X", true, true, false);
    public static final Measurement TOP_LEFT_POINT_Y = new Measurement("Top Left Y", true, true, false);
    public static final Measurement CENTER_X = new Measurement("Center X", true, true, false);
    public static final Measurement CENTER_Y = new Measurement("Center Y", true, true, false);
    public static final Measurement WIDTH = new Measurement("Width", true, true, false);
    public static final Measurement HEIGHT = new Measurement("Height", true, true, false);

    public RectangleGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(8, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.rect");
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        if (handlePointIndex == -1) {
            for (Point2D point : this.handlePointList) {
                if (point == null) continue;
                point.setLocation(point.getX() + deltaX, point.getY() + deltaY);
            }
        } else {
            Rectangle2D.Double rectangle = new Rectangle2D.Double();
            rectangle.setFrameFromDiagonal(this.getHandlePoint(eHandlePoint.NW.index), this.getHandlePoint(eHandlePoint.SE.index));
            double x = ((RectangularShape)rectangle).getX();
            double y = ((RectangularShape)rectangle).getY();
            double w = ((RectangularShape)rectangle).getWidth();
            double h = ((RectangularShape)rectangle).getHeight();
            eHandlePoint pt = eHandlePoint.valueFromIndex(handlePointIndex);
            if (pt.equals((Object)eHandlePoint.W) || pt.equals((Object)eHandlePoint.NW) || pt.equals((Object)eHandlePoint.SW)) {
                x += deltaX;
                w -= deltaX;
            }
            if (pt.equals((Object)eHandlePoint.N) || pt.equals((Object)eHandlePoint.NW) || pt.equals((Object)eHandlePoint.NE)) {
                y += deltaY;
                h -= deltaY;
            }
            if (pt.equals((Object)eHandlePoint.E) || pt.equals((Object)eHandlePoint.NE) || pt.equals((Object)eHandlePoint.SE)) {
                w += deltaX;
            }
            if (pt.equals((Object)eHandlePoint.S) || pt.equals((Object)eHandlePoint.SW) || pt.equals((Object)eHandlePoint.SE)) {
                h += deltaY;
            }
            if (w < 0.0) {
                w = -w;
                x -= w;
                pt = pt.getVerticalMirror();
            }
            if (h < 0.0) {
                h = -h;
                y -= h;
                pt = pt.getHorizontalMirror();
            }
            handlePointIndex = pt.index;
            rectangle.setFrame(x, y, w, h);
            this.setHandlePointList(rectangle);
        }
        return handlePointIndex;
    }

    protected void setHandlePointList(Rectangle2D rectangle) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double w = rectangle.getWidth();
        double h = rectangle.getHeight();
        while (this.handlePointList.size() < this.handlePointTotalNumber) {
            this.handlePointList.add(new Point2D.Double());
        }
        this.setHandlePoint(eHandlePoint.NW.index, new Point2D.Double(x, y));
        this.setHandlePoint(eHandlePoint.N.index, new Point2D.Double(x + w / 2.0, y));
        this.setHandlePoint(eHandlePoint.NE.index, new Point2D.Double(x + w, y));
        this.setHandlePoint(eHandlePoint.E.index, new Point2D.Double(x + w, y + h / 2.0));
        this.setHandlePoint(eHandlePoint.SE.index, new Point2D.Double(x + w, y + h));
        this.setHandlePoint(eHandlePoint.S.index, new Point2D.Double(x + w / 2.0, y + h));
        this.setHandlePoint(eHandlePoint.SW.index, new Point2D.Double(x, y + h));
        this.setHandlePoint(eHandlePoint.W.index, new Point2D.Double(x, y + h / 2.0));
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseevent) {
        Rectangle2D.Double rectangle = null;
        if (this.handlePointList.size() > 1 && !this.getHandlePoint(eHandlePoint.NW.index).equals(this.getHandlePoint(eHandlePoint.SE.index))) {
            rectangle = new Rectangle2D.Double();
            rectangle.setFrameFromDiagonal(this.getHandlePoint(eHandlePoint.NW.index), this.getHandlePoint(eHandlePoint.SE.index));
        }
        this.setShape(rectangle, mouseevent);
        this.updateLabel(mouseevent, this.getDefaultView2d(mouseevent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal(this.getHandlePoint(eHandlePoint.NW.index), this.getHandlePoint(eHandlePoint.SE.index));
            double ratio = adapter.getCalibRatio();
            if (TOP_LEFT_POINT_X.isComputed() && (!drawOnLabel || TOP_LEFT_POINT_X.isGraphicLabel())) {
                val = releaseEvent || TOP_LEFT_POINT_X.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(((RectangularShape)rect).getX())) : null;
                measVal.add(new MeasureItem(TOP_LEFT_POINT_X, val, adapter.getUnit()));
            }
            if (TOP_LEFT_POINT_Y.isComputed() && (!drawOnLabel || TOP_LEFT_POINT_Y.isGraphicLabel())) {
                val = releaseEvent || TOP_LEFT_POINT_Y.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(((RectangularShape)rect).getY())) : null;
                measVal.add(new MeasureItem(TOP_LEFT_POINT_Y, val, adapter.getUnit()));
            }
            if (CENTER_X.isComputed() && (!drawOnLabel || CENTER_X.isGraphicLabel())) {
                val = releaseEvent || CENTER_X.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(rect.getCenterX())) : null;
                measVal.add(new MeasureItem(CENTER_X, val, adapter.getUnit()));
            }
            if (CENTER_Y.isComputed() && (!drawOnLabel || CENTER_Y.isGraphicLabel())) {
                val = releaseEvent || CENTER_Y.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(rect.getCenterY())) : null;
                measVal.add(new MeasureItem(CENTER_Y, val, adapter.getUnit()));
            }
            if (WIDTH.isComputed() && (!drawOnLabel || WIDTH.isGraphicLabel())) {
                val = releaseEvent || WIDTH.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getWidth()) : null;
                measVal.add(new MeasureItem(WIDTH, val, adapter.getUnit()));
            }
            if (HEIGHT.isComputed() && (!drawOnLabel || HEIGHT.isGraphicLabel())) {
                val = releaseEvent || HEIGHT.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getHeight()) : null;
                measVal.add(new MeasureItem(HEIGHT, val, adapter.getUnit()));
            }
            if (AREA.isComputed() && (!drawOnLabel || AREA.isGraphicLabel())) {
                val = null;
                if (releaseEvent || AREA.isQuickComputing()) {
                    val = ((RectangularShape)rect).getWidth() * ((RectangularShape)rect).getHeight() * ratio * ratio;
                }
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(AREA, val, unit));
            }
            if (PERIMETER.isComputed() && (!drawOnLabel || PERIMETER.isGraphicLabel())) {
                val = null;
                if (releaseEvent || PERIMETER.isQuickComputing()) {
                    val = (((RectangularShape)rect).getWidth() + ((RectangularShape)rect).getHeight()) * 2.0 * ratio;
                }
                measVal.add(new MeasureItem(PERIMETER, val, adapter.getUnit()));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }

    protected static enum eHandlePoint {
        NONE(-1),
        NW(0),
        SE(1),
        NE(2),
        SW(3),
        N(4),
        S(5),
        E(6),
        W(7);

        final int index;
        static final Map<Integer, eHandlePoint> map;

        private eHandlePoint(int index) {
            this.index = index;
        }

        static eHandlePoint valueFromIndex(int index) {
            eHandlePoint point = map.get(index);
            if (point == null) {
                throw new RuntimeException("Not a valid index for a rectangular DragGraphic : " + index);
            }
            return point;
        }

        eHandlePoint getVerticalMirror() {
            switch (this) {
                case NW: {
                    return NE;
                }
                case NE: {
                    return NW;
                }
                case W: {
                    return E;
                }
                case E: {
                    return W;
                }
                case SW: {
                    return SE;
                }
                case SE: {
                    return SW;
                }
            }
            return this;
        }

        eHandlePoint getHorizontalMirror() {
            switch (this) {
                case NW: {
                    return SW;
                }
                case SW: {
                    return NW;
                }
                case N: {
                    return S;
                }
                case S: {
                    return N;
                }
                case NE: {
                    return SE;
                }
                case SE: {
                    return NE;
                }
            }
            return this;
        }

        static {
            map = new HashMap<Integer, eHandlePoint>(eHandlePoint.values().length);
            for (eHandlePoint corner : eHandlePoint.values()) {
                map.put(corner.index, corner);
            }
        }
    }
}

