/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.RectangleGraphic;
import org.weasis.core.ui.util.MouseEventDouble;

public class SelectGraphic
extends RectangleGraphic {
    public static final Icon ICON = new ImageIcon(SelectGraphic.class.getResource("/icon/22x22/draw-selection.png"));

    public SelectGraphic(float lineThickness, Color paint) {
        super(lineThickness, paint, false);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getUIName() {
        return Messages.getString("MeasureToolBar.sel");
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform) {
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(Color.white);
        float[] dash = new float[]{5.0f};
        Shape transformedShape = transform == null ? this.shape : transform.createTransformedShape(this.shape);
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f));
        g2d.draw(transformedShape);
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 5.0f));
        g2d.draw(transformedShape);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    @Override
    public DragSequence createResizeDrag(int i) {
        return new SelectedDragSequence();
    }

    @Override
    public boolean isGraphicComplete() {
        return this.handlePointList.size() > 1;
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public void updateLabel(Object source, DefaultView2d view2d) {
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        return null;
    }

    protected class SelectedDragSequence
    extends AbstractDragGraphic.DefaultDragSequence {
        protected SelectedDragSequence() {
        }

        @Override
        public boolean completeDrag(MouseEventDouble mouseEvent) {
            SelectGraphic.this.fireRemoveAndRepaintAction();
            return true;
        }
    }
}

