/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class ThreePointsCircleGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(ThreePointsCircleGraphic.class.getResource("/icon/22x22/draw-circle.png"));
    public static final Measurement AREA = new Measurement("Area", true, true, true);
    public static final Measurement DIAMETER = new Measurement("Diameter", true, true, false);
    public static final Measurement PERIMETER = new Measurement("Perimeter", true, true, false);
    public static final Measurement CENTER_X = new Measurement("Center X", true, true, false);
    public static final Measurement CENTER_Y = new Measurement("Center Y", true, true, false);
    public static final Measurement RADIUS = new Measurement("Radius", true, true, false);
    protected Point2D centerPt;
    protected double radius;

    public ThreePointsCircleGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(3, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Three Points Circle";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Ellipse2D.Double newShape = null;
        if (this.centerPt != null && this.radius != 0.0) {
            newShape = new Ellipse2D.Double(this.centerPt.getX() - this.radius, this.centerPt.getY() - this.radius, 2.0 * this.radius, 2.0 * this.radius);
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    protected boolean isResizingOrMoving() {
        return false;
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(10);
            double ratio = adapter.getCalibRatio();
            if (CENTER_X.isComputed() && (!drawOnLabel || CENTER_X.isGraphicLabel())) {
                val = null;
                if (releaseEvent || CENTER_X.isQuickComputing()) {
                    val = adapter.getXCalibratedValue(this.centerPt.getX());
                }
                measVal.add(new MeasureItem(CENTER_X, val, adapter.getUnit()));
            }
            if (CENTER_Y.isComputed() && (!drawOnLabel || CENTER_Y.isGraphicLabel())) {
                val = null;
                if (releaseEvent || CENTER_Y.isQuickComputing()) {
                    val = adapter.getYCalibratedValue(this.centerPt.getY());
                }
                measVal.add(new MeasureItem(CENTER_Y, val, adapter.getUnit()));
            }
            if (RADIUS.isComputed() && (!drawOnLabel || RADIUS.isGraphicLabel())) {
                val = releaseEvent || RADIUS.isQuickComputing() ? Double.valueOf(ratio * this.radius) : null;
                measVal.add(new MeasureItem(RADIUS, val, adapter.getUnit()));
            }
            if (DIAMETER.isComputed() && (!drawOnLabel || DIAMETER.isGraphicLabel())) {
                val = releaseEvent || DIAMETER.isQuickComputing() ? Double.valueOf(ratio * this.radius * 2.0) : null;
                measVal.add(new MeasureItem(DIAMETER, val, adapter.getUnit()));
            }
            if (AREA.isComputed() && (!drawOnLabel || AREA.isGraphicLabel())) {
                val = null;
                if (releaseEvent || AREA.isQuickComputing()) {
                    val = Math.PI * this.radius * this.radius * ratio * ratio;
                }
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(AREA, val, unit));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }

    @Override
    public boolean isShapeValid() {
        this.updateTool();
        return super.isShapeValid() && this.centerPt != null && this.radius < 50000.0;
    }

    protected void updateTool() {
        Point2D ptA = this.getHandlePoint(0);
        this.centerPt = GeomUtil.getCircleCenter((List)this.handlePointList);
        this.radius = this.centerPt != null && ptA != null ? this.centerPt.distance(ptA) : 0.0;
    }
}

