/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.MutableComboBoxModel;

public class ArrayListComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel,
ComboBoxModel {
    private Object selectedItem;
    private final ArrayList items;

    public ArrayListComboBoxModel() {
        this.items = new ArrayList();
    }

    public ArrayListComboBoxModel(ArrayList arrayList) {
        this.items = arrayList;
    }

    public int binarySearch(Object value, Comparator comp) {
        return Collections.binarySearch(this.items, value, comp);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object newValue) {
        if (this.selectedItem != null && !this.selectedItem.equals(newValue) || this.selectedItem == null && newValue != null) {
            this.selectedItem = newValue;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    public int getIndexOf(Object anObject) {
        return this.items.indexOf(anObject);
    }

    public void addElement(Object anObject) {
        this.items.add(anObject);
        this.fireIntervalAdded(this, this.items.size() - 1, this.items.size() - 1);
        if (this.items.size() == 1 && this.selectedItem == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.items.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedItem) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.items.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.items.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.items.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.items.size() - 1;
            this.items.clear();
            this.selectedItem = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedItem = null;
        }
    }
}

