/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.util.ImagingListener;

public class EncodeRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageEncoder imageEncoder;
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
        OutputStream outputStream = (OutputStream)parameterBlock.getObjectParameter(0);
        String string = (String)parameterBlock.getObjectParameter(1);
        ImageEncodeParam imageEncodeParam = null;
        if (parameterBlock.getNumParameters() > 2) {
            imageEncodeParam = (ImageEncodeParam)parameterBlock.getObjectParameter(2);
        }
        if ((imageEncoder = ImageCodec.createImageEncoder(string, outputStream, imageEncodeParam)) == null) {
            throw new RuntimeException(JaiI18N.getString("EncodeRIF0"));
        }
        RenderedImage renderedImage = (RenderedImage)parameterBlock.getSource(0);
        try {
            imageEncoder.encode(renderedImage);
            outputStream.flush();
        }
        catch (IOException iOException) {
            String string2 = JaiI18N.getString("EncodeRIF1") + " " + string;
            imagingListener.errorOccurred(string2, iOException, this, false);
            return null;
        }
        return renderedImage;
    }
}

