/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpGeneralOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray2 = new int[n11][n10];
        int n19 = 0;
        byte[] byArray2 = new byte[n14];
        for (n = 0; n < n14; ++n) {
            byArray2[n] = (byte)this.backgroundValues[n];
        }
        if (this.ctable == null) {
            for (n = 0; n < n13; ++n) {
                int n20 = n19;
                n19 += n15;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n12, 1, fArray);
                int n21 = 0;
                for (int i = 0; i < n12; ++i) {
                    int n22;
                    float f = fArray[n21++];
                    float f2 = fArray[n21++];
                    int n23 = WarpGeneralOpImage.floor(f);
                    int n24 = WarpGeneralOpImage.floor(f2);
                    int n25 = (int)((f - (float)n23) * (float)n17);
                    int n26 = (int)((f2 - (float)n24) * (float)n18);
                    if (n23 < n5 || n23 >= n4 || n24 < n3 || n24 >= n2) {
                        if (this.setBackground) {
                            for (n22 = 0; n22 < n14; ++n22) {
                                byArray[n22][n20 + nArray[n22]] = byArray2[n22];
                            }
                        }
                    } else {
                        n23 -= n9;
                        n24 -= n7;
                        for (n22 = 0; n22 < n14; ++n22) {
                            for (int j = 0; j < n11; ++j) {
                                for (int k = 0; k < n10; ++k) {
                                    nArray2[j][k] = randomIter.getSample(n23 + k, n24 + j, n22) & 0xFF;
                                }
                            }
                            byArray[n22][n20 + nArray[n22]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n25, n26));
                        }
                    }
                    n20 += n16;
                }
            }
        } else {
            for (n = 0; n < n13; ++n) {
                int n27 = n19;
                n19 += n15;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n12, 1, fArray);
                int n28 = 0;
                for (int i = 0; i < n12; ++i) {
                    int n29;
                    float f = fArray[n28++];
                    float f3 = fArray[n28++];
                    int n30 = WarpGeneralOpImage.floor(f);
                    int n31 = WarpGeneralOpImage.floor(f3);
                    int n32 = (int)((f - (float)n30) * (float)n17);
                    int n33 = (int)((f3 - (float)n31) * (float)n18);
                    if (n30 < n5 || n30 >= n4 || n31 < n3 || n31 >= n2) {
                        if (this.setBackground) {
                            for (n29 = 0; n29 < n14; ++n29) {
                                byArray[n29][n27 + nArray[n29]] = byArray2[n29];
                            }
                        }
                    } else {
                        n30 -= n9;
                        n31 -= n7;
                        for (n29 = 0; n29 < n14; ++n29) {
                            byte[] byArray3 = this.ctable[n29];
                            for (int j = 0; j < n11; ++j) {
                                for (int k = 0; k < n10; ++k) {
                                    nArray2[j][k] = byArray3[randomIter.getSample(n30 + k, n31 + j, 0) & 0xFF] & 0xFF;
                                }
                            }
                            byArray[n29][n27 + nArray[n29]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n32, n33));
                        }
                    }
                    n27 += n16;
                }
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray2 = new int[n11][n10];
        int n19 = 0;
        short[] sArray2 = new short[n14];
        for (n = 0; n < n14; ++n) {
            sArray2[n] = (short)this.backgroundValues[n];
        }
        for (n = 0; n < n13; ++n) {
            int n20 = n19;
            n19 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n12, 1, fArray);
            int n21 = 0;
            for (int i = 0; i < n12; ++i) {
                int n22;
                float f = fArray[n21++];
                float f2 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f);
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = (int)((f - (float)n23) * (float)n17);
                int n26 = (int)((f2 - (float)n24) * (float)n18);
                if (n23 < n5 || n23 >= n4 || n24 < n3 || n24 >= n2) {
                    if (this.setBackground) {
                        for (n22 = 0; n22 < n14; ++n22) {
                            sArray[n22][n20 + nArray[n22]] = sArray2[n22];
                        }
                    }
                } else {
                    n23 -= n9;
                    n24 -= n7;
                    for (n22 = 0; n22 < n14; ++n22) {
                        for (int j = 0; j < n11; ++j) {
                            for (int k = 0; k < n10; ++k) {
                                nArray2[j][k] = randomIter.getSample(n23 + k, n24 + j, n22) & 0xFFFF;
                            }
                        }
                        sArray[n22][n20 + nArray[n22]] = ImageUtil.clampUShort(this.interp.interpolate(nArray2, n25, n26));
                    }
                }
                n20 += n16;
            }
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray2 = new int[n11][n10];
        int n19 = 0;
        short[] sArray2 = new short[n14];
        for (n = 0; n < n14; ++n) {
            sArray2[n] = (short)this.backgroundValues[n];
        }
        for (n = 0; n < n13; ++n) {
            int n20 = n19;
            n19 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n12, 1, fArray);
            int n21 = 0;
            for (int i = 0; i < n12; ++i) {
                int n22;
                float f = fArray[n21++];
                float f2 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f);
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = (int)((f - (float)n23) * (float)n17);
                int n26 = (int)((f2 - (float)n24) * (float)n18);
                if (n23 < n5 || n23 >= n4 || n24 < n3 || n24 >= n2) {
                    if (this.setBackground) {
                        for (n22 = 0; n22 < n14; ++n22) {
                            sArray[n22][n20 + nArray[n22]] = sArray2[n22];
                        }
                    }
                } else {
                    n23 -= n9;
                    n24 -= n7;
                    for (n22 = 0; n22 < n14; ++n22) {
                        for (int j = 0; j < n11; ++j) {
                            for (int k = 0; k < n10; ++k) {
                                nArray2[j][k] = randomIter.getSample(n23 + k, n24 + j, n22);
                            }
                        }
                        sArray[n22][n20 + nArray[n22]] = ImageUtil.clampShort(this.interp.interpolate(nArray2, n25, n26));
                    }
                }
                n20 += n16;
            }
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray3 = new int[n11][n10];
        int n19 = 0;
        int[] nArray4 = new int[n14];
        for (n = 0; n < n14; ++n) {
            nArray4[n] = (int)this.backgroundValues[n];
        }
        for (n = 0; n < n13; ++n) {
            int n20 = n19;
            n19 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n12, 1, fArray);
            int n21 = 0;
            for (int i = 0; i < n12; ++i) {
                int n22;
                float f = fArray[n21++];
                float f2 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f);
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = (int)((f - (float)n23) * (float)n17);
                int n26 = (int)((f2 - (float)n24) * (float)n18);
                if (n23 < n5 || n23 >= n4 || n24 < n3 || n24 >= n2) {
                    if (this.setBackground) {
                        for (n22 = 0; n22 < n14; ++n22) {
                            nArray2[n22][n20 + nArray[n22]] = nArray4[n22];
                        }
                    }
                } else {
                    n23 -= n9;
                    n24 -= n7;
                    for (n22 = 0; n22 < n14; ++n22) {
                        for (int j = 0; j < n11; ++j) {
                            for (int k = 0; k < n10; ++k) {
                                nArray3[j][k] = randomIter.getSample(n23 + k, n24 + j, n22);
                            }
                        }
                        nArray2[n22][n20 + nArray[n22]] = this.interp.interpolate(nArray3, n25, n26);
                    }
                }
                n20 += n16;
            }
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n12];
        float[][] fArray3 = new float[n11][n10];
        int n17 = 0;
        float[] fArray4 = new float[n14];
        for (n = 0; n < n14; ++n) {
            fArray4[n] = (float)this.backgroundValues[n];
        }
        for (n = 0; n < n13; ++n) {
            int n18 = n17;
            n17 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n12, 1, fArray2);
            int n19 = 0;
            for (int i = 0; i < n12; ++i) {
                int n20;
                float f = fArray2[n19++];
                float f2 = fArray2[n19++];
                int n21 = WarpGeneralOpImage.floor(f);
                int n22 = WarpGeneralOpImage.floor(f2);
                float f3 = f - (float)n21;
                float f4 = f2 - (float)n22;
                if (n21 < n5 || n21 >= n4 || n22 < n3 || n22 >= n2) {
                    if (this.setBackground) {
                        for (n20 = 0; n20 < n14; ++n20) {
                            fArray[n20][n18 + nArray[n20]] = fArray4[n20];
                        }
                    }
                } else {
                    n21 -= n9;
                    n22 -= n7;
                    for (n20 = 0; n20 < n14; ++n20) {
                        for (int j = 0; j < n11; ++j) {
                            for (int k = 0; k < n10; ++k) {
                                fArray3[j][k] = randomIter.getSampleFloat(n21 + k, n22 + j, n20);
                            }
                        }
                        fArray[n20][n18 + nArray[n20]] = this.interp.interpolate(fArray3, f3, f4);
                    }
                }
                n18 += n16;
            }
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n11];
        double[][] dArray2 = new double[n10][n9];
        int n16 = 0;
        for (int i = 0; i < n12; ++i) {
            int n17 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + i, n11, 1, fArray);
            int n18 = 0;
            for (int j = 0; j < n11; ++j) {
                int n19;
                float f = fArray[n18++];
                float f2 = fArray[n18++];
                int n20 = WarpGeneralOpImage.floor(f);
                int n21 = WarpGeneralOpImage.floor(f2);
                float f3 = f - (float)n20;
                float f4 = f2 - (float)n21;
                if (n20 < n4 || n20 >= n3 || n21 < n2 || n21 >= n) {
                    if (this.setBackground) {
                        for (n19 = 0; n19 < n13; ++n19) {
                            dArray[n19][n17 + nArray[n19]] = this.backgroundValues[n19];
                        }
                    }
                } else {
                    n20 -= n8;
                    n21 -= n6;
                    for (n19 = 0; n19 < n13; ++n19) {
                        for (int k = 0; k < n10; ++k) {
                            for (int i2 = 0; i2 < n9; ++i2) {
                                dArray2[k][i2] = randomIter.getSampleDouble(n20 + i2, n21 + k, n19);
                            }
                        }
                        dArray[n19][n17 + nArray[n19]] = this.interp.interpolate(dArray2, f3, f4);
                    }
                }
                n17 += n15;
            }
        }
    }

    private static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }
}

