/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowGroup;
import org.noos.xing.mydoggy.ToolWindowGroupListener;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.event.ToolWindowGroupEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

public class MyDoggyToolWindowGroup
implements ToolWindowGroup {
    protected MyDoggyToolWindowManager manager;
    protected String name;
    protected List<ToolWindow> tools;
    protected EventListenerList listenerList;
    protected boolean implicit;
    protected boolean tempGroup;
    protected boolean activeteTool;

    public MyDoggyToolWindowGroup(MyDoggyToolWindowManager manager, String name, boolean tempGroup) {
        this.manager = manager;
        this.name = name;
        this.tools = new ArrayList<ToolWindow>();
        this.listenerList = new EventListenerList();
        this.implicit = false;
        this.tempGroup = tempGroup;
        this.activeteTool = true;
    }

    public String getName() {
        return this.name;
    }

    public void addToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new NullPointerException("ToolWindow cannot be null.");
        }
        if (this.tools.contains(toolWindow)) {
            throw new IllegalArgumentException("This group already contains passed tool window. [tool id : " + toolWindow.getId() + ", group : " + this.name + "]");
        }
        this.tools.add(toolWindow);
        this.fireAddedTool(toolWindow);
    }

    public boolean removeToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new NullPointerException("ToolWindow cannot be null.");
        }
        boolean removed = this.tools.remove(toolWindow);
        if (removed) {
            this.fireRemovedTool(toolWindow);
        }
        return removed;
    }

    public ToolWindow[] getToolsWindow() {
        return this.tools.toArray(new ToolWindow[this.tools.size()]);
    }

    public boolean containesToolWindow(ToolWindow toolWindow) {
        return this.tools.contains(toolWindow);
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        if (this.tempGroup || this.manager.containsGroup(this.name)) {
            Object object = this.manager.sync;
            synchronized (object) {
                boolean doAction = false;
                for (ToolWindow tool : this.getToolsWindow()) {
                    if (tool.isVisible() == visible) continue;
                    doAction = true;
                    break;
                }
                if (doAction) {
                    for (ToolWindow tool : this.manager.getToolWindows()) {
                        if (tool.getType() == ToolWindowType.EXTERN) continue;
                        tool.setVisible(false);
                    }
                    if (visible) {
                        this.manager.setShowingGroup(this);
                        try {
                            this.showTool(ToolWindowAnchor.LEFT);
                            this.showTool(ToolWindowAnchor.TOP);
                            this.showTool(ToolWindowAnchor.RIGHT);
                            this.showTool(ToolWindowAnchor.BOTTOM);
                        }
                        finally {
                            this.manager.setShowingGroup(null);
                        }
                    }
                    if (visible) {
                        this.fireGroupShown();
                    } else {
                        this.fireGroupHidden();
                    }
                }
                if (this.activeteTool && visible && this.tools.size() > 0) {
                    this.tools.get(0).setActive(true);
                }
            }
        }
    }

    public void addToolWindowGroupListener(ToolWindowGroupListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.add(ToolWindowGroupListener.class, listener);
    }

    public void removeToolWindowGroupListener(ToolWindowGroupListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.remove(ToolWindowGroupListener.class, listener);
    }

    public ToolWindowGroupListener[] getToolWindowGroupListeners() {
        return (ToolWindowGroupListener[])this.listenerList.getListeners(ToolWindowGroupListener.class);
    }

    public String toString() {
        return "MyDoggyToolWindowGroup{name='" + this.name + '\'' + ", tools=" + this.tools + '}';
    }

    public boolean isActiveteTool() {
        return this.activeteTool;
    }

    public void setActiveteTool(boolean activeteTool) {
        this.activeteTool = activeteTool;
    }

    protected void fireGroupShown() {
        ToolWindowGroupEvent event = new ToolWindowGroupEvent(this.manager, ToolWindowGroupEvent.ActionId.GROUP_SHOWN, this);
        for (ToolWindowGroupListener listener : (ToolWindowGroupListener[])this.listenerList.getListeners(ToolWindowGroupListener.class)) {
            listener.groupShown(event);
        }
    }

    protected void fireGroupHidden() {
        ToolWindowGroupEvent event = new ToolWindowGroupEvent(this.manager, ToolWindowGroupEvent.ActionId.GROUP_HIDDEN, this);
        for (ToolWindowGroupListener listener : (ToolWindowGroupListener[])this.listenerList.getListeners(ToolWindowGroupListener.class)) {
            listener.groupHidden(event);
        }
    }

    protected void fireAddedTool(ToolWindow toolWindow) {
        ToolWindowGroupEvent event = new ToolWindowGroupEvent(this.manager, ToolWindowGroupEvent.ActionId.TOOL_ADDED, this, toolWindow);
        for (ToolWindowGroupListener listener : (ToolWindowGroupListener[])this.listenerList.getListeners(ToolWindowGroupListener.class)) {
            listener.toolAdded(event);
        }
    }

    protected void fireRemovedTool(ToolWindow toolWindow) {
        ToolWindowGroupEvent event = new ToolWindowGroupEvent(this.manager, ToolWindowGroupEvent.ActionId.TOOL_REMOVED, this, toolWindow);
        for (ToolWindowGroupListener listener : (ToolWindowGroupListener[])this.listenerList.getListeners(ToolWindowGroupListener.class)) {
            listener.toolRemoved(event);
        }
    }

    protected void showTool(ToolWindowAnchor anchor) {
        for (ToolWindow tool : this.getToolsWindow()) {
            if (tool.getAnchor() != anchor) continue;
            if (tool.getType() == ToolWindowType.SLIDING) {
                tool.setType(ToolWindowType.DOCKED);
            }
            tool.aggregate();
        }
    }
}

