/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.XmlHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class BundleComponentActivator
implements Logger {
    private ComponentRegistry m_componentRegistry;
    private BundleContext m_context = null;
    private List m_managers = new ArrayList();
    private ServiceTracker m_logService;
    private ComponentActorThread m_componentActor;
    private boolean m_active;
    private ScrConfiguration m_configuration;

    BundleComponentActivator(ComponentRegistry componentRegistry, ComponentActorThread componentActor, BundleContext context, ScrConfiguration configuration) throws ComponentException {
        this.m_componentRegistry = componentRegistry;
        this.m_componentActor = componentActor;
        this.m_context = context;
        this.m_active = true;
        this.m_logService = new ServiceTracker(context, "org.osgi.service.log.LogService", null);
        this.m_logService.open();
        this.m_configuration = configuration;
        String descriptorLocations = (String)this.m_context.getBundle().getHeaders().get("Service-Component");
        if (descriptorLocations == null) {
            throw new ComponentException("Service-Component entry not found in the manifest");
        }
        this.initialize(descriptorLocations);
    }

    private void initialize(String descriptorLocations) {
        StringTokenizer st = new StringTokenizer(descriptorLocations, ", ");
        while (st.hasMoreTokens()) {
            String descriptorLocation = st.nextToken();
            URL[] descriptorURLs = BundleComponentActivator.findDescriptors(this.m_context.getBundle(), descriptorLocation);
            if (descriptorURLs.length == 0) {
                this.log(1, "Component descriptor entry ''{0}'' not found", new Object[]{descriptorLocation}, null, null);
                continue;
            }
            for (int i = 0; i < descriptorURLs.length; ++i) {
                this.loadDescriptor(descriptorURLs[i]);
            }
        }
    }

    static URL[] findDescriptors(Bundle bundle, String descriptorLocation) {
        String filePattern;
        String path;
        if (bundle == null || descriptorLocation == null || descriptorLocation.trim().length() == 0) {
            return new URL[0];
        }
        if (descriptorLocation.indexOf("*") == -1) {
            URL descriptor = bundle.getResource(descriptorLocation);
            if (descriptor == null) {
                return new URL[0];
            }
            return new URL[]{descriptor};
        }
        int lios = descriptorLocation.lastIndexOf("/");
        if (lios > 0) {
            path = descriptorLocation.substring(0, lios);
            filePattern = descriptorLocation.substring(lios + 1);
        } else {
            path = "/";
            filePattern = descriptorLocation;
        }
        Enumeration entries = bundle.findEntries(path, filePattern, false);
        if (entries == null || !entries.hasMoreElements()) {
            return new URL[0];
        }
        ArrayList urls = new ArrayList();
        while (entries.hasMoreElements()) {
            urls.add(entries.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptor(URL descriptorURL) {
        String descriptorLocation = descriptorURL.getPath();
        InputStream stream = null;
        try {
            stream = descriptorURL.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            XmlHandler handler = new XmlHandler(this.m_context.getBundle(), this);
            KXml2SAXParser parser = new KXml2SAXParser(in);
            parser.parseXML(handler);
            Iterator i = handler.getComponentMetadataList().iterator();
            while (i.hasNext()) {
                ComponentMetadata metadata = (ComponentMetadata)i.next();
                try {
                    this.m_componentRegistry.checkComponentName(metadata.getName());
                    metadata.validate(this);
                    ComponentHolder holder = this.m_componentRegistry.createComponentHolder(this, metadata);
                    this.m_componentRegistry.registerComponentHolder(metadata.getName(), holder);
                    this.m_managers.add(holder);
                    if (!metadata.isEnabled()) continue;
                    holder.enableComponents();
                }
                catch (Throwable t) {
                    this.log(1, "Cannot register Component", metadata, t);
                    this.m_componentRegistry.unregisterComponentHolder(metadata.getName());
                }
            }
        }
        catch (IOException ex) {
            this.log(1, "Problem reading descriptor entry ''{0}''", new Object[]{descriptorLocation}, null, ex);
        }
        catch (Exception ex) {
            this.log(1, "General problem with descriptor entry ''{0}''", new Object[]{descriptorLocation}, null, ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(int reason) {
        if (this.m_context == null) {
            return;
        }
        this.m_active = false;
        this.log(4, "BundleComponentActivator : Bundle [{0}] will destroy {1} instances", new Object[]{new Long(this.m_context.getBundle().getBundleId()), new Integer(this.m_managers.size())}, null, null);
        while (this.m_managers.size() != 0) {
            ComponentHolder holder = (ComponentHolder)this.m_managers.get(0);
            try {
                this.m_managers.remove(holder);
                holder.disposeComponents(reason);
            }
            catch (Exception e) {
                this.log(1, "BundleComponentActivator : Exception invalidating", holder.getComponentMetadata(), e);
            }
            finally {
                this.m_componentRegistry.unregisterComponentHolder(holder.getComponentMetadata().getName());
            }
        }
        this.log(4, "BundleComponentActivator : Bundle [{0}] STOPPED", new Object[]{new Long(this.m_context.getBundle().getBundleId())}, null, null);
        if (this.m_logService != null) {
            this.m_logService.close();
            this.m_logService = null;
        }
        this.m_componentActor = null;
        this.m_componentRegistry = null;
        this.m_context = null;
    }

    boolean isActive() {
        return this.m_active;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public ScrConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public void enableComponent(final String name) {
        final ComponentHolder[] holder = this.getSelectedComponents(name);
        if (holder == null) {
            return;
        }
        this.schedule(new Runnable(){

            public void run() {
                for (int i = 0; i < holder.length; ++i) {
                    try {
                        BundleComponentActivator.this.log(4, "Enabling Component", holder[i].getComponentMetadata(), null);
                        holder[i].enableComponents();
                        continue;
                    }
                    catch (Throwable t) {
                        BundleComponentActivator.this.log(1, "Cannot enable component", holder[i].getComponentMetadata(), t);
                    }
                }
            }

            public String toString() {
                return "enableComponent(" + name + ")";
            }
        });
    }

    public void disableComponent(final String name) {
        final ComponentHolder[] holder = this.getSelectedComponents(name);
        if (holder == null) {
            return;
        }
        this.schedule(new Runnable(){

            public void run() {
                for (int i = 0; i < holder.length; ++i) {
                    try {
                        BundleComponentActivator.this.log(4, "Disabling Component", holder[i].getComponentMetadata(), null);
                        holder[i].disableComponents();
                        continue;
                    }
                    catch (Throwable t) {
                        BundleComponentActivator.this.log(1, "Cannot disable component", holder[i].getComponentMetadata(), t);
                    }
                }
            }

            public String toString() {
                return "disableComponent(" + name + ")";
            }
        });
    }

    private ComponentHolder[] getSelectedComponents(String name) {
        if (name == null) {
            return this.m_managers.toArray(new ComponentHolder[this.m_managers.size()]);
        }
        if (this.m_componentRegistry.getComponentHolder(name) != null) {
            Iterator it = this.m_managers.iterator();
            while (it.hasNext()) {
                ComponentHolder cm = (ComponentHolder)it.next();
                if (!name.equals(cm.getComponentMetadata().getName())) continue;
                return new ComponentHolder[]{cm};
            }
        }
        return null;
    }

    public long registerComponentId(AbstractComponentManager componentManager) {
        return this.m_componentRegistry.registerComponentId(componentManager);
    }

    public void unregisterComponentId(AbstractComponentManager componentManager) {
        this.m_componentRegistry.unregisterComponentId(componentManager.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable task) {
        if (this.isActive()) {
            ComponentActorThread cat = this.m_componentActor;
            if (cat != null) {
                cat.schedule(task);
            } else {
                this.log(3, "Component Actor Thread not running, calling synchronously", null, null);
                try {
                    BundleComponentActivator bundleComponentActivator = this;
                    synchronized (bundleComponentActivator) {
                        task.run();
                    }
                }
                catch (Throwable t) {
                    this.log(3, "Unexpected problem executing task", null, t);
                }
            }
        } else {
            this.log(3, "BundleComponentActivator is not active; not scheduling {0}", new Object[]{task}, null, null);
        }
    }

    public boolean isLogEnabled(int level) {
        return this.m_configuration.getLogLevel() >= level;
    }

    public void log(int level, String pattern, Object[] arguments, ComponentMetadata metadata, Throwable ex) {
        if (this.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            this.log(level, message, metadata, ex);
        }
    }

    public void log(int level, String message, ComponentMetadata metadata, Throwable ex) {
        if (this.isLogEnabled(level)) {
            Object logger;
            if (metadata != null) {
                message = "[" + metadata.getName() + "] " + message;
            }
            if ((logger = this.m_logService.getService()) == null) {
                Activator.log(level, this.getBundleContext().getBundle(), message, ex);
            } else {
                ((LogService)logger).log(level, message, ex);
            }
        }
    }
}

