/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import org.weasis.core.api.gui.util.PageProps;

public abstract class AbstractItemDialogPage
extends JPanel
implements PageProps {
    protected static final AtomicInteger keyGenerator = new AtomicInteger(0);
    private final String key = String.valueOf(keyGenerator.incrementAndGet());
    private String title;
    private List<PageProps> subPageList;

    @Override
    public abstract void resetoDefaultValues();

    @Override
    public abstract void closeAdditionalWindow();

    public void deselectPageAction() {
    }

    public void selectPageAction() {
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addSubPage(PageProps subPage) {
        if (this.subPageList == null) {
            this.subPageList = new ArrayList<PageProps>();
        }
        this.subPageList.add(subPage);
    }

    public void removeSubPage(PageProps subPage) {
        if (this.subPageList == null) {
            return;
        }
        this.subPageList.remove(subPage);
    }

    @Override
    public PageProps[] getSubPages() {
        if (this.subPageList == null) {
            return null;
        }
        PageProps[] subPages = new PageProps[this.subPageList.size()];
        this.subPageList.toArray(subPages);
        return subPages;
    }

    public void resetAllSubPagesToDefaultValues() {
        if (this.subPageList == null) {
            return;
        }
        for (PageProps subPage : this.subPageList) {
            subPage.resetoDefaultValues();
        }
    }

    @Override
    public String toString() {
        return this.title;
    }
}

