/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import org.weasis.core.api.gui.util.ComboBoxModelAdapter;
import org.weasis.core.api.gui.util.GUIEntry;
import org.weasis.core.api.gui.util.RadioMenuItem;

public class GroupRadioMenu
implements ActionListener,
ComboBoxModelAdapter {
    protected final List<RadioMenuItem> itemList = new ArrayList<RadioMenuItem>();
    protected ComboBoxModel dataModel;

    private void init() {
        this.itemList.clear();
        Object selectedItem = this.dataModel.getSelectedItem();
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            Object object = this.dataModel.getElementAt(i);
            Icon icon = null;
            if (object instanceof GUIEntry) {
                icon = ((GUIEntry)object).getIcon();
            }
            RadioMenuItem radioMenuItem = new RadioMenuItem(object.toString(), icon, object);
            radioMenuItem.setSelected(object == selectedItem);
            group.add(radioMenuItem);
            radioMenuItem.addActionListener(this);
            this.itemList.add(radioMenuItem);
        }
    }

    public JMenu fillMenu(JMenu menu) {
        menu.removeAll();
        for (int i = 0; i < this.itemList.size(); ++i) {
            menu.add(this.itemList.get(i));
        }
        return menu;
    }

    public JPopupMenu createJPopupMenu() {
        JPopupMenu popupMouseButtons = new JPopupMenu();
        for (int i = 0; i < this.itemList.size(); ++i) {
            popupMouseButtons.add(this.itemList.get(i));
        }
        return popupMouseButtons;
    }

    public JMenu createMenu(String title) {
        JMenu menu = new JMenu(title);
        for (int i = 0; i < this.itemList.size(); ++i) {
            menu.add(this.itemList.get(i));
        }
        return menu;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.setSelected(this.dataModel.getSelectedItem());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RadioMenuItem item;
        if (e.getSource() instanceof RadioMenuItem && (item = (RadioMenuItem)e.getSource()).isSelected()) {
            this.dataModel.setSelectedItem(item.getObject());
        }
    }

    public void setSelected(Object selected) {
        if (selected != null) {
            for (int i = 0; i < this.itemList.size(); ++i) {
                RadioMenuItem item = this.itemList.get(i);
                if (item.getObject() != selected) continue;
                item.setSelected(true);
                this.dataModel.setSelectedItem(item.getObject());
                return;
            }
        }
    }

    public int getSelectedIndex() {
        Object sObject = this.dataModel.getSelectedItem();
        int c = this.dataModel.getSize();
        for (int i = 0; i < c; ++i) {
            Object obj = this.dataModel.getElementAt(i);
            if (obj == null || !obj.equals(sObject)) continue;
            return i;
        }
        return -1;
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    @Override
    public void setModel(ComboBoxModel dataModel) {
        boolean changeListener;
        boolean bl = changeListener = dataModel != null && dataModel != this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
        this.dataModel = dataModel == null ? new DefaultComboBoxModel() : dataModel;
        this.init();
        if (changeListener) {
            this.dataModel.addListDataListener(this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            this.itemList.get(i).setEnabled(enabled);
        }
    }
}

