/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import com.sun.media.jai.util.ImageUtil;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.CompositeDescriptor;
import javax.media.jai.operator.CropDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.util.ImageFiler;

public class combineTwoImagesOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(combineTwoImagesOperation.class);
    public static final String name = "CombineImage";

    @Override
    public String getOperationName() {
        return name;
    }

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        RenderedImage source2 = (RenderedImage)imageOperation.getActionValue(name);
        if (source2 == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else {
            this.result = combineTwoImagesOperation.combineTwoImages(source, source2, 255);
        }
        return this.result;
    }

    public static PlanarImage combineTwoImages(RenderedImage sourceDown, RenderedImage sourceUp, int transparency) {
        Byte[] bandValues = new Byte[sourceDown.getSampleModel().getNumBands()];
        for (int i = 0; i < bandValues.length; ++i) {
            bandValues[i] = (byte)transparency;
        }
        PlanarImage alpha1 = ImageFiler.getEmptyImage(bandValues, (float)sourceDown.getWidth(), (float)sourceDown.getHeight());
        ParameterBlock pb = new ParameterBlock();
        if (sourceDown.getSampleModel().getNumBands() < sourceUp.getSampleModel().getNumBands()) {
            sourceDown = combineTwoImagesOperation.convertBinaryToColor(sourceDown);
        } else if (sourceUp.getSampleModel().getNumBands() < sourceDown.getSampleModel().getNumBands()) {
            sourceUp = combineTwoImagesOperation.convertBinaryToColor(sourceUp);
        }
        if (sourceDown.getWidth() < sourceUp.getWidth() || sourceDown.getHeight() < sourceUp.getHeight()) {
            sourceUp = CropDescriptor.create((RenderedImage)sourceUp, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(sourceDown.getWidth()), (Float)Float.valueOf(sourceDown.getHeight()), null);
        }
        pb.addSource(combineTwoImagesOperation.formatIfBinary(sourceDown));
        pb.addSource(alpha1);
        pb.add(combineTwoImagesOperation.formatIfBinary(sourceUp));
        pb.add(null);
        pb.add(false);
        pb.add(CompositeDescriptor.NO_DESTINATION_ALPHA);
        return JAI.create((String)"composite", (ParameterBlock)pb, null);
    }

    public static RenderedImage formatIfBinary(RenderedImage src) {
        if (src != null && ImageUtil.isBinary((SampleModel)src.getSampleModel())) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(src);
            return JAI.create((String)"formatbinary", (ParameterBlock)pb, null);
        }
        return src;
    }

    public static PlanarImage convertBinaryToColor(RenderedImage src) {
        RenderedImage img = combineTwoImagesOperation.formatIfBinary(src);
        ParameterBlockJAI pb2 = new ParameterBlockJAI("bandMerge");
        pb2.addSource((Object)img);
        pb2.addSource((Object)img);
        pb2.addSource((Object)img);
        return JAI.create((String)"bandMerge", (ParameterBlock)pb2);
    }
}

