/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.renderable.ParameterBlock;
import java.util.Hashtable;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.util.JMVUtils;

public class Contrast
extends JPanel {
    public static final String[] sliderLabels = new String[]{"Low -127", "0", "High 127"};
    public static final String[] gammaLabels = new String[]{"0.01", "1", "2"};
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JSlider jSliderContrast = new JSlider(-127, 127, 0);
    private JSlider jSliderLum = new JSlider(-127, 127, 0);
    private JSlider jSliderGamma = new JSlider(1, 200, 100);
    private TitledBorder title1 = new TitledBorder("Contrast : 0");
    private TitledBorder title2 = new TitledBorder("Luminosity : 0");
    private TitledBorder title3 = new TitledBorder("Gamma : 1");
    private JButton jButtonReset = new JButton();
    private ChangeListener sliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Contrast.this.updateValues();
        }
    };

    public Contrast() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        Hashtable<Integer, JLabel> glabels = new Hashtable<Integer, JLabel>();
        int[] gammaVal = new int[]{1, 100, 200};
        int label = -127;
        int k = 0;
        while (label < 128) {
            JLabel aLabel = new JLabel(sliderLabels[k]);
            labels.put(label, aLabel);
            JLabel gLabel = new JLabel(gammaLabels[k]);
            glabels.put(gammaVal[k], gLabel);
            label += 127;
            ++k;
        }
        this.jSliderContrast.setMajorTickSpacing(127);
        this.jSliderContrast.setPaintTicks(true);
        this.jSliderContrast.setLabelTable(labels);
        this.jSliderContrast.setPaintLabels(true);
        this.jSliderContrast.setBorder(this.title1);
        JMVUtils.setPreferredWidth(this.jSliderContrast, 80);
        this.jSliderContrast.addChangeListener(this.sliderListener);
        this.jSliderLum.setMajorTickSpacing(127);
        this.jSliderLum.setPaintTicks(true);
        this.jSliderLum.setLabelTable(labels);
        this.jSliderLum.setPaintLabels(true);
        this.jSliderLum.setBorder(this.title2);
        JMVUtils.setPreferredWidth(this.jSliderLum, 80);
        this.jSliderLum.addChangeListener(this.sliderListener);
        this.jSliderGamma.setMajorTickSpacing(99);
        this.jSliderGamma.setPaintTicks(true);
        this.jSliderGamma.setLabelTable(glabels);
        this.jSliderGamma.setPaintLabels(true);
        this.jSliderGamma.setBorder(this.title3);
        JMVUtils.setPreferredWidth(this.jSliderGamma, 80);
        this.jSliderGamma.addChangeListener(this.sliderListener);
        this.jButtonReset.setText(Messages.getString("Contrast.reset"));
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Contrast.this.reset();
            }
        });
        this.add((Component)this.jSliderContrast, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.jSliderLum, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.jSliderGamma, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.jButtonReset, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 10, 20), 0, 0));
    }

    public final void reset() {
        this.setSliderValues(0, 0, 100);
    }

    public void addSilersListener(ChangeListener sliderListener) {
        this.jSliderContrast.addChangeListener(sliderListener);
        this.jSliderLum.addChangeListener(sliderListener);
        this.jSliderGamma.addChangeListener(sliderListener);
    }

    public static final PlanarImage getRescaledImage(PlanarImage image, double slope, double y_int) {
        if (image == null) {
            return null;
        }
        RenderedOp dst = null;
        int bands = image.getSampleModel().getNumBands();
        double[] slopes = new double[bands];
        double[] y_ints = new double[bands];
        for (int i = 0; i < bands; ++i) {
            slopes[i] = slope;
            y_ints[i] = y_int;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(slopes);
        pb.add(y_ints);
        dst = JAI.create((String)"rescale", (ParameterBlock)pb, null);
        pb = new ParameterBlock();
        pb.addSource(dst);
        pb.add(0);
        dst = JAI.create((String)"format", (ParameterBlock)pb, null);
        return dst;
    }

    private void updateValues() {
        this.title1.setTitle(Messages.getString("Contrast.contrast") + this.jSliderContrast.getValue() + " ");
        this.title2.setTitle(Messages.getString("Contrast.lum") + this.jSliderLum.getValue() + " ");
        this.title3.setTitle(Messages.getString("Contrast.gamma") + (float)this.jSliderGamma.getValue() / 100.0f + " ");
        this.jSliderContrast.repaint();
        this.jSliderLum.repaint();
        this.jSliderGamma.repaint();
    }

    public PlanarImage updateSlider(PlanarImage image) {
        image = Contrast.setBrightness(image, this.jSliderLum.getValue());
        return image;
    }

    public void setSliderValues(int brightness, int contrast, int gamma) {
        this.jSliderContrast.setValue(contrast);
        this.jSliderLum.setValue(brightness);
        this.jSliderGamma.setValue(gamma);
    }

    public static PlanarImage setBrightness(PlanarImage image, int value) {
        if (value == 0) {
            return image;
        }
        double[] adjConstants = new double[]{value};
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(adjConstants);
        return JAI.create((String)"addconst", (ParameterBlock)pb, null);
    }

    private static byte[][] createGammaLUT(float f, int nbBand) {
        byte[][] lut = new byte[nbBand][256];
        for (int i = 0; i < 256; ++i) {
            int j = (int)(Math.pow((float)i / 255.0f, f) * 255.0);
            if (j > 255) {
                j = 255;
            } else if (j < 0) {
                j = 0;
            }
            for (int k = 0; k < lut.length; ++k) {
                lut[k][i] = (byte)j;
            }
        }
        return lut;
    }
}

