/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.felix.prefs.BackingStore;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.weasis.core.api.util.EscapeChars;
import org.weasis.core.api.util.FileUtil;

public abstract class StreamBackingStoreImpl
implements BackingStore {
    protected final BundleContext bundleContext;

    public StreamBackingStoreImpl(BundleContext context) {
        this.bundleContext = context;
    }

    protected abstract void checkAccess() throws BackingStoreException;

    protected abstract OutputStream getOutputStream(PreferencesDescription var1) throws IOException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(PreferencesImpl prefs) throws BackingStoreException {
        if (!this.hasChanges(prefs)) {
            return;
        }
        this.checkAccess();
        PreferencesImpl savedData = null;
        try {
            savedData = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
        }
        catch (BackingStoreException e1) {
            // empty catch block
        }
        if (savedData != null) {
            PreferencesImpl n = savedData.getOrCreateNode(prefs.absolutePath());
            n.applyChanges(prefs);
            prefs = n;
        }
        PreferencesImpl root = prefs.getRoot();
        XMLStreamWriter writer = null;
        try {
            OutputStream os = this.getOutputStream(root.getDescription());
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            writer = factory.createXMLStreamWriter(os, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("preferences");
            this.write(root, writer);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (IOException ioe) {
            try {
                throw new BackingStoreException("Unable to store preferences.", (Throwable)ioe);
                catch (XMLStreamException e) {
                    throw new BackingStoreException("Unable to store preferences.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(writer);
                throw throwable;
            }
        }
        FileUtil.safeClose(writer);
    }

    protected boolean hasChanges(PreferencesImpl prefs) {
        if (prefs.getChangeSet().hasChanges()) {
            return true;
        }
        for (PreferencesImpl current : prefs.getChildren()) {
            if (!this.hasChanges(current)) continue;
            return true;
        }
        return false;
    }

    public void update(PreferencesImpl prefs) throws BackingStoreException {
    }

    protected void write(PreferencesImpl prefs, XMLStreamWriter writer) throws XMLStreamException {
        int size = prefs.getProperties().size();
        if (size > 0) {
            this.writePreferences(prefs, writer);
        }
        Collection children = prefs.getChildren();
        for (PreferencesImpl child : children) {
            writer.writeStartElement(child.name());
            this.write(child, writer);
            writer.writeEndElement();
        }
        writer.flush();
    }

    protected void read(PreferencesImpl prefs, XMLStreamReader xmler, String startKey) throws XMLStreamException {
        block5: while (xmler.hasNext()) {
            int eventType = xmler.next();
            switch (eventType) {
                case 4: {
                    prefs.getProperties().put(startKey, xmler.getText());
                    continue block5;
                }
                case 1: {
                    PreferencesImpl impl = prefs.getOrCreateNode(startKey);
                    this.read(impl, xmler, xmler.getName().getLocalPart());
                    continue block5;
                }
                case 2: {
                    PreferencesImpl impl;
                    if (prefs.getProperties().size() == 0 && prefs.getChildren().size() == 0) {
                        impl = prefs.getOrCreateNode(startKey);
                    }
                    if (!startKey.equals(xmler.getName().getLocalPart())) continue block5;
                    return;
                }
            }
        }
    }

    protected void writePreferences(PreferencesImpl prefs, XMLStreamWriter writer) throws XMLStreamException {
        for (Map.Entry entry : prefs.getProperties().entrySet()) {
            writer.writeStartElement(entry.getKey().toString());
            writer.writeCharacters(EscapeChars.forXML(entry.getValue().toString()));
            writer.writeEndElement();
        }
        writer.flush();
    }
}

