/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.awt.Desktop;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.media.MimeInspector;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.ui.editor.MimeSystemAppViewer;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.dicom.codec.DicomEncapDocSeries;
import org.weasis.dicom.codec.DicomVideoSeries;
import org.weasis.dicom.codec.FileExtractor;
import org.weasis.dicom.explorer.Messages;

public class MimeSystemAppFactory
implements SeriesViewerFactory {
    public static final String NAME = "default system application";
    public static final Icon ICON = new ImageIcon(MimeInspector.class.getResource("/icon/16x16/apps-system.png"));
    public static final MimeSystemAppViewer mimeSystemViewer = new MimeSystemAppViewer(){

        public String getPluginName() {
            return Messages.getString("MimeSystemAppViewer.app");
        }

        public void addSeries(MediaSeries series) {
            if (series instanceof DicomVideoSeries || series instanceof DicomEncapDocSeries) {
                Desktop desktop;
                if (AbstractProperties.OPERATING_SYSTEM.startsWith("linux")) {
                    FileExtractor extractor = (FileExtractor)series;
                    1.startAssociatedProgramFromLinux((File)extractor.getExtractFile());
                } else if (AbstractProperties.OPERATING_SYSTEM.startsWith("win")) {
                    FileExtractor extractor = (FileExtractor)series;
                    File file = extractor.getExtractFile();
                    1.startAssociatedProgramFromWinCMD((String)file.getAbsolutePath());
                } else if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                    FileExtractor extractor = (FileExtractor)series;
                    1.startAssociatedProgramFromDesktop((Desktop)desktop, (File)extractor.getExtractFile());
                }
            }
        }
    };

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return NAME;
    }

    public String getDescription() {
        return "";
    }

    public boolean canReadMimeType(String mimeType) {
        return "video/dicom".equals(mimeType) || "encap/dicom".equals(mimeType);
    }

    public boolean isViewerCreatedByThisFactory(SeriesViewer viewer) {
        return false;
    }

    public SeriesViewer createSeriesViewer(Hashtable<String, Object> properties) {
        return mimeSystemViewer;
    }

    public int getLevel() {
        return 100;
    }
}

