/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.wado;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.SwingWorker;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.explorer.model.TreeModel;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.MediaSeriesGroupNode;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.DicomInstance;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.Messages;
import org.weasis.dicom.codec.wado.WadoParameters;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.wado.DownloadPriority;
import org.weasis.dicom.explorer.wado.LoadRemoteDicomManifest;
import org.weasis.dicom.explorer.wado.LoadSeries;

public class LoadRemoteDicomURL
extends SwingWorker<Boolean, String> {
    private final URL[] urls;
    private final DicomModel dicomModel;

    public LoadRemoteDicomURL(String[] urls, DataExplorerModel explorerModel) {
        if (urls == null || !(explorerModel instanceof DicomModel)) {
            throw new IllegalArgumentException("invalid parameters");
        }
        URL[] urlRef = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            try {
                urlRef[i] = new URL(urls[i]);
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.urls = urlRef;
        this.dicomModel = (DicomModel)explorerModel;
    }

    public LoadRemoteDicomURL(URL[] urls, DataExplorerModel explorerModel) {
        if (urls == null || !(explorerModel instanceof DicomModel)) {
            throw new IllegalArgumentException("invalid parameters");
        }
        this.urls = urls;
        this.dicomModel = (DicomModel)explorerModel;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        String seriesUID = null;
        for (int i = 0; i < this.urls.length; ++i) {
            if (this.urls[i] == null) continue;
            seriesUID = this.urls[i].toString();
            break;
        }
        if (seriesUID != null) {
            MediaSeriesGroup study;
            String unknown = Messages.getString((String)"DownloadManager.unknown");
            MediaSeriesGroup patient = this.dicomModel.getHierarchyNode(TreeModel.rootNode, unknown);
            if (patient == null) {
                patient = new MediaSeriesGroupNode(TagW.PatientPseudoUID, (Object)unknown, TagW.PatientName);
                patient.setTag(TagW.PatientID, (Object)unknown);
                patient.setTag(TagW.PatientName, (Object)unknown);
                this.dicomModel.addHierarchyNode(TreeModel.rootNode, patient);
            }
            if ((study = this.dicomModel.getHierarchyNode(patient, unknown)) == null) {
                study = new MediaSeriesGroupNode(TagW.StudyInstanceUID, (Object)unknown, TagW.StudyDate);
                this.dicomModel.addHierarchyNode(patient, study);
            }
            DicomSeries dicomSeries = new DicomSeries(seriesUID);
            dicomSeries.setTag(TagW.ExplorerModel, (Object)this.dicomModel);
            dicomSeries.setTag(TagW.SeriesInstanceUID, (Object)seriesUID);
            WadoParameters wadoParameters = new WadoParameters("", false, "", null, null);
            dicomSeries.setTag(TagW.WadoParameters, (Object)wadoParameters);
            ArrayList<DicomInstance> dicomInstances = new ArrayList<DicomInstance>();
            dicomSeries.setTag(TagW.WadoInstanceReferenceList, dicomInstances);
            this.dicomModel.addHierarchyNode(study, (MediaSeriesGroup)dicomSeries);
            for (int i = 0; i < this.urls.length; ++i) {
                if (this.urls[i] == null) continue;
                String url = this.urls[i].toString();
                DicomInstance dcmInstance = new DicomInstance(url, null);
                dcmInstance.setDirectDownloadFile(url);
                dicomInstances.add(dcmInstance);
            }
            if (dicomInstances.size() > 0) {
                String modality = (String)dicomSeries.getTagValue(TagW.Modality);
                boolean ps = modality != null && ("PR".equals(modality) || "KO".equals(modality));
                LoadSeries loadSeries = new LoadSeries((Series)dicomSeries, this.dicomModel);
                if (!ps) {
                    loadSeries.startDownloadImageReference(wadoParameters);
                }
                Integer sn = (Integer)(ps ? Integer.valueOf(Integer.MAX_VALUE) : dicomSeries.getTagValue(TagW.SeriesNumber));
                DownloadPriority priority = new DownloadPriority((String)patient.getTagValue(TagW.PatientName), (String)study.getTagValue(TagW.StudyInstanceUID), (Date)study.getTagValue(TagW.StudyDate), sn);
                loadSeries.setPriority(priority);
                LoadRemoteDicomManifest.loadingQueue.offer(loadSeries);
                LoadRemoteDicomManifest.currentTasks.add(loadSeries);
                LoadRemoteDicomManifest.executor.prestartAllCoreThreads();
            }
        }
        return true;
    }

    @Override
    protected void done() {
    }
}

