/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageio;

import com.sun.media.imageio.stream.SegmentedImageInputStream;
import com.sun.media.imageio.stream.StreamSegment;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemParser
implements StreamSegmentMapper {
    private static final Logger log = LoggerFactory.getLogger(ItemParser.class);
    private static final HashSet<String> JPEG_TS = new HashSet<String>(Arrays.asList("1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.52", "1.2.840.10008.1.2.4.53", "1.2.840.10008.1.2.4.54", "1.2.840.10008.1.2.4.55", "1.2.840.10008.1.2.4.56", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.58", "1.2.840.10008.1.2.4.59", "1.2.840.10008.1.2.4.60", "1.2.840.10008.1.2.4.61", "1.2.840.10008.1.2.4.62", "1.2.840.10008.1.2.4.63", "1.2.840.10008.1.2.4.64", "1.2.840.10008.1.2.4.65", "1.2.840.10008.1.2.4.66", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.4.91"));
    private final ArrayList<Item> items = new ArrayList();
    private final DicomInputStream dis;
    private final ImageInputStream iis;
    private final ArrayList<Item> firstItemOfFrame;
    private final int numberOfFrames;
    private final boolean rle;
    private final boolean jpeg;
    private int[] basicOffsetTable;
    private final byte[] soi = new byte[2];
    private boolean lastItemSeen = false;
    private int frame;

    public ItemParser(DicomInputStream dis, ImageInputStream iis, int numberOfFrames, String tsuid) throws IOException {
        this.dis = dis;
        this.iis = iis;
        if ("1.2.840.10008.1.2.4.100".equals(tsuid)) {
            numberOfFrames = 1;
        }
        this.numberOfFrames = numberOfFrames;
        this.firstItemOfFrame = new ArrayList(numberOfFrames);
        this.rle = "1.2.840.10008.1.2.5".equals(tsuid);
        this.jpeg = !this.rle && JPEG_TS.contains(tsuid);
        dis.readHeader();
        int offsetTableLen = dis.valueLength();
        if (offsetTableLen != 0) {
            if (offsetTableLen != numberOfFrames * 4) {
                log.warn("Skip Basic Offset Table with illegal length: " + offsetTableLen + " for image with " + numberOfFrames + " frames!");
                iis.skipBytes(offsetTableLen);
            } else {
                this.basicOffsetTable = new int[numberOfFrames];
                iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                for (int i = 0; i < this.basicOffsetTable.length; ++i) {
                    this.basicOffsetTable[i] = iis.readInt();
                }
            }
        }
        this.next();
    }

    public int getNumberOfDataFragments() {
        while (!this.lastItemSeen) {
            this.next();
        }
        return this.items.size();
    }

    private Item getFirstItemOfFrame(int frame) throws IOException {
        while (this.firstItemOfFrame.size() <= frame) {
            if (this.next() != null) continue;
            throw new IOException("Could not detect first item of frame #" + (frame + 1));
        }
        return this.firstItemOfFrame.get(frame);
    }

    private Item next() {
        if (this.lastItemSeen) {
            return null;
        }
        try {
            if (!this.items.isEmpty()) {
                this.iis.seek(this.last().nextItemPos());
            }
            this.dis.readHeader();
            if (log.isDebugEnabled()) {
                log.debug("Read " + TagUtils.toString(this.dis.tag()) + " #" + this.dis.valueLength());
            }
            if (this.dis.tag() == -73728) {
                Item item = new Item(this.items.isEmpty() ? 0 : this.last().nextOffset(), this.iis.getStreamPosition(), this.dis.valueLength());
                if (this.items.isEmpty() || this.rle) {
                    this.addFirstItemOfFrame(item);
                } else if (this.firstItemOfFrame.size() < this.numberOfFrames) {
                    if (this.basicOffsetTable != null) {
                        Item firstItem = this.firstItemOfFrame.get(0);
                        int frame = this.firstItemOfFrame.size();
                        if (item.startPos == firstItem.startPos + ((long)this.basicOffsetTable[frame] & 0xFFFFFFFFL)) {
                            if (log.isDebugEnabled()) {
                                log.debug("Start position of item #" + (this.items.size() + 1) + " matches " + (frame + 1) + ".entry of Basic Offset Table.");
                            }
                            this.addFirstItemOfFrame(item);
                        }
                    } else if (this.jpeg) {
                        this.iis.read(this.soi, 0, 2);
                        if (this.soi[0] == -1 && (this.soi[1] == -40 || this.soi[1] == 79)) {
                            if (log.isDebugEnabled()) {
                                log.debug("Detect JPEG SOI/SOC at item #" + (this.items.size() + 1));
                            }
                            this.addFirstItemOfFrame(item);
                        }
                        this.iis.seek(item.startPos);
                    }
                }
                this.items.add(item);
                return item;
            }
        }
        catch (IOException e) {
            log.warn("i/o error reading next item:", (Throwable)e);
        }
        if (this.dis.tag() != -73507 || this.dis.valueLength() != 0) {
            log.warn("expected (FFFE,E0DD) #0 but read " + TagUtils.toString(this.dis.tag()) + " #" + this.dis.valueLength());
        }
        this.lastItemSeen = true;
        return null;
    }

    private void addFirstItemOfFrame(Item item) {
        if (log.isDebugEnabled()) {
            log.debug("Detect item #" + (this.items.size() + 1) + " as first item of frame #" + (this.firstItemOfFrame.size() + 1));
        }
        this.firstItemOfFrame.add(item);
    }

    private Item last() {
        return this.items.get(this.items.size() - 1);
    }

    public StreamSegment getStreamSegment(long pos, int len) {
        StreamSegment retval = new StreamSegment();
        this.getStreamSegment(pos, len, retval);
        return retval;
    }

    public void getStreamSegment(long pos, int len, StreamSegment seg) {
        if (log.isDebugEnabled()) {
            log.debug("getStreamSegment(pos=" + pos + ", len=" + len + ")");
        }
        if (this.isEndOfFrame(pos)) {
            this.setEOF(seg);
            return;
        }
        Item item = this.last();
        while ((long)item.nextOffset() <= pos) {
            item = this.next();
            if (item != null && !this.isEndOfFrame(pos)) continue;
            this.setEOF(seg);
            return;
        }
        int i = this.items.size() - 1;
        while ((long)item.offset > pos) {
            item = this.items.get(--i);
        }
        seg.setStartPos(item.startPos + pos - (long)item.offset);
        seg.setSegmentLength(Math.min((int)((long)(item.offset + item.length) - pos), len));
        if (log.isDebugEnabled()) {
            log.debug("return StreamSegment[start=" + seg.getStartPos() + ", len=" + seg.getSegmentLength() + "]");
        }
    }

    private boolean isEndOfFrame(long pos) {
        return this.frame + 1 < this.firstItemOfFrame.size() && (long)this.firstItemOfFrame.get((int)(this.frame + 1)).offset <= pos;
    }

    private void setEOF(StreamSegment seg) {
        seg.setSegmentLength(-1);
        if (log.isDebugEnabled()) {
            log.debug("return StreamSegment[start=" + seg.getStartPos() + ", len=-1]");
        }
    }

    public void seekFrame(SegmentedImageInputStream siis, int frame) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("seek frame #" + (frame + 1));
        }
        Item item = this.getFirstItemOfFrame(frame);
        siis.seek((long)item.offset);
        this.iis.seek(item.startPos);
        this.frame = frame;
        if (log.isDebugEnabled()) {
            log.debug("seek " + item);
        }
    }

    public byte[] readFrame(SegmentedImageInputStream siis, int frame) throws IOException {
        Item item = this.getFirstItemOfFrame(frame);
        int frameSize = item.length;
        int firstItemOfNextFrameIndex = frame + 1 < this.numberOfFrames ? this.items.indexOf(this.getFirstItemOfFrame(frame + 1)) : this.getNumberOfDataFragments();
        for (int i = this.items.indexOf(item) + 1; i < firstItemOfNextFrameIndex; ++i) {
            frameSize += this.items.get((int)i).length;
        }
        byte[] data = new byte[frameSize];
        this.seekFrame(siis, frame);
        siis.readFully(data);
        return data;
    }

    public void seekFooter() throws IOException {
        this.iis.seek(this.last().nextItemPos());
        this.dis.readHeader();
    }

    public static final class Item {
        public final int offset;
        public final long startPos;
        public final int length;

        public Item(int offset, long startPos, int length) {
            this.offset = offset;
            this.startPos = startPos;
            this.length = length;
        }

        final int nextOffset() {
            return this.offset + this.length;
        }

        final long nextItemPos() {
            return this.startPos + (long)this.length;
        }

        public String toString() {
            return "Item[off=" + this.offset + ", pos=" + this.startPos + ", len=" + this.length + "]";
        }
    }
}

