/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public class ImageInputStreamAdapter
extends InputStream {
    private final ImageInputStream iis;
    private long markedPos;
    private IOException markException;

    public ImageInputStreamAdapter(ImageInputStream iis) {
        this.iis = iis;
    }

    public int read() throws IOException {
        return this.iis.read();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.markedPos = this.iis.getStreamPosition();
            this.markException = null;
        }
        catch (IOException e) {
            this.markException = e;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.iis.read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        if (this.markException != null) {
            throw this.markException;
        }
        this.iis.seek(this.markedPos);
    }

    public long skip(long n) throws IOException {
        return this.iis.skipBytes((int)n);
    }
}

