/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    public static Date parseDA(String s, boolean end) {
        if (s == null || s.length() == 0) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        if (end) {
            DateUtils.setToDec31(c);
        }
        DateUtils.parseDA(c, s, 0, s.length());
        return c.getTime();
    }

    public static Date parseTM(String s, boolean end) {
        if (s == null || s.length() == 0) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        if (end) {
            DateUtils.setTo2359(c);
        }
        DateUtils.parseTM(c, s, 0, s.length());
        return c.getTime();
    }

    public static Date parseDT(String s, boolean end) {
        int pos;
        char tzsign;
        int len;
        if (s == null || s.length() == 0) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        if (end) {
            DateUtils.setToDec31(c);
            DateUtils.setTo2359(c);
        }
        if ((len = s.length()) >= 5 && ((tzsign = s.charAt(len - 5)) == '+' || tzsign == '-')) {
            ((Calendar)c).setTimeZone(TimeZone.getTimeZone("GMT" + s.substring(len -= 5)));
        }
        if ((pos = DateUtils.parseDA(c, s, 0, len)) + 2 <= len) {
            DateUtils.parseTM(c, s, pos, len);
        }
        return c.getTime();
    }

    public static String formatDA(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return DateUtils.formatDA(c, new StringBuffer(8)).toString();
    }

    public static String formatTM(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return DateUtils.formatTM(c, new StringBuffer(10)).toString();
    }

    public static String formatDT(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        StringBuffer sb = new StringBuffer(18);
        DateUtils.formatDA(c, sb);
        DateUtils.formatTM(c, sb);
        return sb.toString();
    }

    private static void setToDec31(Calendar c) {
        c.set(2, 11);
        c.set(5, 31);
        DateUtils.setTo2359(c);
    }

    private static void setTo2359(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
    }

    private static int parseDA(Calendar c, String s, int off, int len) {
        int pos = off;
        c.set(1, Integer.parseInt(s.substring(pos, pos += 4)));
        if (pos < len) {
            if (!Character.isDigit(s.charAt(pos))) {
                ++pos;
            }
            if (pos + 2 <= len) {
                c.set(2, Integer.parseInt(s.substring(pos, pos += 2)) - 1);
                if (pos < len) {
                    if (!Character.isDigit(s.charAt(pos))) {
                        ++pos;
                    }
                    if (pos + 2 <= len) {
                        c.set(5, Integer.parseInt(s.substring(pos, pos += 2)));
                    }
                }
            }
        }
        return pos;
    }

    private static int parseTM(Calendar c, String s, int off, int len) {
        int pos = off;
        String hours = s.substring(pos, pos += 2);
        c.set(11, Integer.parseInt(hours));
        if (pos < len) {
            if (!Character.isDigit(s.charAt(pos))) {
                ++pos;
            }
            if (pos + 2 <= len) {
                String minutes = s.substring(pos, pos += 2);
                c.set(12, Integer.parseInt(minutes));
                if (pos < len) {
                    if (!Character.isDigit(s.charAt(pos))) {
                        ++pos;
                    }
                    if (pos + 2 <= len) {
                        String seconds = s.substring(pos, pos += 2);
                        c.set(13, Integer.parseInt(seconds));
                        if (pos + 1 < len) {
                            String micros = s.substring(pos + 1, Math.min(len, pos + 5));
                            while (micros.length() < 4) {
                                micros = micros + '0';
                            }
                            int millis = DateUtils.roundMicrosToMillis(micros);
                            c.set(14, millis);
                        }
                    }
                }
            }
        }
        return pos;
    }

    private static int roundMicrosToMillis(String micros) {
        assert (micros != null && micros.length() == 4);
        double dblMicros = Integer.valueOf(micros).doubleValue();
        return (int)Math.round(dblMicros / 10.0);
    }

    private static StringBuffer formatDA(Calendar c, StringBuffer sb) {
        int yyyy = c.get(1);
        int mm = c.get(2) + 1;
        int dd = c.get(5);
        sb.append(yyyy);
        if (mm < 10) {
            sb.append("0");
        }
        sb.append(mm);
        if (dd < 10) {
            sb.append("0");
        }
        sb.append(dd);
        return sb;
    }

    private static StringBuffer formatTM(Calendar c, StringBuffer sb) {
        int hh = c.get(11);
        int mm = c.get(12);
        int ss = c.get(13);
        int ms = c.get(14);
        if (hh < 10) {
            sb.append("0");
        }
        sb.append(hh);
        if (mm < 10) {
            sb.append("0");
        }
        sb.append(mm);
        if (ss < 10) {
            sb.append("0");
        }
        sb.append(ss);
        sb.append(".");
        if (ms < 100) {
            sb.append("0");
        }
        if (ms < 10) {
            sb.append("0");
        }
        sb.append(ms);
        return sb;
    }

    public static Date toDateTime(Date date, Date time) {
        if (date == null) {
            return null;
        }
        if (time == null) {
            return date;
        }
        GregorianCalendar d = new GregorianCalendar();
        d.setTime(date);
        GregorianCalendar t = new GregorianCalendar();
        t.setTime(time);
        t.set(1, d.get(1));
        t.set(2, d.get(2));
        t.set(5, d.get(5));
        return t.getTime();
    }
}

