/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.math.BigInteger;
import java.util.UUID;

public class UIDUtils {
    private static final int EXPECT_DOT = 0;
    private static final int EXPECT_FIRST_DIGIT = 1;
    private static final int EXPECT_DOT_OR_DIGIT = 2;
    private static final int ILLEGAL_UID = -1;
    public static final String UUID_ROOT = "2.25";
    private static String root = "2.25";
    private static boolean acceptLeadingZero = false;

    public static final boolean isAcceptLeadingZero() {
        return acceptLeadingZero;
    }

    public static final void setAcceptLeadingZero(boolean acceptLeadingZero) {
        UIDUtils.acceptLeadingZero = acceptLeadingZero;
    }

    public static void setRoot(String root) {
        UIDUtils.verifyUIDRoot(root);
        UIDUtils.root = root;
    }

    private static void verifyUIDRoot(String root) {
        if (root.length() > 24) {
            throw new IllegalArgumentException("root length > 24");
        }
        UIDUtils.verifyUID(root);
    }

    public static String getRoot() {
        return root;
    }

    public static void verifyUID(String uid) {
        UIDUtils.verifyUID(uid, acceptLeadingZero);
    }

    public static void verifyUID(String uid, boolean acceptLeadingZero) {
        if (!UIDUtils.isValidUID(uid, acceptLeadingZero)) {
            throw new IllegalArgumentException(uid);
        }
    }

    public static boolean isValidUID(String uid) {
        return UIDUtils.isValidUID(uid, acceptLeadingZero);
    }

    public static boolean isValidUID(String uid, boolean acceptLeadingZero) {
        int len = uid.length();
        if (len > 64) {
            return false;
        }
        int state = 1;
        for (int i = 0; i < len; ++i) {
            if ((state = UIDUtils.nextState(state, uid.charAt(i), acceptLeadingZero)) != -1) continue;
            return false;
        }
        return state != 1;
    }

    private static int nextState(int state, int ch, boolean acceptLeadingZero) {
        return ch == 46 ? (state == 1 ? -1 : 1) : (state == 0 || ch < 48 || ch > 57 ? -1 : (!acceptLeadingZero && state == 1 && ch == 48 ? 0 : 2));
    }

    public static String createUID() {
        return UIDUtils.doCreateUID(root);
    }

    public static String createUID(String root) {
        UIDUtils.verifyUIDRoot(root);
        return UIDUtils.doCreateUID(root);
    }

    private static String doCreateUID(String root) {
        UUID uuid = UUID.randomUUID();
        byte[] b17 = new byte[17];
        UIDUtils.fill(b17, 1, uuid.getMostSignificantBits());
        UIDUtils.fill(b17, 9, uuid.getLeastSignificantBits());
        return new StringBuilder(64).append(root).append('.').append(new BigInteger(b17)).toString();
    }

    private static void fill(byte[] bb, int off, long val) {
        int i = off;
        for (int shift = 56; shift >= 0; shift -= 8) {
            bb[i] = (byte)(val >>> shift);
            ++i;
        }
    }
}

