/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.ByteLookupTable;
import org.dcm4che2.image.LookupTable;
import org.dcm4che2.imageio.plugins.dcm.DicomImageReadParam;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.dicom.codec.DicomMediaIO;

public class OverlayUtils {
    private static final int BITS_PER_BYTE = 8;
    private static LookupTable reorderBytes;
    private static byte[] rgbArr;
    private static byte[] aArr;
    private static final byte[] icmColorValues;
    private static final byte[] bitSwapLut;

    public static boolean isOverlay(int imageIndex) {
        return (imageIndex & 0x60000000) == 0x60000000 && (imageIndex & 0x9F010000) == 0;
    }

    public static int extractFrameNumber(int imageIndex) {
        if (OverlayUtils.isOverlay(imageIndex)) {
            return imageIndex & 0xFFFF;
        }
        throw new IllegalArgumentException("Only frame numbers of overlays can be extracted.");
    }

    public static BufferedImage extractOverlay(DicomObject ds, int overlayNumber, ImageReader reader, String rgbs) throws IOException {
        byte[] data;
        if (!OverlayUtils.isOverlay(overlayNumber)) {
            throw new IllegalArgumentException("Overlays must start with 0x60xx xxxx but it starts with " + Integer.toString(overlayNumber, 16));
        }
        int frameNumber = OverlayUtils.extractFrameNumber(overlayNumber);
        int rows = OverlayUtils.getOverlayHeight(ds, overlayNumber &= 0x60FE0000);
        int cols = OverlayUtils.getOverlayWidth(ds, overlayNumber);
        if (cols == 0 || rows == 0) {
            throw new IllegalArgumentException("No overlay found for " + Integer.toString(overlayNumber));
        }
        int position = ds.getInt(overlayNumber | 0x60000102);
        if (position == 0) {
            byte[] unpaddedData = ds.getBytes(overlayNumber | 0x60003000);
            data = OverlayUtils.padToFixRowByteBoundary(unpaddedData, rows, cols);
            if (frameNumber > 0 && data.length >= rows * cols * 2 / 8) {
                byte[] frameData = new byte[rows * cols / 8];
                System.arraycopy(data, (frameNumber - 1) * frameData.length, frameData, 0, frameData.length);
                data = frameData;
            }
        } else {
            Raster raw = reader.readRaster(frameNumber, null);
            int rowLen = (cols + 7) / 8;
            data = new byte[rows * rowLen];
            int[] pixels = new int[cols];
            int bit = 1 << position;
            for (int y = 0; y < rows; ++y) {
                pixels = raw.getPixels(0, y, cols, 1, pixels);
                for (int x = 0; x < cols; ++x) {
                    if ((pixels[x] & bit) == 0) continue;
                    int n = rowLen * y + x / 8;
                    data[n] = (byte)(data[n] | 1 << x % 8);
                }
            }
        }
        DataBufferByte db = new DataBufferByte(data, data.length);
        WritableRaster wr = Raster.createPackedRaster(db, cols, rows, 1, new Point());
        byte[] rArr = rgbArr;
        byte[] gArr = rgbArr;
        byte[] bArr = rgbArr;
        if (rgbs != null && rgbs.length() > 0) {
            if (rgbs.startsWith("#")) {
                rgbs = rgbs.substring(1);
            }
            int rgb = Integer.parseInt(rgbs, 16);
            rArr = new byte[]{0, (byte)(rgb >> 16 & 0xFF)};
            gArr = new byte[]{0, (byte)(rgb >> 8 & 0xFF)};
            bArr = new byte[]{0, (byte)(rgb & 0xFF)};
        }
        IndexColorModel cm = new IndexColorModel(1, 2, rArr, gArr, bArr, aArr);
        BufferedImage bi = new BufferedImage(cm, wr, false, null);
        reorderBytes.lookup(bi.getRaster(), bi.getRaster());
        return bi;
    }

    protected static byte[] padToFixRowByteBoundary(byte[] unpaddedData, int rows, int cols) {
        int numRowBytes = (cols + 7) / 8;
        int paddedLength = rows * numRowBytes;
        if (unpaddedData.length == paddedLength && cols % 8 == 0) {
            return unpaddedData;
        }
        byte[] data = new byte[paddedLength];
        for (int y = 0; y < rows; ++y) {
            int posnPad = y * numRowBytes;
            int posnUnpad = y * cols;
            int bits = posnUnpad % 8;
            posnUnpad /= 8;
            int prevBits = 8 - bits;
            if (bits == 0) {
                System.arraycopy(unpaddedData, posnUnpad, data, posnPad, numRowBytes);
                continue;
            }
            int mask = 255 << bits & 0xFF;
            int nextMask = 255 >> prevBits & 0xFF;
            for (int x = 0; x < numRowBytes; ++x) {
                try {
                    byte firstByte = (byte)((unpaddedData[posnUnpad + x] & mask) >> bits);
                    byte secondByte = 0;
                    if (posnUnpad + x + 1 < unpaddedData.length) {
                        secondByte = (byte)((unpaddedData[posnUnpad + x + 1] & nextMask) << prevBits);
                    }
                    data[posnPad + x] = (byte)(firstByte | secondByte);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ArrayIndexOutOfBoundsException newEx = new ArrayIndexOutOfBoundsException("Did not find enough source data (" + unpaddedData.length + ") in overlay to pad data for " + rows + " rows, " + cols + "columns");
                    newEx.initCause(e);
                    throw newEx;
                }
            }
        }
        return data;
    }

    public static int getOverlayWidth(DicomObject ds, int overlayNumber) {
        return ds.getInt(0x60000011 | (overlayNumber &= 0x60FF0000));
    }

    public static int getOverlayHeight(DicomObject ds, int overlayNumber) {
        return ds.getInt(0x60000010 | (overlayNumber &= 0x60FF0000));
    }

    private static byte[] makeBitSwapLut() {
        byte[] rc = new byte[256];
        for (int i = 0; i < 256; ++i) {
            rc[i] = OverlayUtils.byte_reverse(i);
        }
        return rc;
    }

    private static byte byte_reverse(int b) {
        int out = 0;
        for (int i = 0; i < 8; ++i) {
            out = out << 1 | b >> i & 1;
        }
        return (byte)out;
    }

    private static int groupedTag(int group, int tag) {
        int x = group << 16;
        return tag + x;
    }

    private static int getInt(DicomObject ds, int group, int tag, int def) {
        return ds.getInt(OverlayUtils.groupedTag(group, tag), def);
    }

    private static int[] getInts(DicomObject ds, int group, int tag) {
        return ds.getInts(OverlayUtils.groupedTag(group, tag));
    }

    private static String getString(DicomObject ds, int group, int tag) {
        return ds.getString(OverlayUtils.groupedTag(group, tag));
    }

    public static RenderedImage getOverlays(ImageElement imageElement, DicomMediaIO reader, int frame, int width, int height) throws IOException {
        DicomObject ds = reader.getDicomObject();
        IndexColorModel icm = new IndexColorModel(1, 2, icmColorValues, icmColorValues, icmColorValues, 0);
        BufferedImage overBi = new BufferedImage(width, height, 12, icm);
        ArrayList<Integer> oldStyleOverlayPlanes = new ArrayList<Integer>();
        for (int group = 0; group < 32; group += 2) {
            int oBitPosition = OverlayUtils.getInt(ds, group, 1610612994, -1);
            int oRows = OverlayUtils.getInt(ds, group, 0x60000010, -1);
            int oCols = OverlayUtils.getInt(ds, group, 0x60000011, -1);
            int[] oOrigin = OverlayUtils.getInts(ds, group, 0x60000050);
            int oBitsAllocated = OverlayUtils.getInt(ds, group, 0x60000100, -1);
            String oType = OverlayUtils.getString(ds, group, 0x60000040);
            int oNumberOfFrames = OverlayUtils.getInt(ds, group, 1610612757, 1);
            int oFrameStart = OverlayUtils.getInt(ds, group, 1610612817, 1) - 1;
            int oFrameEnd = oFrameStart + oNumberOfFrames;
            if (oBitPosition == -1 && oBitsAllocated == -1 && oRows == -1 && oCols == -1 || "R".equals(oType)) continue;
            if (oBitsAllocated != 1 && oBitPosition != 0) {
                oldStyleOverlayPlanes.add(oBitPosition);
                continue;
            }
            if ("GR".indexOf(oType) < 0) continue;
            int oX1 = 0;
            int oY1 = 0;
            if (oOrigin != null) {
                oX1 = oOrigin[1] - 1;
                oY1 = oOrigin[0] - 1;
            }
            if (oFrameStart > frame || frame >= oFrameEnd) {
                // empty if block
            }
            int oFrameOffset = frame - oFrameStart;
            int bitOffset = oFrameOffset * oRows * oCols;
            int byteOffset = bitOffset / 8;
            int numBits = oRows * oCols;
            int numBytes = (numBits + 7) / 8;
            byte[] bb = ds.get(OverlayUtils.groupedTag(group, 0x60003000)).getBytes();
            DataBufferByte dataBufferByte = (DataBufferByte)overBi.getRaster().getDataBuffer();
            byte[] dest = dataBufferByte.getData();
            int packedRowBits = oCols + 7 & 0xFFFFFFF8;
            if (packedRowBits == oCols) {
                int i = 0;
                while (i < numBytes) {
                    int idx = bb[byteOffset + i] & 0xFF;
                    int n = i++;
                    dest[n] = (byte)(dest[n] | bitSwapLut[idx]);
                }
                continue;
            }
            int packedRowBytes = packedRowBits / 8;
            for (int y = 0; y < oRows; ++y) {
                int b1;
                int inOffset;
                int i;
                int size;
                int rowBitOffset = bitOffset + y * oCols;
                int rowByteOffset = rowBitOffset / 8;
                int packedRowByteOffset = y * packedRowBytes;
                int bitsToMove = rowBitOffset % 8;
                if (bitsToMove != 0) {
                    size = packedRowBytes - 1;
                    for (i = 0; i < size; ++i) {
                        inOffset = rowByteOffset + i;
                        b1 = bb[inOffset] & 0xFF;
                        int b2 = bb[inOffset + 1] & 0xFF;
                        int rc = b1 >> bitsToMove ^ b2 << 8 - bitsToMove & 0xFF;
                        int n = packedRowByteOffset + i;
                        dest[n] = (byte)(dest[n] | bitSwapLut[rc]);
                    }
                    continue;
                }
                size = packedRowBytes - 1;
                for (i = 0; i < size; ++i) {
                    inOffset = rowByteOffset + i;
                    b1 = bb[inOffset] & 0xFF;
                    int n = packedRowByteOffset + i;
                    dest[n] = (byte)(dest[n] | bitSwapLut[b1]);
                }
            }
        }
        if (oldStyleOverlayPlanes.size() > 0) {
            try {
                int dataType;
                PlanarImage source = imageElement.getImage();
                if (source != null && ((dataType = source.getSampleModel().getDataType()) == 2 || dataType == 1)) {
                    int mask = Integer.MAX_VALUE;
                    int size = oldStyleOverlayPlanes.size();
                    for (int i = 0; i < size; ++i) {
                        int val = 1 << (Integer)oldStyleOverlayPlanes.get(i);
                        if (dataType == 2) {
                            val -= 32768;
                        }
                        if (val >= mask) continue;
                        mask = val;
                    }
                    ImageReadParam param = reader.getDefaultReadParam();
                    if (param instanceof DicomImageReadParam) {
                        ((DicomImageReadParam)param).setAutoWindowing(false);
                    }
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(source);
                    pb.add((double)imageElement.getMinValue());
                    pb.add((double)(mask - 1));
                    RenderedOp result = JAI.create((String)"ThresholdToBin", (ParameterBlock)pb, null);
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return overBi;
    }

    static {
        byte[] reorder = new byte[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                int bitTest = 1 << j;
                if ((i & bitTest) == 0) continue;
                int n = i;
                reorder[n] = (byte)(reorder[n] | 128 >> j);
            }
        }
        reorderBytes = new ByteLookupTable(8, false, 0, 8, reorder);
        rgbArr = new byte[]{-1, 0};
        aArr = new byte[]{0, -1};
        icmColorValues = new byte[]{-1, 0};
        bitSwapLut = OverlayUtils.makeBitSwapLut();
    }
}

