/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che2.data.VR;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.DicomTag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagDictionary {
    private final HashMap<Integer, DicomTag> table = new HashMap(40);

    public static TagW.TagType getTagType(VR vr, String vm) {
        boolean array = false;
        if (!"1".equals(vm.trim())) {
            array = true;
        }
        if (vr == VR.AE || vr == VR.AS || vr == VR.AT || vr == VR.CS || vr == VR.LO || vr == VR.LT || vr == VR.PN || vr == VR.SH || vr == VR.ST || vr == VR.UI || vr == VR.UN || vr == VR.UN_SIEMENS) {
            return TagW.TagType.String;
        }
        if (vr == VR.DA) {
            return TagW.TagType.Date;
        }
        if (vr == VR.DT) {
            return TagW.TagType.DateTime;
        }
        if (vr == VR.TM) {
            return TagW.TagType.Time;
        }
        if (vr == VR.IS || vr == VR.SS || vr == VR.US || vr == VR.SL || vr == VR.UL) {
            return array ? TagW.TagType.IntegerArray : TagW.TagType.Integer;
        }
        if (vr == VR.DS || vr == VR.FL) {
            return array ? TagW.TagType.FloatArray : TagW.TagType.Float;
        }
        if (vr == VR.FD) {
            return array ? TagW.TagType.DoubleArray : TagW.TagType.Double;
        }
        if (vr == VR.OB || vr == VR.OW || vr == VR.OF || vr == VR.UT) {
            return TagW.TagType.Text;
        }
        if (vr == VR.SQ) {
            return TagW.TagType.Sequence;
        }
        return null;
    }

    public HashMap<Integer, DicomTag> loadXML(InputStream stream) throws IOException, SAXException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(stream, (DefaultHandler)new SAXAdapter());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        return this.table;
    }

    public HashMap<Integer, DicomTag> getTable() {
        return this.table;
    }

    private final class SAXAdapter
    extends DefaultHandler {
        int tag = -1;
        StringBuffer name = new StringBuffer(80);
        String vr = null;
        String vm = null;
        String format = null;
        boolean retired = false;

        private SAXAdapter() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tag != -1) {
                this.name.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("element".equals(qName)) {
                this.tag = (int)Long.parseLong(attributes.getValue("tag").replace('x', '0'), 16);
                this.vr = attributes.getValue("vr");
                this.vm = attributes.getValue("vm");
                this.format = attributes.getValue("format");
                this.retired = attributes.getValue("ret").equals("RET");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("element".equals(qName)) {
                VR vrVal = null;
                try {
                    Field f = VR.class.getField(this.vr);
                    vrVal = (VR)f.get(this.vr);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.format != null && this.format.trim().equals("")) {
                    this.format = null;
                }
                TagDictionary.this.table.put(this.tag, new DicomTag(this.tag, this.name.toString(), vrVal, this.vm, this.format, this.retired));
                this.name.setLength(0);
                this.tag = -1;
            }
        }
    }
}

