/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.weasis.dicom.codec.geometry.GeometryOfSlice;
import org.weasis.dicom.codec.geometry.LocalizerPoster;

public class ProjectSlice
extends LocalizerPoster {
    public ProjectSlice(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, Tuple3d dimensions) {
        this.localizerRow = row;
        this.localizerColumn = column;
        this.localizerTLHC = tlhc;
        this.localizerVoxelSpacing = voxelSpacing;
        this.localizerDimensions = dimensions;
        this.doCommonConstructorStuff();
    }

    public ProjectSlice(GeometryOfSlice geometry) {
        this.localizerRow = geometry.getRow();
        this.localizerColumn = geometry.getColumn();
        this.localizerTLHC = geometry.getTLHC();
        this.localizerVoxelSpacing = geometry.getVoxelSpacing();
        this.localizerDimensions = geometry.getDimensions();
        this.doCommonConstructorStuff();
    }

    @Override
    public List<Point2D> getOutlineOnLocalizerForThisGeometry(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, double sliceThickness, Tuple3d dimensions) {
        Point3d[] sourceCorners = ProjectSlice.getCornersOfSourceRectangleInSourceSpace(row, column, tlhc, voxelSpacing, dimensions);
        Vector<Line2D.Double> shapes = new Vector<Line2D.Double>(5);
        Point2D.Double firstPoint = null;
        Point2D.Double lastPoint = null;
        Point2D.Double thisPoint = null;
        for (int i = 0; i < 4; ++i) {
            Point3d point = this.transformPointFromSourceSpaceIntoLocalizerSpace(sourceCorners[i]);
            lastPoint = thisPoint;
            thisPoint = this.transformPointInLocalizerPlaneIntoImageSpace(point);
            if (i == 0) {
                firstPoint = thisPoint;
                continue;
            }
            shapes.add(new Line2D.Double(lastPoint, thisPoint));
        }
        shapes.add(new Line2D.Double(thisPoint, firstPoint));
        if (shapes != null && shapes.size() > 0) {
            int size = shapes.size();
            ArrayList<Point2D> pts = new ArrayList<Point2D>(size);
            for (int i = 0; i < size; ++i) {
                Line2D.Double line = (Line2D.Double)shapes.get(i);
                pts.add(new Point2D.Double(line.getX2(), line.getY2()));
            }
            return pts;
        }
        return null;
    }
}

