/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.actions.AbstractAction;
import jp.gr.java_conf.miya.pglauncher.actions.ActionEventProvider;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.dialogs.GroupDialog;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddGroupAction
extends AbstractAction {
    private ConfigDialog dialog_;
    private TreeViewer viewer_;

    public AddGroupAction(ConfigDialog dialog, TreeViewer viewer, ActionEventProvider provider) {
        super(LocalUtils.getString("AddGroupAction.menuTitle"), null, provider);
        this.dialog_ = dialog;
        this.viewer_ = viewer;
    }

    public void run() {
        GroupDialog dialog = new GroupDialog(this.viewer_.getControl().getShell(), "");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Element el = TreeUtils.getSelectedElement(this.viewer_);
            Element group = this._createGroupElement(dialog.getGroupName());
            el.appendChild(group);
            this.viewer_.refresh();
            this.viewer_.setSelection((ISelection)new StructuredSelection((Object)group), true);
            this.dialog_.modified();
        }
    }

    public void doubleClick(Event event) {
    }

    public void rightClick(Event event) {
        Element el = TreeUtils.getSelectedElement(this.viewer_);
        String type = el.getNodeName();
        if (type.equals("pglauncher") || type.equals("group")) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void keyDown(Event event) {
    }

    private Element _createGroupElement(String str) {
        Element el = ((Document)this.viewer_.getInput()).createElement("group");
        el.setAttribute("name", str);
        return el;
    }
}

