package jp.gr.java_conf.miya.pglauncher;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import jp.gr.java_conf.miya.pglauncher.common.Const;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PGLauncherPlugin extends AbstractUIPlugin {

	//======================================================================
	// Constant
	//======================================================================
	private static final String MESSAGE_RESOURCE =
			"jp.gr.java_conf.miya.pglauncher.messages";
	
	//======================================================================
	// Class Variable
	//======================================================================
	//------------------------------------------------------------ private
	private static PGLauncherPlugin plugin;
	
	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private ResourceBundle resourceBundle;
	
	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public PGLauncherPlugin(){
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle(MESSAGE_RESOURCE);
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	public static PGLauncherPlugin getDefault() {
		return plugin;
	}

	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	//======================================================================
	// Class Method
	//======================================================================
	//------------------------------------------------------------ public
	public static File getConfigFile(){
		return plugin.getStateLocation().append("/").append(Const.FILENAME).toFile();
	}
}
