package jp.gr.java_conf.miya.pglauncher.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;

public class ActionEventProvider{
	
	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private List listenerList_;
	
	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public ActionEventProvider(){
		 listenerList_ = new ArrayList();
	}
	
	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void addListener(IActionEventListener listener){
		listenerList_.add(listener);
	}
	
	public void handleEvent(Event event,TreeViewer viewer){
		switch(event.type){
			case SWT.MenuDetect:
				for(Iterator ite = listenerList_.iterator();ite.hasNext();){
					((IActionEventListener)ite.next()).handleRightClick(event);
				}
				break;
			case SWT.MouseDoubleClick:
				for(Iterator ite = listenerList_.iterator();ite.hasNext();){
					((IActionEventListener)ite.next()).handleDoubleClick(event);
				}
				break;
			case SWT.KeyDown:
				for(Iterator ite = listenerList_.iterator();ite.hasNext();){
					((IActionEventListener)ite.next()).handleKeyDown(event);
				}
				break;
		}
	}
}
