package jp.gr.java_conf.miya.pglauncher.actions;

import java.io.File;
import java.io.IOException;

import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.internal.WorkbenchWindow;

public class FolderAction extends Action {
	
	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private String path_;
	
	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public FolderAction(String name, String path){
		setText(name);
		path_ = path;
		setImageDescriptor(ImageUtils.getImageDescriptorFromIcon(Const.ICON_FOLDER));
	}
	
	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		WorkbenchWindow workbenchWindow = (WorkbenchWindow)PGLauncherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		IStatusLineManager lineManager = workbenchWindow.getActionBars().getStatusLineManager();
		
		File file = new File(path_);
		if(!file.exists()){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
						LocalUtils.getString("FolderAction.error1",new String[]{getText()})); //$NON-NLS-1$
			return;
		}
		
		try{
			Process proc = Runtime.getRuntime().exec("explorer /e ,\"" + path_ + "\""); //$NON-NLS-1$ //$NON-NLS-2$
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_RUN),
						LocalUtils.getString("FolderAction.run",new String[]{getText()})); //$NON-NLS-1$
		}catch(IOException e){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
						LocalUtils.getString("FolderAction.error2",new String[]{getText()})); //$NON-NLS-1$
		}
	}
}
