package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.XMLUtils;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PGLauncherAction implements IWorkbenchWindowPulldownDelegate{

	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private IWorkbenchWindow window_;
	private ConfigAction config_;
	private Separator separator_;
	
	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public Menu getMenu(Control parent){
		return _createMenu(parent);
	}
	
	public void dispose(){}

	public void init(IWorkbenchWindow window){
		window_ = window;
		config_ = new ConfigAction(window.getShell());
		separator_ = new Separator();
	}

	public void run(IAction action){
		getMenu(window_.getShell()).setVisible(true);
	}
	
	public void selectionChanged(IAction action, ISelection selection){}
	
	//------------------------------------------------------------ private
	private Menu _createMenu(Control control){
		MenuManager manager = new MenuManager();
		manager.setRemoveAllWhenShown(true);
		manager.addMenuListener(new IMenuListener(){
			public void menuAboutToShow(IMenuManager manager){
				Node node = XMLUtils.getInstance().loadDocument().getDocumentElement();
				_addMenu(node,manager);
				manager.add(separator_);
				manager.add(config_);
			}
		});
		control.setMenu(manager.createContextMenu(control));
		return control.getMenu();
	}
	
	private void _addMenu(Node node,IContributionManager manager){
		if(node.getNodeName().equals(Const.NODE_ROOT)){
			NodeList list = node.getChildNodes();
			for(int i = 0;i < list.getLength();i++){
				_addMenu(list.item(i),manager);
			}
		}else if(node.getNodeName().equals(Const.NODE_GROUP)){
			NamedNodeMap attrMap = node.getAttributes();
			String name = attrMap.getNamedItem(Const.ATTR_NAME).getNodeValue();
			MenuManager group = new MenuManager(name);
			manager.add(group);
			NodeList list = node.getChildNodes();
			for(int i = 0;i < list.getLength();i++){
				_addMenu(list.item(i),group);
			}
		}else if(node.getNodeName().equals(Const.NODE_PROGRAM)){
			NamedNodeMap attrMap = node.getAttributes();
			String name = attrMap.getNamedItem(Const.ATTR_NAME).getNodeValue();
			String path = attrMap.getNamedItem(Const.ATTR_PATH).getNodeValue();
			String arg = attrMap.getNamedItem(Const.ATTR_ARG).getNodeValue();
			manager.add(new ProgramAction(name,path,arg));
		}else if(node.getNodeName().equals(Const.NODE_FOLDER)){
			NamedNodeMap attrMap = node.getAttributes();
			String name = attrMap.getNamedItem(Const.ATTR_NAME).getNodeValue();
			String path = attrMap.getNamedItem(Const.ATTR_PATH).getNodeValue();
			manager.add(new FolderAction(name,path));
		}
	}
}
