package jp.gr.java_conf.miya.pglauncher.dialogs;

import java.io.File;

import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProgramDialog extends TitleAreaDialog{
	
	//======================================================================
	// Class Variable
	//======================================================================
	//------------------------------------------------------------ private
	public static final int FOCUS_PROGRAM = 0;
	public static final int FOCUS_FOLDER = 1;
	
	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private String programName_;
	private String path_;
	private String arg_;
	private ModifyListenerImpl modListener_;
	private SelectionListenerImpl selectListener_;
	private Text programText_;
	private Text argText_;
	private Text folderText_;
	private Text nameText_;
	private Button programRadio_;
	private Button folderRadio_;
	private Button programButton_;
	private Button folderButton_;
	private int focus_ = 0;
	
	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public ProgramDialog(Shell parent){
		this(parent,"","","",FOCUS_PROGRAM); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}
	
	public ProgramDialog(Shell parent,
						String programName,
						String path,
						String arg,
						int focus){
		super(parent);
		this.programName_ = programName;
		this.path_ = path;
		this.arg_ = arg;
		this.focus_ = focus;
		modListener_ = new ModifyListenerImpl();
		selectListener_ = new SelectionListenerImpl();
	}
	
	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	protected void configureShell(Shell newShell){
		super.configureShell(newShell);
		newShell.setText(LocalUtils.getString("ProgramDialog.titlebar")); //$NON-NLS-1$
	}
	
	public void create(){
		super.create();
		if(programName_.equals("")){ //$NON-NLS-1$
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
	
	public String getProgramName(){
		return programName_;
	}
	public String getPath(){
		return path_;
	}
	public String getArg(){
		return arg_;
	}
	public boolean isProgram(){
		return focus_ == FOCUS_PROGRAM;
	}
	public boolean isFolder(){
		return focus_ == FOCUS_FOLDER;
	}
	//------------------------------------------------------------ protected
	protected Point getInitialSize(){
		return new Point(400,320);
	}
	
	protected void okPressed(){
		programName_ = nameText_.getText();
		if(isProgram()){
			path_ = programText_.getText();
			arg_ = argText_.getText();
		}
		if(isFolder()) path_ = folderText_.getText();
		super.okPressed();
	}
	
	protected Control createDialogArea(Composite parent){
		Composite composite = (Composite)super.createDialogArea(parent);
		
		Composite contents = new Composite(composite,SWT.NONE);
		GridLayout layout = new GridLayout(2,false);
		contents.setLayout(layout);
		contents.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		setMessage(LocalUtils.getString("ProgramDialog.title"), IMessageProvider.INFORMATION); //$NON-NLS-1$
		
		Group group = new Group(contents,SWT.NONE);
		group.setText(LocalUtils.getString("ProgramDialog.label3")); //$NON-NLS-1$
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		group.setLayoutData(data);
		layout = new GridLayout(2,false);
		group.setLayout(layout);
		
		programRadio_ = new Button(group, SWT.RADIO);
		programRadio_.setText(LocalUtils.getString("ProgramDialog.radio1")); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 2;
		programRadio_.setLayoutData(data);
		programRadio_.addSelectionListener(selectListener_);
		
		programText_ = new Text(group, SWT.BORDER);
		if(isProgram()) programText_.setText(path_);
		programText_.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		programText_.addModifyListener(modListener_);
		programButton_ = new Button(group, SWT.PUSH);
		programButton_.setText(LocalUtils.getString("ProgramDialog.referenceBtn")); //$NON-NLS-1$
		programButton_.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				FileDialog dialog = new FileDialog(programButton_.getShell());
				dialog.setFilterExtensions(new String[]{"*.*"}); //$NON-NLS-1$
				String filePath = dialog.open();
				if(filePath != null){
					programText_.setText(filePath);
					int delim = filePath.lastIndexOf("\\"); //$NON-NLS-1$
					int slash = filePath.lastIndexOf("/"); //$NON-NLS-1$
					if(slash > delim) delim = slash;
					String fileName = filePath.substring(delim + 1);
					int pos = fileName.indexOf("."); //$NON-NLS-1$
					if(pos > 0){
						fileName = fileName.substring(0,pos);
					}
					nameText_.setText(fileName);
				}
			}
			public void widgetDefaultSelected(SelectionEvent e){}
		});
		
		Composite argContents = new Composite(group,SWT.NONE);
		layout = new GridLayout(2,false);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		argContents.setLayout(layout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		argContents.setLayoutData(data);
		Label argLabel = new Label(argContents, SWT.NONE);
		argLabel.setText(LocalUtils.getString("ProgramDialog.label2")); //$NON-NLS-1$
		argText_ = new Text(argContents, SWT.BORDER);
		argText_.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		if(isProgram()) argText_.setText(arg_);
		
		Label blankLabel = new Label(group,SWT.NONE);
		
		folderRadio_ = new Button(group, SWT.RADIO);
		folderRadio_.setText(LocalUtils.getString("ProgramDialog.radio2")); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 2;
		folderRadio_.setLayoutData(data);
		folderRadio_.addSelectionListener(selectListener_);
		
		folderText_ = new Text(group, SWT.BORDER);
		if(isFolder()) folderText_.setText(path_);
		folderText_.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		folderText_.addModifyListener(modListener_);
		folderButton_ = new Button(group, SWT.PUSH);
		folderButton_.setText(LocalUtils.getString("ProgramDialog.referenceBtn")); //$NON-NLS-1$
		folderButton_.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				String dirPath = new DirectoryDialog(programButton_.getShell()).open();
				if(dirPath != null){
					folderText_.setText(dirPath);
					int delim = dirPath.lastIndexOf("\\"); //$NON-NLS-1$
					int slash = dirPath.lastIndexOf("/"); //$NON-NLS-1$
					if(slash > delim) delim = slash;
					nameText_.setText(dirPath.substring(delim + 1));
				}
			}
			public void widgetDefaultSelected(SelectionEvent e){}
		});
		
		programRadio_.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				programText_.setEnabled(true);
				programButton_.setEnabled(true);
				argText_.setEnabled(true);
				folderText_.setEnabled(false);
				folderButton_.setEnabled(false);
			}
			public void widgetDefaultSelected(SelectionEvent e){}
		});
		folderRadio_.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				programText_.setEnabled(false);
				programButton_.setEnabled(false);
				argText_.setEnabled(false);
				folderText_.setEnabled(true);
				folderButton_.setEnabled(true);
			}
			public void widgetDefaultSelected(SelectionEvent e){}
		});
		
		if(isProgram()){
			programRadio_.setSelection(true);
			folderRadio_.setSelection(false);
			programText_.setEnabled(true);
			programButton_.setEnabled(true);
			argText_.setEnabled(true);
			folderText_.setEnabled(false);
			folderButton_.setEnabled(false);
		}
		if(isFolder()){
			programRadio_.setSelection(false);
			folderRadio_.setSelection(true);
			programText_.setEnabled(false);
			programButton_.setEnabled(false);
			argText_.setEnabled(false);
			folderText_.setEnabled(true);
			folderButton_.setEnabled(true);
		}
		
		Label nameLabel = new Label(contents, SWT.NONE);
		nameLabel.setText(LocalUtils.getString("ProgramDialog.label1")); //$NON-NLS-1$
		nameText_ = new Text(contents, SWT.BORDER);
		nameText_.setText(programName_);
		nameText_.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		nameText_.addModifyListener(modListener_);
		
		programText_.setFocus();
		return composite;
	}
	
	//------------------------------------------------------------ private
	private boolean _validateName(String str){
		if(str.length() == 0){
			setDisableOK(LocalUtils.getString("ProgramDialog.error1")); //$NON-NLS-1$
			return false;
		}
		return true;
	}
	
	private boolean _validateProgramText(String str){
		if(str.length() == 0){
			setDisableOK(LocalUtils.getString("ProgramDialog.error2")); //$NON-NLS-1$
			return false;
		}else{
			if(!isFileExist(str)){
				setDisableOK(LocalUtils.getString("ProgramDialog.error3")); //$NON-NLS-1$
				return false;
			}
		}
		return true;
	}
	
	private boolean _validateFolderText(String str){
		if(str.length() == 0){
			setDisableOK(LocalUtils.getString("ProgramDialog.error4")); //$NON-NLS-1$
			return false;
		}else{
			if(!isFolderExist(str)){
				setDisableOK(LocalUtils.getString("ProgramDialog.error5")); //$NON-NLS-1$
				return false;
			}
		}
		return true;
	}
	
	private boolean isFileExist(String fileName){
		File file = new File(fileName);
		if(file.exists()){
			if(file.isFile()) return true;
		}
		return false;
	}
	
	private boolean isFolderExist(String fileName){
		File file = new File(fileName);
		if(file.exists()){
			if(file.isDirectory()) return true;
		}
		return false;
	}
	
	private void setEnableOK(){
		setMessage(LocalUtils.getString("ProgramDialog.title"), IMessageProvider.INFORMATION); //$NON-NLS-1$
		getButton(IDialogConstants.OK_ID).setEnabled(true);
	}
	
	private void setDisableOK(String msg){
		setMessage(msg, IMessageProvider.ERROR);
		getButton(IDialogConstants.OK_ID).setEnabled(false);
	}
	
	//======================================================================
	// Inner Class
	//======================================================================
	class ModifyListenerImpl implements ModifyListener{
		public void modifyText(ModifyEvent e){
			if(!_validateName(nameText_.getText())) return;
			if(focus_ == FOCUS_PROGRAM){
				if(!_validateProgramText(programText_.getText())) return;
			}else if(focus_ == FOCUS_FOLDER){
				if(!_validateFolderText(folderText_.getText())) return;
			}
			setEnableOK();
		}
	}
	class SelectionListenerImpl implements SelectionListener{
		public void widgetSelected(SelectionEvent e){
			if(e.widget == programRadio_){
				focus_ = FOCUS_PROGRAM;
			}else if(e.widget == folderRadio_){
				focus_ = FOCUS_FOLDER;
			}
			if(focus_ == FOCUS_PROGRAM){
				if(!_validateProgramText(programText_.getText())) return;
			}else if(focus_ == FOCUS_FOLDER){
				if(!_validateFolderText(folderText_.getText())) return;
			}
			if(!_validateName(nameText_.getText())) return;
			setEnableOK();
		}
		public void widgetDefaultSelected(SelectionEvent e){
		}
	}
}
