package jp.gr.java_conf.miya.pglauncher.dialogs;

import jp.gr.java_conf.miya.pglauncher.common.Const;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.w3c.dom.Element;

public class ProgramDragListener implements DragSourceListener {

	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private TreeViewer viewer_;
	
	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public ProgramDragListener(TreeViewer viewer){
		viewer_ = viewer;
	}
	
	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void dragStart(DragSourceEvent event) {
		Element el = (Element)((IStructuredSelection)viewer_.getSelection()).getFirstElement();
		if(el.getNodeName().equals(Const.NODE_ROOT)){
			event.doit = false;
			return;
		}
		event.doit = !viewer_.getSelection().isEmpty();
	}

	public void dragSetData(DragSourceEvent event){}

	public void dragFinished(DragSourceEvent event){}
}
