/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.accessor.ResultAccessorAbstract;
import org.phosphoresce.commons.database.accessor.ResultAccessorListener;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumn;
import org.phosphoresce.commons.database.accessor.ResultRowDefinition;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public final class ResultRow
extends ResultAccessorAbstract {
    private ResultRowDefinition definition;
    private int index = -1;
    private List columns = new LinkedList();

    ResultRow(ResultSet resultSet, ResultAccessorState state, ResultAccessorListener listener, ResultRowDefinition definition, int index) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet, state, listener);
        this.definition = definition;
        this.index = index;
        this.refreshResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.definition.refreshResult(force);
        int currentRow = this.getResultSetRowIndex();
        try {
            try {
                block33: {
                    int columnCount;
                    block36: {
                        int i;
                        block35: {
                            block34: {
                                int i2;
                                block32: {
                                    int i3;
                                    columnCount = this.resultSet.getMetaData().getColumnCount();
                                    if (this.state != ResultAccessorState.INSERT_ERROR) break block32;
                                    if (!force) break block33;
                                    for (i3 = 0; i3 <= columnCount - 1; ++i3) {
                                        ResultColumn column = null;
                                        if (i3 <= this.columns.size() - 1) {
                                            column = (ResultColumn)this.columns.get(i3);
                                            column.setRow(this);
                                            column.setIndex(i3);
                                            column.refreshResult(force);
                                            continue;
                                        }
                                        column = new ResultColumn(this.resultSet, this.state, this.listener, this, this.definition.getColumnDefinition(i3), i3);
                                        this.columns.add(column);
                                    }
                                    if (this.columns.size() > columnCount) {
                                        for (i3 = 0; i3 <= this.columns.size() - columnCount - 1; ++i3) {
                                            this.columns.remove(this.columns.size() - 1);
                                        }
                                    }
                                    break block33;
                                }
                                if (this.state != ResultAccessorState.UPDATE_ERROR) break block34;
                                if (!force) break block33;
                                for (i2 = 0; i2 <= columnCount - 1; ++i2) {
                                    ResultColumn column = null;
                                    if (i2 <= this.columns.size() - 1) {
                                        column = (ResultColumn)this.columns.get(i2);
                                        column.setRow(this);
                                        column.setIndex(i2);
                                        column.refreshResult(force);
                                        continue;
                                    }
                                    column = new ResultColumn(this.resultSet, this.state, this.listener, this, this.definition.getColumnDefinition(i2), i2);
                                    this.columns.add(column);
                                }
                                if (this.columns.size() > columnCount) {
                                    for (i2 = 0; i2 <= this.columns.size() - columnCount - 1; ++i2) {
                                        this.columns.remove(this.columns.size() - 1);
                                    }
                                }
                                break block33;
                            }
                            if (this.state == ResultAccessorState.REMOVED || this.state == ResultAccessorState.DELETE || this.state == ResultAccessorState.INSERT_DELETE) break block33;
                            if (this.state != ResultAccessorState.INSERT) break block35;
                            for (int i4 = 0; i4 <= columnCount - 1; ++i4) {
                                ResultColumn column = null;
                                if (i4 <= this.columns.size() - 1) {
                                    column = new ResultColumn(this.resultSet, this.state, this.listener, this, this.definition.getColumnDefinition(i4), i4);
                                    this.columns.add(column);
                                    column = (ResultColumn)this.columns.get(i4);
                                    column.setRow(this);
                                    column.setIndex(i4);
                                    column.refreshResult(force);
                                    continue;
                                }
                                column = new ResultColumn(this.resultSet, this.state, this.listener, this, this.definition.getColumnDefinition(i4), i4);
                                this.columns.add(column);
                            }
                            break block33;
                        }
                        if (this.state != ResultAccessorState.UPDATE) break block36;
                        for (i = 0; i <= columnCount - 1; ++i) {
                            ResultColumn column = null;
                            if (i <= this.columns.size() - 1) {
                                column = (ResultColumn)this.columns.get(i);
                                column.setRow(this);
                                column.setIndex(i);
                                column.refreshResult(force);
                                continue;
                            }
                            column = new ResultColumn(this.resultSet, this.state, this.listener, this, this.definition.getColumnDefinition(i), i);
                            this.columns.add(column);
                        }
                        if (this.columns.size() > columnCount) {
                            for (i = 0; i <= this.columns.size() - columnCount - 1; ++i) {
                                this.columns.remove(this.columns.size() - 1);
                            }
                        }
                        break block33;
                    }
                    if (this.state == ResultAccessorState.STATIC) {
                        int i;
                        for (i = 0; i <= columnCount - 1; ++i) {
                            ResultColumn column = null;
                            if (i <= this.columns.size() - 1) {
                                column = (ResultColumn)this.columns.get(i);
                                column.setRow(this);
                                column.setIndex(i);
                                column.refreshResult(force);
                                continue;
                            }
                            column = new ResultColumn(this.resultSet, this.state, this.listener, this, this.definition.getColumnDefinition(i), i);
                            this.columns.add(column);
                        }
                        if (this.columns.size() > columnCount) {
                            for (i = 0; i <= this.columns.size() - columnCount - 1; ++i) {
                                this.columns.remove(this.columns.size() - 1);
                            }
                        }
                    }
                }
                Object var7_21 = null;
            }
            catch (SQLException e) {
                if (this.state == ResultAccessorState.INSERT) {
                    this.state = ResultAccessorState.INSERT_ERROR;
                    Iterator iterator = this.columns.iterator();
                    while (iterator.hasNext()) {
                        ResultColumn column = (ResultColumn)iterator.next();
                        column.state = ResultAccessorState.INSERT_ERROR;
                    }
                } else if (this.state == ResultAccessorState.INSERT_ERROR) {
                    this.state = ResultAccessorState.INSERT_ERROR;
                    Iterator iterator = this.columns.iterator();
                    while (iterator.hasNext()) {
                        ResultColumn column = (ResultColumn)iterator.next();
                        column.state = ResultAccessorState.INSERT_ERROR;
                    }
                } else {
                    this.state = ResultAccessorState.UPDATE_ERROR;
                    Iterator iterator = this.columns.iterator();
                    while (iterator.hasNext()) {
                        ResultColumn column = (ResultColumn)iterator.next();
                        column.state = ResultAccessorState.UPDATE_ERROR;
                    }
                }
                this.error = new DatabaseError(this.index, e);
                Object var7_22 = null;
                this.moveCurser(currentRow);
                if (!this.validateStateListener()) return;
                this.listener.rowUpdated(this.index, this.index);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_23 = null;
            this.moveCurser(currentRow);
            if (!this.validateStateListener()) throw throwable;
            this.listener.rowUpdated(this.index, this.index);
            throw throwable;
        }
        this.moveCurser(currentRow);
        if (!this.validateStateListener()) return;
        this.listener.rowUpdated(this.index, this.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        block32: {
            int currentRow = this.getResultSetRowIndex();
            try {
                block31: {
                    this.error = null;
                    int columnCount = this.resultSet.getMetaData().getColumnCount();
                    if (this.state == ResultAccessorState.INSERT_ERROR) {
                        ResultColumn column;
                        int i;
                        this.resultSet.moveToInsertRow();
                        boolean hasError = false;
                        for (i = 0; i <= columnCount - 1; ++i) {
                            column = (ResultColumn)this.columns.get(i);
                            column.updateResult();
                            if (!column.hasError()) continue;
                            hasError = true;
                        }
                        if (!hasError) {
                            this.resultSet.insertRow();
                            this.state = ResultAccessorState.STATIC;
                            this.resultSet.last();
                            this.index = this.resultSet.getRow() - 1;
                        } else {
                            this.state = ResultAccessorState.INSERT_ERROR;
                            for (i = 0; i <= columnCount - 1; ++i) {
                                column = (ResultColumn)this.columns.get(i);
                                if (column.state == ResultAccessorState.INSERT_ERROR) continue;
                                column.state = ResultAccessorState.INSERT;
                            }
                        }
                        break block31;
                    }
                    if (this.state == ResultAccessorState.UPDATE_ERROR) {
                        for (int i = 0; i <= columnCount - 1; ++i) {
                            ResultColumn column = (ResultColumn)this.columns.get(i);
                            column.updateResult();
                        }
                        this.state = ResultAccessorState.STATIC;
                        break block31;
                    }
                    if (this.state == ResultAccessorState.REMOVED) break block31;
                    if (this.state == ResultAccessorState.DELETE) {
                        if (this.index >= 0) {
                            this.resultSet.absolute(this.index + 1);
                            this.resultSet.deleteRow();
                        }
                        this.state = ResultAccessorState.REMOVED;
                        break block31;
                    }
                    if (this.state == ResultAccessorState.INSERT_DELETE) break block31;
                    if (this.state == ResultAccessorState.INSERT) {
                        ResultColumn column;
                        int i;
                        this.resultSet.moveToInsertRow();
                        boolean hasError = false;
                        for (i = 0; i <= columnCount - 1; ++i) {
                            column = (ResultColumn)this.columns.get(i);
                            column.updateResult();
                            if (!column.hasError()) continue;
                            hasError = true;
                        }
                        if (!hasError) {
                            this.resultSet.insertRow();
                            this.state = ResultAccessorState.STATIC;
                            this.resultSet.last();
                            this.index = this.resultSet.getRow() - 1;
                        } else {
                            this.state = ResultAccessorState.INSERT_ERROR;
                            for (i = 0; i <= columnCount - 1; ++i) {
                                column = (ResultColumn)this.columns.get(i);
                                if (column.state == ResultAccessorState.INSERT_ERROR) continue;
                                column.state = ResultAccessorState.INSERT;
                            }
                        }
                        break block31;
                    }
                    if (this.state == ResultAccessorState.UPDATE) {
                        for (int i = 0; i <= columnCount - 1; ++i) {
                            ResultColumn column = (ResultColumn)this.columns.get(i);
                            column.updateResult();
                        }
                        this.state = ResultAccessorState.STATIC;
                        break block31;
                    }
                    if (this.state != ResultAccessorState.STATIC) break block31;
                    for (int i = 0; i <= columnCount - 1; ++i) {
                        ResultColumn column = (ResultColumn)this.columns.get(i);
                        column.updateResult();
                    }
                    this.state = ResultAccessorState.STATIC;
                }
                Object var7_22 = null;
            }
            catch (Throwable throwable) {
                Object var7_24 = null;
                this.moveCurser(currentRow);
                if (this.validateStateListener()) {
                    this.listener.rowUpdated(this.index, this.index);
                }
                throw throwable;
            }
            this.moveCurser(currentRow);
            if (this.validateStateListener()) {
                this.listener.rowUpdated(this.index, this.index);
            }
            break block32;
            {
                catch (SQLException e) {
                    if (this.state == ResultAccessorState.INSERT) {
                        this.state = ResultAccessorState.INSERT_ERROR;
                        Iterator iterator = this.columns.iterator();
                        while (iterator.hasNext()) {
                            ResultColumn column = (ResultColumn)iterator.next();
                            column.state = ResultAccessorState.INSERT_ERROR;
                        }
                    } else if (this.state == ResultAccessorState.INSERT_ERROR) {
                        this.state = ResultAccessorState.INSERT_ERROR;
                        Iterator iterator = this.columns.iterator();
                        while (iterator.hasNext()) {
                            ResultColumn column = (ResultColumn)iterator.next();
                            column.state = ResultAccessorState.INSERT_ERROR;
                        }
                    } else {
                        this.state = ResultAccessorState.UPDATE_ERROR;
                        Iterator iterator = this.columns.iterator();
                        while (iterator.hasNext()) {
                            ResultColumn column = (ResultColumn)iterator.next();
                            column.state = ResultAccessorState.UPDATE_ERROR;
                        }
                    }
                    this.error = new DatabaseError(this.index, e);
                    Object var7_23 = null;
                    this.moveCurser(currentRow);
                    if (this.validateStateListener()) {
                        this.listener.rowUpdated(this.index, this.index);
                    }
                }
            }
        }
    }

    public ResultRowDefinition getDefinition() {
        return this.definition;
    }

    public int getIndex() {
        return this.index;
    }

    public ResultColumn getColumn(int index) throws IllegalResultSetLocationIndexException {
        if (this.columns.size() - 1 < index || index < 0) {
            throw new IllegalResultSetLocationIndexException("illegal column index. [" + index + "]");
        }
        return (ResultColumn)this.columns.get(index);
    }

    public ResultColumn getColumn(String name) throws IllegalResultSetLocationIndexException {
        return this.getColumn(this.definition.getColumnIndex(name));
    }

    final void setColumn(int index, ResultColumn column) throws IllegalResultSetLocationIndexException {
        if (this.columns.size() - 1 < index || index < 0) {
            throw new IllegalResultSetLocationIndexException("illegal column index. [" + index + "]");
        }
        this.columns.set(index, column);
    }

    final void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

