/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public class DatabaseQueryspec {
    private DatabaseSession session;

    public DatabaseQueryspec(DatabaseSession session) {
        this.session = session;
    }

    private DatabaseQueryspec() {
        this(null);
    }

    private DatabaseMetaData getDatabaseMetaData() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database meta data.", e);
        }
    }

    public String getExtraNameCharacters() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getExtraNameCharacters();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get extra name characters.", e);
        }
    }

    public String getIdentifierQuoteString() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getIdentifierQuoteString();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get identifier quote string.", e);
        }
    }

    public List getNumericFunctionList() throws DatabaseSessionException, ResultSetAccessException {
        try {
            LinkedList<String> list = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.session.getConnection().getMetaData().getNumericFunctions(), ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get numeric function list.", e);
        }
    }

    public String getSearchStringEscape() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getSearchStringEscape();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get search string escape.", e);
        }
    }

    public List getSQLKeywordList() throws DatabaseSessionException, ResultSetAccessException {
        try {
            LinkedList<String> list = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.session.getConnection().getMetaData().getSQLKeywords(), ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get SQL keyword list.", e);
        }
    }

    public List getSystemFunctionList() throws DatabaseSessionException, ResultSetAccessException {
        try {
            LinkedList<String> list = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.session.getConnection().getMetaData().getSystemFunctions(), ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get system function list.", e);
        }
    }

    public List getTimeDateFunctionList() throws DatabaseSessionException, ResultSetAccessException {
        try {
            LinkedList<String> list = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.session.getConnection().getMetaData().getTimeDateFunctions(), ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get time date function list.", e);
        }
    }
}

